/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ZstdInputStreamV04
extends FilterInputStream {
    private long ctx = ZstdInputStreamV04.createDCtx();
    private static final int blockSize = 131072;
    private static final int iBuffSize = 131072;
    private int oBuffSize = -1;
    private ByteBuffer oBuff = null;
    private int oPos = 0;
    private int oEnd = 0;
    private byte[] iBuff = new byte[131072];

    private static native long createDCtx();

    private static native long freeDCtx(long var0);

    private static native int findOBuffSize(byte[] var0, long var1);

    private static native long nextSrcSizeToDecompress(long var0);

    private static native long decompressContinue(long var0, ByteBuffer var2, long var3, long var5, byte[] var7, long var8);

    public ZstdInputStreamV04(InputStream inputStream, byte[] byArray, int n) throws IOException {
        super(inputStream);
        if (this.iBuff == null) {
            throw new IOException("Error allocating the input buffer of size 131072");
        }
        while (this.oBuffSize < 0) {
            this.oBuffSize = ZstdInputStreamV04.findOBuffSize(byArray, n);
            if (this.oBuffSize >= 0) continue;
            n += this.in.read(byArray, n, -this.oBuffSize - n);
        }
        this.oBuff = ByteBuffer.allocateDirect(this.oBuffSize);
        if (this.oBuff == null) {
            throw new IOException("Error allocating the output buffers of size " + this.oBuffSize);
        }
        long l = ZstdInputStreamV04.nextSrcSizeToDecompress(this.ctx);
        long l2 = ZstdInputStreamV04.decompressContinue(this.ctx, this.oBuff, this.oPos, this.oBuffSize - this.oPos, byArray, l);
        if (Zstd.isError(l2)) {
            throw new IOException("Decode Error: " + Zstd.getErrorName(l2));
        }
        this.oEnd = (int)((long)this.oEnd + l2);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("Requested lenght " + n2 + " exceeds the buffer size " + byArray.length + " from offset " + n);
        }
        while (this.oEnd == this.oPos) {
            long l;
            n3 = 0;
            long l2 = ZstdInputStreamV04.nextSrcSizeToDecompress(this.ctx);
            if (l2 == 0L) {
                return -1;
            }
            if (this.oBuffSize - this.oPos < 131072) {
                this.oPos = 0;
                this.oEnd = 0;
            }
            while ((long)n3 < l2) {
                l = this.in.read(this.iBuff, n3, (int)l2 - n3);
                if (l > 0L) {
                    n3 = (int)((long)n3 + l);
                    continue;
                }
                throw new IOException("Read error or truncated source");
            }
            l = ZstdInputStreamV04.decompressContinue(this.ctx, this.oBuff, this.oPos, this.oBuffSize - this.oPos, this.iBuff, n3);
            if (Zstd.isError(l)) {
                throw new IOException("Decode Error: " + Zstd.getErrorName(l));
            }
            this.oEnd += (int)l;
        }
        n3 = Math.min(n2, this.oEnd - this.oPos);
        this.oBuff.position(this.oPos);
        this.oBuff.get(byArray, n, n3);
        this.oPos += n3;
        return n3;
    }

    @Override
    public int available() throws IOException {
        return this.oEnd - this.oPos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long l) {
        if (l <= (long)(this.oEnd - this.oPos)) {
            this.oPos = (int)((long)this.oPos + l);
            return l;
        }
        long l2 = this.oEnd - this.oPos;
        this.oPos = this.oEnd;
        return l2;
    }

    @Override
    public void close() throws IOException {
        ZstdInputStreamV04.freeDCtx(this.ctx);
        this.in.close();
    }

    static {
        Native.load();
    }
}

