/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.printconnectintentswrapper;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import com.zebra.printconnectintentswrapper.PCConstants;
import com.zebra.printconnectintentswrapper.PCGraphicPrintSettings;
import com.zebra.printconnectintentswrapper.PCIntentsBase;
import com.zebra.printconnectintentswrapper.PCIntentsBaseSettings;

public class PCGraphicPrint
extends PCIntentsBase {
    private onPrintGraphicResult mGraphicPrintCallback = null;

    public PCGraphicPrint(Context aContext) {
        super(aContext);
    }

    public void execute(PCGraphicPrintSettings settings, onPrintGraphicResult callback) {
        if (callback == null) {
            Log.e((String)TAG, (String)"Error: callback member is null.");
            return;
        }
        this.mGraphicPrintCallback = callback;
        if (settings.mFileName.isEmpty() && this.mGraphicPrintCallback != null) {
            this.mGraphicPrintCallback.error("Error: no filename specified.", -1, null, settings);
        }
        super.execute(settings);
        this.PrintGraphicFileName(settings);
    }

    private void PrintGraphicFileName(final PCGraphicPrintSettings settings) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.zebra.printconnect", "com.zebra.printconnect.print.GraphicPrintService"));
        intent.putExtra("com.zebra.printconnect.PrintService.GRAPHIC_FILE_NAME", settings.mFileName);
        intent.putExtra("com.zebra.printconnect.PrintService.GRAPHIC_FILE_ROTATION", settings.mRotation.toInt());
        intent.putExtra("com.zebra.printconnect.PrintService.GRAPHIC_FILE_MARGIN_TOP", settings.mMarginTop);
        intent.putExtra("com.zebra.printconnect.PrintService.GRAPHIC_FILE_MARGIN_LEFT", settings.mMarginLeft);
        intent.putExtra("com.zebra.printconnect.PrintService.GRAPHIC_FILE_MARGIN_BOTTOM", settings.mMarginBottom);
        intent.putExtra("com.zebra.printconnect.PrintService.GRAPHIC_FILE_CENTER", settings.mCenter);
        int scaleX = Math.max(5, settings.mScaleX);
        scaleX = Math.min(scaleX, 300);
        intent.putExtra("com.zebra.printconnect.PrintService.GRAPHIC_FILE_SCALE_X", scaleX);
        int scaleY = Math.max(5, settings.mScaleY);
        scaleY = Math.min(scaleY, 300);
        intent.putExtra("com.zebra.printconnect.PrintService.GRAPHIC_FILE_SCALE_Y", scaleY);
        ResultReceiver receiver = this.buildIPCSafeReceiver(new ResultReceiver(null){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                PCGraphicPrint.this.cleanAll();
                if (resultCode == 0) {
                    if (PCGraphicPrint.this.mGraphicPrintCallback != null) {
                        PCGraphicPrint.this.mGraphicPrintCallback.success(settings);
                    }
                } else {
                    String errorMessage = resultData.getString("com.zebra.printconnect.PrintService.ERROR_MESSAGE");
                    if (errorMessage == null) {
                        errorMessage = PCConstants.getErrorMessage(resultCode);
                    }
                    if (PCGraphicPrint.this.mGraphicPrintCallback != null) {
                        PCGraphicPrint.this.mGraphicPrintCallback.error(errorMessage, resultCode, resultData, settings);
                    }
                }
            }
        });
        intent.putExtra("com.zebra.printconnect.PrintService.RESULT_RECEIVER", (Parcelable)receiver);
        this.mContext.startService(intent);
    }

    @Override
    protected void onTimeOut(PCIntentsBaseSettings settings) {
        if (this.mGraphicPrintCallback != null) {
            this.mGraphicPrintCallback.timeOut((PCGraphicPrintSettings)settings);
        }
    }

    public static interface onPrintGraphicResult {
        public void success(PCGraphicPrintSettings var1);

        public void error(String var1, int var2, Bundle var3, PCGraphicPrintSettings var4);

        public void timeOut(PCGraphicPrintSettings var1);
    }
}

