/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.deviceidentifierswrapper;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import com.symbol.emdk.EMDKBase;
import com.symbol.emdk.EMDKException;
import com.symbol.emdk.EMDKManager;
import com.symbol.emdk.EMDKResults;
import com.symbol.emdk.ProfileManager;
import com.zebra.deviceidentifierswrapper.DICommandBase;
import com.zebra.deviceidentifierswrapper.DICommandBaseSettings;
import com.zebra.deviceidentifierswrapper.DIHelper;
import com.zebra.deviceidentifierswrapper.EMessageType;
import com.zebra.deviceidentifierswrapper.IDIResultCallbacks;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class DIProfileManagerCommand
extends DICommandBase {
    private String TAG = "DIWrapperMX";
    private IDIResultCallbacks idiProfileManagerCommandResult = null;
    private String msProfileData = "";
    private String msProfileName = "";
    private ProfileManager mProfileManager = null;
    private EMDKManager mEMDKManager = null;
    private ArrayList<ErrorHolder> mErrors = new ArrayList();
    public String msErrorString = "";
    private boolean bInitializing = false;
    EMDKManager.StatusListener mStatusListener = new EMDKManager.StatusListener(){

        public void onStatus(EMDKManager.StatusData statusData, EMDKBase emdkBase) {
            if (statusData.getResult() == EMDKResults.STATUS_CODE.SUCCESS) {
                DIProfileManagerCommand.this.logMessage("Profile manager retrieved.", EMessageType.DEBUG);
                DIProfileManagerCommand.this.onProfileManagerInitialized((ProfileManager)emdkBase);
            } else {
                String errorMessage = "Error when trying to retrieve ProfileManager: " + DIProfileManagerCommand.this.getResultCode(statusData.getResult());
                DIProfileManagerCommand.this.logMessage(errorMessage, EMessageType.ERROR);
            }
        }
    };
    EMDKManager.EMDKListener mEMDKListener = new EMDKManager.EMDKListener(){

        public void onOpened(EMDKManager emdkManager) {
            DIProfileManagerCommand.this.logMessage("EMDKManager.EMDKListener.onOpened", EMessageType.DEBUG);
            DIProfileManagerCommand.this.onEMDKManagerRetrieved(emdkManager);
        }

        public void onClosed() {
            DIProfileManagerCommand.this.logMessage("EMDKManager.EMDKListener.onClosed", EMessageType.DEBUG);
            DIProfileManagerCommand.this.onEMDKManagerClosed();
        }
    };

    public DIProfileManagerCommand(Context aContext) {
        super(aContext);
        this.mSettings = new DICommandBaseSettings(){
            {
                this.mTimeOutMS = 20000L;
                this.mEnableTimeOutMechanism = true;
                this.mCommandId = "DWProfileManagerCommand";
            }
        };
    }

    @Override
    protected void onTimeOut(DICommandBaseSettings settings) {
        super.onTimeOut(settings);
        this.onEMDKManagerClosed();
    }

    public void execute(String mxProfile, String mxProfileName, IDIResultCallbacks resutCallback) {
        super.execute(this.mSettings);
        this.idiProfileManagerCommandResult = resutCallback;
        this.msProfileData = mxProfile;
        this.msProfileName = mxProfileName;
        this.initializeEMDK();
    }

    private void initializeEMDK() {
        if (this.bInitializing) {
            return;
        }
        this.bInitializing = true;
        if (this.mEMDKManager == null) {
            EMDKResults results = null;
            try {
                results = EMDKManager.getEMDKManager((Context)this.mContext.getApplicationContext(), (EMDKManager.EMDKListener)this.mEMDKListener);
            }
            catch (Exception e) {
                this.logMessage("Error while requesting EMDKManager.\n" + e.getLocalizedMessage(), EMessageType.ERROR);
                e.printStackTrace();
                this.waitForEMDK();
                return;
            }
            if (results.statusCode == EMDKResults.STATUS_CODE.SUCCESS) {
                this.logMessage("EMDKManager request command issued with success", EMessageType.DEBUG);
            } else {
                this.logMessage("EMDKManager request command error", EMessageType.ERROR);
                this.waitForEMDK();
            }
        } else {
            this.onEMDKManagerRetrieved(this.mEMDKManager);
        }
    }

    private void waitForEMDK() {
        this.logMessage("EMDKManager error, this could be a BOOT_COMPLETED issue.", EMessageType.DEBUG);
        this.logMessage("Starting watcher thread to wait for EMDK initialization.", EMessageType.DEBUG);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                long startDate = new Date().getTime();
                long delta = 0L;
                while (DIProfileManagerCommand.this.mEMDKManager == null || delta < DIHelper.MAX_EMDK_TIMEOUT_IN_MS) {
                    DIProfileManagerCommand.this.logMessage("Calling EMDK Initialization method", EMessageType.DEBUG);
                    DIProfileManagerCommand.this.initializeEMDK();
                    try {
                        DIProfileManagerCommand.this.logMessage("Waiting " + DIHelper.WAIT_PERIOD_BEFORE_RETRY_EMDK_RETRIEVAL_IN_MS + " milliseconds before retrying.", EMessageType.DEBUG);
                        Thread.sleep(DIHelper.WAIT_PERIOD_BEFORE_RETRY_EMDK_RETRIEVAL_IN_MS);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    delta = new Date().getTime() - startDate;
                    DIProfileManagerCommand.this.logMessage("Delta in ms since first EMDK retrieval try: " + delta + "ms stops at " + DIHelper.MAX_EMDK_TIMEOUT_IN_MS + "ms", EMessageType.DEBUG);
                }
                DIProfileManagerCommand.this.bInitializing = false;
                DIProfileManagerCommand.this.logMessage("Could not retrieve EMDK Manager after waiting " + DIHelper.WAIT_PERIOD_BEFORE_RETRY_EMDK_RETRIEVAL_IN_MS / 1000L + " seconds. Please contact your administrator or check logcat for any EMDK related error.", EMessageType.ERROR);
            }
        });
        t.setPriority(1);
        t.start();
    }

    private void onEMDKManagerRetrieved(EMDKManager emdkManager) {
        this.mEMDKManager = emdkManager;
        this.logMessage("EMDK Manager retrieved.", EMessageType.DEBUG);
        if (this.mProfileManager == null) {
            try {
                this.logMessage("Requesting profile manager.", EMessageType.DEBUG);
                emdkManager.getInstanceAsync(EMDKManager.FEATURE_TYPE.PROFILE, this.mStatusListener);
            }
            catch (EMDKException e) {
                this.logMessage("Error when trying to retrieve profile manager: " + e.getMessage(), EMessageType.ERROR);
            }
        } else {
            this.logMessage("EMDK Manager already initialized.", EMessageType.DEBUG);
            this.onProfileManagerInitialized(this.mProfileManager);
        }
    }

    private void onEMDKManagerClosed() {
        this.releaseManagers();
    }

    private void releaseManagers() {
        if (this.mProfileManager != null) {
            this.mProfileManager = null;
            this.logMessage("Profile Manager reseted.", EMessageType.DEBUG);
        }
        if (this.mEMDKManager != null) {
            this.mEMDKManager.release();
            this.logMessage("EMDKManager released.", EMessageType.DEBUG);
            this.mEMDKManager = null;
            this.logMessage("EMDKManager reseted.", EMessageType.DEBUG);
        }
    }

    private void onProfileManagerInitialized(ProfileManager profileManager) {
        this.mProfileManager = profileManager;
        this.bInitializing = false;
        this.logMessage("Processing MX Content", EMessageType.DEBUG);
        this.processMXContent();
    }

    private void onProfileExecutedWithSuccess() {
        this.releaseManagers();
        if (this.idiProfileManagerCommandResult != null) {
            this.idiProfileManagerCommandResult.onSuccess("Success applying profile:" + this.msProfileName + "\nProfileData:" + this.msProfileData);
        }
    }

    private void onProfileExecutedError(String message) {
        this.releaseManagers();
        if (this.idiProfileManagerCommandResult != null) {
            this.idiProfileManagerCommandResult.onError("Error on profile: " + this.msProfileName + "\nError:" + message + "\nProfileData:" + this.msProfileData);
        }
    }

    private void onProfileExecutedStatusChanged(String message) {
        if (this.idiProfileManagerCommandResult != null) {
            this.idiProfileManagerCommandResult.onDebugStatus(message);
        }
    }

    private void processMXContent() {
        String[] params = new String[]{this.msProfileData};
        this.logMessage("Processing profile :" + this.msProfileData, EMessageType.VERBOSE);
        EMDKResults results = this.mProfileManager.processProfile(this.msProfileName, ProfileManager.PROFILE_FLAG.SET, params);
        if (results.statusCode == EMDKResults.STATUS_CODE.CHECK_XML) {
            String statusXMLResponse = results.getStatusString();
            try {
                this.mErrors.clear();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput((Reader)new StringReader(statusXMLResponse));
                this.parseXML(parser);
                if (this.mErrors.size() != 0) {
                    String errorMessage = "";
                    for (ErrorHolder error : this.mErrors) {
                        errorMessage = errorMessage + "Profile processing error.\tType:" + error.sErrorType + "\tParamName:" + error.sParmName + "\tDescription:" + error.sErrorDescription;
                    }
                    this.logMessage(errorMessage, EMessageType.ERROR);
                    this.onProfileExecutedError(errorMessage);
                    return;
                }
                this.logMessage("Profile executed with success: " + this.msProfileName, EMessageType.SUCCESS);
                this.onProfileExecutedWithSuccess();
            }
            catch (XmlPullParserException e) {
                String errorMessage = "Error while trying to parse ProfileManager XML Response: " + e.getLocalizedMessage();
                this.logMessage(errorMessage, EMessageType.ERROR);
                this.onProfileExecutedError(errorMessage);
                return;
            }
        } else {
            if (results.statusCode == EMDKResults.STATUS_CODE.SUCCESS) {
                this.logMessage("Profile executed with success: " + this.msProfileName, EMessageType.DEBUG);
                this.onProfileExecutedWithSuccess();
                return;
            }
            String errorMessage = "Profile update failed." + this.getResultCode(results.statusCode) + "\nProfil:\n" + this.msProfileName;
            this.logMessage(errorMessage, EMessageType.ERROR);
            this.onProfileExecutedError(errorMessage);
            return;
        }
    }

    private void parseXML(XmlPullParser myParser) {
        try {
            int event = myParser.getEventType();
            ErrorHolder tempErrorHolder = null;
            while (event != 1) {
                String name = myParser.getName();
                switch (event) {
                    case 2: {
                        if (name.equals("characteristic-error")) {
                            if (tempErrorHolder == null) {
                                tempErrorHolder = new ErrorHolder();
                            }
                            tempErrorHolder.sErrorType = myParser.getAttributeValue(null, "type");
                            if (tempErrorHolder.sParmName == null || TextUtils.isEmpty((CharSequence)tempErrorHolder.sParmName)) break;
                            this.msErrorString = this.msErrorString + "Nom: " + tempErrorHolder.sParmName + "\nType: " + tempErrorHolder.sErrorType + "\nDescription: " + tempErrorHolder.sErrorDescription + ")";
                            this.mErrors.add(tempErrorHolder);
                            tempErrorHolder = null;
                            break;
                        }
                        if (!name.equals("parm-error")) break;
                        if (tempErrorHolder == null) {
                            tempErrorHolder = new ErrorHolder();
                        }
                        tempErrorHolder.sParmName = myParser.getAttributeValue(null, "name");
                        tempErrorHolder.sErrorDescription = myParser.getAttributeValue(null, "desc");
                        if (tempErrorHolder.sErrorType == null || TextUtils.isEmpty((CharSequence)tempErrorHolder.sErrorType)) break;
                        this.msErrorString = this.msErrorString + "Nom: " + tempErrorHolder.sParmName + "\nType: " + tempErrorHolder.sErrorType + "\nDescription: " + tempErrorHolder.sErrorDescription + ")";
                        this.mErrors.add(tempErrorHolder);
                        tempErrorHolder = null;
                        break;
                    }
                }
                event = myParser.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void logMessage(String message, EMessageType messageType) {
        switch (messageType) {
            case ERROR: {
                Log.e((String)this.TAG, (String)message);
                this.onProfileExecutedStatusChanged("ERROR:" + message);
                break;
            }
            case SUCCESS: {
                Log.v((String)this.TAG, (String)message);
                this.onProfileExecutedStatusChanged("SUCCESS:" + message);
                break;
            }
            case VERBOSE: {
                Log.v((String)this.TAG, (String)message);
                this.onProfileExecutedStatusChanged("VERBOSE:" + message);
                break;
            }
            case WARNING: {
                Log.w((String)this.TAG, (String)message);
                this.onProfileExecutedStatusChanged("WARNING:" + message);
                break;
            }
            case DEBUG: {
                Log.d((String)this.TAG, (String)message);
                this.onProfileExecutedStatusChanged("DEBUG:" + message);
            }
        }
    }

    private String getResultCode(EMDKResults.STATUS_CODE aStatusCode) {
        switch (aStatusCode) {
            case FAILURE: {
                return "FAILURE";
            }
            case NULL_POINTER: {
                return "NULL_POINTER";
            }
            case EMPTY_PROFILENAME: {
                return "EMPTY_PROFILENAME";
            }
            case EMDK_NOT_OPENED: {
                return "EMDK_NOT_OPENED";
            }
            case CHECK_XML: {
                return "CHECK_XML";
            }
            case PREVIOUS_REQUEST_IN_PROGRESS: {
                return "PREVIOUS_REQUEST_IN_PROGRESS";
            }
            case PROCESSING: {
                return "PROCESSING";
            }
            case NO_DATA_LISTENER: {
                return "NO_DATA_LISTENER";
            }
            case FEATURE_NOT_READY_TO_USE: {
                return "FEATURE_NOT_READY_TO_USE";
            }
            case FEATURE_NOT_SUPPORTED: {
                return "FEATURE_NOT_SUPPORTED";
            }
        }
        return "UNKNOWN";
    }

    public class ErrorHolder {
        public String sErrorType = "";
        public String sParmName = "";
        public String sErrorDescription = "";
    }
}

