/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.deviceidentifierswrapper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import androidx.core.content.ContextCompat;
import com.zebra.deviceidentifierswrapper.IDIResultCallbacks;
import com.zebra.deviceidentifierswrapper.RetrieveOEMInfoTask;

public class DIHelper {
    public static Signature apkCertificate = null;

    public static void getSerialNumber(Context context, IDIResultCallbacks callbackInterface) {
        if (Build.VERSION.SDK_INT < 29) {
            DIHelper.returnSerialUsingAndroidAPIs(context, callbackInterface);
        } else {
            DIHelper.returnSerialUsingZebraAPIs(context, callbackInterface);
        }
    }

    @SuppressLint(value={"MissingPermission", "ObsoleteSdkInt", "HardwareIds"})
    private static void returnSerialUsingAndroidAPIs(Context context, IDIResultCallbacks callbackInterface) {
        if (Build.VERSION.SDK_INT < 26) {
            callbackInterface.onSuccess(Build.SERIAL);
        } else if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            callbackInterface.onSuccess(Build.getSerial());
        } else {
            callbackInterface.onError("Please grant READ_PHONE_STATE permission");
        }
    }

    private static void returnSerialUsingZebraAPIs(Context context, IDIResultCallbacks callbackInterface) {
        new RetrieveOEMInfoTask().execute(new Object[]{context, Uri.parse((String)"content://oem_info/oem.zebra.secure/build_serial"), callbackInterface});
    }

    public static void getIMEINumber(Context context, IDIResultCallbacks callbackInterface) {
        if (Build.VERSION.SDK_INT < 29) {
            DIHelper.returnImeiUsingAndroidAPIs(context, callbackInterface);
        } else {
            DIHelper.returnImeiUsingZebraAPIs(context, callbackInterface);
        }
    }

    @SuppressLint(value={"MissingPermission", "ObsoleteSdkInt", "HardwareIds"})
    private static void returnImeiUsingAndroidAPIs(Context context, IDIResultCallbacks callbackInterface) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (Build.VERSION.SDK_INT < 26) {
            String imei = telephonyManager.getDeviceId();
            if (imei != null && !imei.isEmpty()) {
                callbackInterface.onSuccess(imei);
            } else {
                callbackInterface.onError("Could not get IMEI number");
            }
        } else if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            String imei = telephonyManager.getImei();
            if (imei != null && !imei.isEmpty()) {
                callbackInterface.onSuccess(imei);
            } else {
                callbackInterface.onError("Could not get IMEI number");
            }
        } else {
            callbackInterface.onError("Please grant READ_PHONE_STATE permission");
        }
    }

    private static void returnImeiUsingZebraAPIs(Context context, IDIResultCallbacks callbackInterface) {
        new RetrieveOEMInfoTask().execute(new Object[]{context, Uri.parse((String)"content://oem_info/wan/imei"), callbackInterface});
    }
}

