/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.deviceidentifierswrapper;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import androidx.core.content.ContextCompat;
import com.zebra.deviceidentifierswrapper.IDIResultCallbacks;
import com.zebra.deviceidentifierswrapper.RetrieveOEMInfoTask;

public class DIHelper {
    public static Signature apkCertificate = null;
    protected static String sIMEI = null;
    protected static String sSerialNumber = null;
    protected static String sBtMacAddress = null;
    public static final long SEC_IN_MS = 1000L;
    public static final long MIN_IN_MS = 60000L;
    public static long MAX_EMDK_TIMEOUT_IN_MS = 600000L;
    public static long WAIT_PERIOD_BEFORE_RETRY_EMDK_RETRIEVAL_IN_MS = 2000L;

    public static void resetCachedValues() {
        sIMEI = null;
        sSerialNumber = null;
    }

    public static void getSerialNumber(Context context, IDIResultCallbacks callbackInterface) {
        if (sSerialNumber != null) {
            if (callbackInterface != null) {
                callbackInterface.onDebugStatus("Serial number already in cache.");
            }
            callbackInterface.onSuccess(sSerialNumber);
            return;
        }
        if (Build.VERSION.SDK_INT < 29) {
            DIHelper.returnSerialUsingAndroidAPIs(context, callbackInterface);
        } else {
            DIHelper.returnSerialUsingZebraAPIs(context, callbackInterface);
        }
    }

    @SuppressLint(value={"MissingPermission", "ObsoleteSdkInt", "HardwareIds"})
    private static void returnSerialUsingAndroidAPIs(Context context, IDIResultCallbacks callbackInterface) {
        if (Build.VERSION.SDK_INT < 26) {
            sSerialNumber = Build.SERIAL;
            callbackInterface.onSuccess(Build.SERIAL);
        } else if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            sSerialNumber = Build.getSerial();
            callbackInterface.onSuccess(Build.getSerial());
        } else {
            callbackInterface.onError("Please grant READ_PHONE_STATE permission");
        }
    }

    private static void returnSerialUsingZebraAPIs(Context context, final IDIResultCallbacks callbackInterface) {
        IDIResultCallbacks tempCallbackInterface = new IDIResultCallbacks(){

            @Override
            public void onSuccess(String message) {
                sSerialNumber = message;
                callbackInterface.onSuccess(message);
            }

            @Override
            public void onError(String message) {
                callbackInterface.onError(message);
            }

            @Override
            public void onDebugStatus(String message) {
                callbackInterface.onDebugStatus(message);
            }
        };
        new RetrieveOEMInfoTask().executeAsync(context, Uri.parse((String)"content://oem_info/oem.zebra.secure/build_serial"), tempCallbackInterface);
    }

    public static void getIMEINumber(Context context, IDIResultCallbacks callbackInterface) {
        if (sIMEI != null) {
            if (callbackInterface != null) {
                callbackInterface.onDebugStatus("IMEI number already in cache.");
            }
            callbackInterface.onSuccess(sIMEI);
            return;
        }
        if (Build.VERSION.SDK_INT < 29) {
            DIHelper.returnImeiUsingAndroidAPIs(context, callbackInterface);
        } else {
            DIHelper.returnImeiUsingZebraAPIs(context, callbackInterface);
        }
    }

    @SuppressLint(value={"MissingPermission", "ObsoleteSdkInt", "HardwareIds"})
    private static void returnImeiUsingAndroidAPIs(Context context, IDIResultCallbacks callbackInterface) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (Build.VERSION.SDK_INT < 26) {
            String imei = telephonyManager.getDeviceId();
            if (imei != null && !imei.isEmpty()) {
                sIMEI = imei;
                callbackInterface.onSuccess(imei);
            } else {
                callbackInterface.onError("Could not get IMEI number");
            }
        } else if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            String imei = telephonyManager.getImei();
            if (imei != null && !imei.isEmpty()) {
                sIMEI = imei;
                callbackInterface.onSuccess(imei);
            } else {
                callbackInterface.onError("Could not get IMEI number");
            }
        } else {
            callbackInterface.onError("Please grant READ_PHONE_STATE permission");
        }
    }

    private static void returnImeiUsingZebraAPIs(Context context, final IDIResultCallbacks callbackInterface) {
        IDIResultCallbacks tempCallbackInterface = new IDIResultCallbacks(){

            @Override
            public void onSuccess(String message) {
                sIMEI = message;
                callbackInterface.onSuccess(message);
            }

            @Override
            public void onError(String message) {
                callbackInterface.onError(message);
            }

            @Override
            public void onDebugStatus(String message) {
                callbackInterface.onDebugStatus(message);
            }
        };
        new RetrieveOEMInfoTask().executeAsync(context, Uri.parse((String)"content://oem_info/wan/imei"), tempCallbackInterface);
    }

    public static void getBtMacAddress(Context context, IDIResultCallbacks callbackInterface) {
        if (sBtMacAddress != null) {
            if (callbackInterface != null) {
                callbackInterface.onDebugStatus("BT Mac address already in cache.");
            }
            callbackInterface.onSuccess(sBtMacAddress);
            return;
        }
        if (Build.VERSION.SDK_INT < 23) {
            DIHelper.returnBtMacAddressUsingAndroidAPIs(context, callbackInterface);
        } else {
            DIHelper.returnBtMacAddressUsingZebraAPIs(context, callbackInterface);
        }
    }

    private static void returnBtMacAddressUsingZebraAPIs(Context context, final IDIResultCallbacks callbackInterface) {
        IDIResultCallbacks tempCallbackInterface = new IDIResultCallbacks(){

            @Override
            public void onSuccess(String message) {
                sBtMacAddress = message;
                callbackInterface.onSuccess(message);
            }

            @Override
            public void onError(String message) {
                callbackInterface.onError(message);
            }

            @Override
            public void onDebugStatus(String message) {
                callbackInterface.onDebugStatus(message);
            }
        };
        new RetrieveOEMInfoTask().executeAsync(context, Uri.parse((String)"content://oem_info/oem.zebra.secure/bt_mac"), tempCallbackInterface);
    }

    private static void returnBtMacAddressUsingAndroidAPIs(Context context, IDIResultCallbacks callbackInterface) {
        BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        String macAddress = mBluetoothAdapter.getAddress();
        if (callbackInterface != null) {
            callbackInterface.onSuccess(macAddress);
        }
    }
}

