/*
 * Decompiled with CFR 0.152.
 */
package com.loper7.date_time_picker.utils.lunar;

import com.loper7.date_time_picker.ext.CalendarExtKt;
import com.loper7.date_time_picker.utils.lunar.LunarConstants;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u001b\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010'\u001a\u00020\u00062\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010)\u001a\u00020\u0003J\b\u0010*\u001a\u00020\u0011H\u0016R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u000fR\u0011\u0010\u001f\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0013R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\r\"\u0004\b\"\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\r\"\u0004\b$\u0010\u000fR\u0011\u0010%\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0013\u00a8\u0006,"}, d2={"Lcom/loper7/date_time_picker/utils/lunar/Lunar;", "", "year", "", "month", "isLeapMonth", "", "day", "hour", "minute", "seconds", "(IIZIIII)V", "getDay", "()I", "setDay", "(I)V", "dayName", "", "getDayName", "()Ljava/lang/String;", "getHour", "setHour", "hourName", "getHourName", "()Z", "setLeapMonth", "(Z)V", "getMinute", "setMinute", "getMonth", "setMonth", "monthName", "getMonthName", "getSeconds", "setSeconds", "getYear", "setYear", "yearName", "getYearName", "equals", "o", "getMaxDayInMonth", "toString", "Companion", "date_time_picker_release"})
public class Lunar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int year;
    private int month;
    private boolean isLeapMonth;
    private int day;
    private int hour;
    private int minute;
    private int seconds;

    public Lunar(int year, int month, boolean isLeapMonth, int day, int hour, int minute, int seconds) {
        this.year = year;
        this.month = month;
        this.isLeapMonth = isLeapMonth;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.seconds = seconds;
    }

    public final int getYear() {
        return this.year;
    }

    public final void setYear(int n) {
        this.year = n;
    }

    public final int getMonth() {
        return this.month;
    }

    public final void setMonth(int n) {
        this.month = n;
    }

    public final boolean isLeapMonth() {
        return this.isLeapMonth;
    }

    public final void setLeapMonth(boolean bl) {
        this.isLeapMonth = bl;
    }

    public final int getDay() {
        return this.day;
    }

    public final void setDay(int n) {
        this.day = n;
    }

    public final int getHour() {
        return this.hour;
    }

    public final void setHour(int n) {
        this.hour = n;
    }

    public final int getMinute() {
        return this.minute;
    }

    public final void setMinute(int n) {
        this.minute = n;
    }

    public final int getSeconds() {
        return this.seconds;
    }

    public final void setSeconds(int n) {
        this.seconds = n;
    }

    @NotNull
    public final String getYearName() {
        String tg = LunarConstants.INSTANCE.getLUNAR_TG()[(this.year - 4) % 10];
        String dz = LunarConstants.INSTANCE.getLUNAR_DZ()[(this.year - 4) % 12];
        return tg + dz + '\u5e74';
    }

    @NotNull
    public final String getMonthName() {
        return Intrinsics.stringPlus((String)(this.isLeapMonth ? "\u95f0" : ""), (Object)LunarConstants.INSTANCE.getLUNAR_MONTH_NAMES()[this.month - 1]);
    }

    @NotNull
    public final String getDayName() {
        return LunarConstants.INSTANCE.getLUNAR_DAY_NAMES()[this.day - 1];
    }

    @NotNull
    public final String getHourName() {
        return Intrinsics.stringPlus((String)LunarConstants.INSTANCE.getLUNAR_DZ()[(this.hour + 1) / 2 % 12], (Object)"\u65f6");
    }

    public final int getMaxDayInMonth() {
        int index = this.year - 1899;
        int hexValue = LunarConstants.INSTANCE.getLUNAR_TABLE()[index];
        return this.isLeapMonth ? (hexValue >> 12 & 1) + 29 : (hexValue >> 24 - this.month + 1 & 1) + 29;
    }

    public boolean equals(@Nullable Object o) {
        if (o == null || !(o instanceof Lunar)) {
            return false;
        }
        return ((Lunar)o).year == this.year && ((Lunar)o).month == this.month && ((Lunar)o).isLeapMonth == this.isLeapMonth;
    }

    @NotNull
    public String toString() {
        Map map;
        boolean bl = false;
        Map map2 = map = (Map)new LinkedHashMap();
        String string = "year";
        Object object = this.year;
        boolean bl2 = false;
        map2.put(string, object);
        map2 = map;
        string = "month";
        object = this.month;
        bl2 = false;
        map2.put(string, object);
        map2 = map;
        string = "day";
        object = this.day;
        bl2 = false;
        map2.put(string, object);
        map2 = map;
        string = "hour";
        object = this.hour;
        bl2 = false;
        map2.put(string, object);
        map2 = map;
        string = "minute";
        object = this.minute;
        bl2 = false;
        map2.put(string, object);
        map2 = map;
        string = "seconds";
        object = this.seconds;
        bl2 = false;
        map2.put(string, object);
        map2 = map;
        string = "isLeapMonth";
        object = this.isLeapMonth;
        bl2 = false;
        map2.put(string, object);
        map2 = map;
        string = "yearName";
        object = this.getYearName();
        bl2 = false;
        map2.put(string, object);
        map2 = map;
        string = "monthName";
        object = this.getMonthName();
        bl2 = false;
        map2.put(string, object);
        map2 = map;
        string = "dayName";
        object = this.getDayName();
        bl2 = false;
        map2.put(string, object);
        map2 = map;
        string = "hourName";
        object = this.getHourName();
        bl2 = false;
        map2.put(string, object);
        return map.toString();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lcom/loper7/date_time_picker/utils/lunar/Lunar$Companion;", "", "()V", "getInstance", "Lcom/loper7/date_time_picker/utils/lunar/Lunar;", "calendar", "Ljava/util/Calendar;", "timeInMillis", "", "hasLunarInfo", "", "date_time_picker_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Lunar getInstance(long timeInMillis) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTimeInMillis(timeInMillis);
            Calendar calendar3 = calendar2;
            Intrinsics.checkNotNullExpressionValue((Object)calendar3, (String)"calendar");
            return this.getInstance(calendar3);
        }

        @Nullable
        public final Lunar getInstance(@NotNull Calendar calendar2) {
            Intrinsics.checkNotNullParameter((Object)calendar2, (String)"calendar");
            if (!this.hasLunarInfo(calendar2)) {
                return null;
            }
            int lunarYear = calendar2.get(1);
            int lunarMonth = 0;
            int lunarDay = 0;
            int lunarHour = calendar2.get(11);
            int lunarLeapMonth = 0;
            boolean isLeap = false;
            int doffset = calendar2.get(6) - 1;
            int hexvalue = LunarConstants.INSTANCE.getLUNAR_TABLE()[lunarYear - 1899];
            int loffset = hexvalue & 0xFF;
            if (loffset > doffset) {
                int n = lunarYear;
                lunarYear = n + -1;
                doffset += CalendarExtKt.getMaxDayAtYear(new GregorianCalendar(), lunarYear);
                hexvalue = LunarConstants.INSTANCE.getLUNAR_TABLE()[lunarYear - 1899];
                loffset = hexvalue & 0xFF;
            }
            int days = doffset - loffset + 1;
            lunarLeapMonth = hexvalue >> 8 & 0xF;
            int len = lunarLeapMonth > 0 ? 13 : 12;
            int v = 0;
            int cd = 0;
            int n = 0;
            if (n < len) {
                do {
                    int i = n++;
                    v = (1 <= lunarLeapMonth ? lunarLeapMonth <= i : false) ? (i == lunarLeapMonth ? hexvalue >> 12 & 1 : hexvalue >> 24 - i + 1 & 1) : hexvalue >> 24 - i & 1;
                    cd = 29 + v;
                    if ((days -= cd) > 0) continue;
                    lunarDay = days + cd;
                    lunarMonth = i + 1;
                    boolean bl = 1 <= lunarLeapMonth ? lunarLeapMonth <= i : false;
                    if (!bl) break;
                    isLeap = i == lunarLeapMonth;
                    --lunarMonth;
                    break;
                } while (n < len);
            }
            return new Lunar(lunarYear, lunarMonth, isLeap, lunarDay, lunarHour, calendar2.get(12), calendar2.get(13));
        }

        public static /* synthetic */ Lunar getInstance$default(Companion companion, Calendar calendar2, int n, Object object) {
            if ((n & 1) != 0) {
                Calendar calendar3 = Calendar.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)calendar3, (String)"getInstance()");
                calendar2 = calendar3;
            }
            return companion.getInstance(calendar2);
        }

        public final boolean hasLunarInfo(@NotNull Calendar calendar2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)calendar2, (String)"calendar");
            try {
                int syear = calendar2.get(1);
                int dayoffset = calendar2.get(6) - 1;
                int lindex = syear - 1899;
                if (lindex < 0 || lindex >= LunarConstants.INSTANCE.getLUNAR_TABLE().length) {
                    return false;
                }
                int lyear = syear;
                int hexValue = LunarConstants.INSTANCE.getLUNAR_TABLE()[lindex];
                int ldayoffset = hexValue & 0xFF;
                if (ldayoffset > dayoffset) {
                    int n = lyear;
                    lyear = n + -1;
                }
                bl = lyear >= 1899;
            }
            catch (Throwable e) {
                e.printStackTrace();
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

