/*
 * Decompiled with CFR 0.152.
 */
package com.loper7.date_time_picker.number_picker;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.NumberKeyListener;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.EditText;
import android.widget.LinearLayout;
import androidx.annotation.CallSuper;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.loper7.date_time_picker.R;
import com.loper7.date_time_picker.number_picker.Scroller;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class NumberPicker
extends LinearLayout {
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 0;
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final int RIGHT = 0;
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int SIDE_LINES = 0;
    public static final int UNDERLINE = 1;
    private static final long DEFAULT_LONG_PRESS_UPDATE_INTERVAL = 300L;
    private static final int DEFAULT_MAX_FLING_VELOCITY_COEFFICIENT = 8;
    private static final int SELECTOR_ADJUSTMENT_DURATION_MILLIS = 800;
    private static final int SNAP_SCROLL_DURATION = 300;
    private static final float DEFAULT_FADING_EDGE_STRENGTH = 0.9f;
    private static final int UNSCALED_DEFAULT_DIVIDER_THICKNESS = 2;
    private static final int UNSCALED_DEFAULT_DIVIDER_DISTANCE = 48;
    private static final int SIZE_UNSPECIFIED = -1;
    private static final int DEFAULT_DIVIDER_COLOR = -16777216;
    private static final int DEFAULT_MAX_VALUE = 100;
    private static final int DEFAULT_MIN_VALUE = 1;
    private static final int DEFAULT_WHEEL_ITEM_COUNT = 3;
    private static final int DEFAULT_MAX_HEIGHT = 180;
    private static final int DEFAULT_MIN_WIDTH = 58;
    private static final int DEFAULT_TEXT_ALIGN = 1;
    private static final int DEFAULT_TEXT_COLOR = -16777216;
    private static final float DEFAULT_TEXT_SIZE = 15.0f;
    private static final float DEFAULT_LINE_SPACING_MULTIPLIER = 1.0f;
    private String label = "";
    private boolean textBold = true;
    private boolean selectedTextBold = true;
    private static final TwoDigitFormatter sTwoDigitFormatter = new TwoDigitFormatter();
    private final EditText mSelectedText;
    private float mSelectedTextCenterX;
    private float mSelectedTextCenterY;
    private int mMinHeight;
    private int mMaxHeight;
    private int mMinWidth;
    private int mMaxWidth;
    private final boolean mComputeMaxWidth;
    private int mSelectedTextAlign = 1;
    private int mSelectedTextColor = -16777216;
    private float mSelectedTextSize = 15.0f;
    private boolean mSelectedTextStrikeThru;
    private boolean mSelectedTextUnderline;
    private Typeface mSelectedTypeface;
    private int mTextAlign = 1;
    private int mTextColor = -16777216;
    private float mTextSize = 15.0f;
    private boolean mTextStrikeThru;
    private boolean mTextUnderline;
    private Typeface mTypeface;
    private int mSelectorTextGapWidth;
    private int mSelectorTextGapHeight;
    private String[] mDisplayedValues;
    private int mMinValue = 1;
    private int mMaxValue = 100;
    private int mValue;
    private View.OnClickListener mOnClickListener;
    private OnValueChangeListener mOnValueChangeListener;
    private OnScrollListener mOnScrollListener;
    private Formatter mFormatter;
    private long mLongPressUpdateInterval = 300L;
    private final SparseArray<String> mSelectorIndexToStringCache = new SparseArray();
    private int mWheelItemCount = 3;
    private int mRealWheelItemCount = 3;
    private int mWheelMiddleItemIndex = this.mWheelItemCount / 2;
    private int[] mSelectorIndices = new int[this.mWheelItemCount];
    private final Paint mSelectorWheelPaint;
    private int mSelectorElementSize;
    private int mInitialScrollOffset = Integer.MIN_VALUE;
    private int mCurrentScrollOffset;
    private final Scroller mFlingScroller;
    private final Scroller mAdjustScroller;
    private int mPreviousScrollerX;
    private int mPreviousScrollerY;
    private SetSelectionCommand mSetSelectionCommand;
    private ChangeCurrentByOneFromLongPressCommand mChangeCurrentByOneFromLongPressCommand;
    private float mLastDownEventX;
    private float mLastDownEventY;
    private float mLastDownOrMoveEventX;
    private float mLastDownOrMoveEventY;
    private VelocityTracker mVelocityTracker;
    private int mTouchSlop;
    private int mMinimumFlingVelocity;
    private int mMaximumFlingVelocity;
    private boolean mWrapSelectorWheel;
    private boolean mWrapSelectorWheelPreferred = true;
    private Drawable mDividerDrawable;
    private int mDividerColor = -16777216;
    private int mDividerDistance;
    private int mDividerLength;
    private int mDividerThickness;
    private int mTopDividerTop;
    private int mBottomDividerBottom;
    private int mLeftDividerLeft;
    private int mRightDividerRight;
    private int mDividerType;
    private int mScrollState = 0;
    private int mLastHandledDownDpadKeyCode = -1;
    private boolean mHideWheelUntilFocused;
    private int mOrientation;
    private int mOrder;
    private boolean mFadingEdgeEnabled = true;
    private float mFadingEdgeStrength = 0.9f;
    private boolean mScrollerEnabled = true;
    private float mLineSpacingMultiplier = 1.0f;
    private int mMaxFlingVelocityCoefficient = 8;
    private boolean mAccessibilityDescriptionEnabled = true;
    private Context mContext;
    private NumberFormat mNumberFormatter;
    private ViewConfiguration mViewConfiguration;
    private int mItemSpacing = 0;
    private static final char[] DIGIT_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0660', '\u0661', '\u0662', '\u0663', '\u0664', '\u0665', '\u0666', '\u0667', '\u0668', '\u0669', '\u06f0', '\u06f1', '\u06f2', '\u06f3', '\u06f4', '\u06f5', '\u06f6', '\u06f7', '\u06f8', '\u06f9', '\u0966', '\u0967', '\u0968', '\u0969', '\u096a', '\u096b', '\u096c', '\u096d', '\u096e', '\u096f', '\u09e6', '\u09e7', '\u09e8', '\u09e9', '\u09ea', '\u09eb', '\u09ec', '\u09ed', '\u09ee', '\u09ef', '\u0ce6', '\u0ce7', '\u0ce8', '\u0ce9', '\u0cea', '\u0ceb', '\u0cec', '\u0ced', '\u0cee', '\u0cef', '-'};

    public static Formatter getTwoDigitFormatter() {
        return sTwoDigitFormatter;
    }

    public NumberPicker(Context context) {
        this(context, null);
    }

    public NumberPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NumberPicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        this.mContext = context;
        this.mNumberFormatter = NumberFormat.getInstance();
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.NumberPicker, defStyle, 0);
        Drawable selectionDivider = attributes.getDrawable(R.styleable.NumberPicker_np_divider);
        if (selectionDivider != null) {
            selectionDivider.setCallback((Drawable.Callback)this);
            if (selectionDivider.isStateful()) {
                selectionDivider.setState(this.getDrawableState());
            }
            this.mDividerDrawable = selectionDivider;
        } else {
            this.mDividerColor = attributes.getColor(R.styleable.NumberPicker_np_dividerColor, this.mDividerColor);
            this.setDividerColor(this.mDividerColor);
        }
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        int defDividerDistance = (int)TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)displayMetrics);
        int defDividerThickness = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics);
        this.mDividerDistance = attributes.getDimensionPixelSize(R.styleable.NumberPicker_np_dividerDistance, defDividerDistance);
        this.mDividerLength = attributes.getDimensionPixelSize(R.styleable.NumberPicker_np_dividerLength, 0);
        this.mDividerThickness = attributes.getDimensionPixelSize(R.styleable.NumberPicker_np_dividerThickness, defDividerThickness);
        this.mDividerType = attributes.getInt(R.styleable.NumberPicker_np_dividerType, 0);
        this.mOrder = attributes.getInt(R.styleable.NumberPicker_np_order, 0);
        this.mOrientation = attributes.getInt(R.styleable.NumberPicker_np_orientation, 1);
        float width = attributes.getDimensionPixelSize(R.styleable.NumberPicker_np_width, -1);
        float height = attributes.getDimensionPixelSize(R.styleable.NumberPicker_np_height, -1);
        this.setWidthAndHeight();
        this.mComputeMaxWidth = true;
        this.mValue = attributes.getInt(R.styleable.NumberPicker_np_value, this.mValue);
        this.mMaxValue = attributes.getInt(R.styleable.NumberPicker_np_max, this.mMaxValue);
        this.mMinValue = attributes.getInt(R.styleable.NumberPicker_np_min, this.mMinValue);
        this.mSelectedTextAlign = attributes.getInt(R.styleable.NumberPicker_np_selectedTextAlign, this.mSelectedTextAlign);
        this.mSelectedTextColor = attributes.getColor(R.styleable.NumberPicker_np_selectedTextColor, this.mSelectedTextColor);
        this.mSelectedTextSize = attributes.getDimension(R.styleable.NumberPicker_np_selectedTextSize, this.spToPx(this.mSelectedTextSize));
        this.mSelectedTextStrikeThru = attributes.getBoolean(R.styleable.NumberPicker_np_selectedTextStrikeThru, this.mSelectedTextStrikeThru);
        this.mSelectedTextUnderline = attributes.getBoolean(R.styleable.NumberPicker_np_selectedTextUnderline, this.mSelectedTextUnderline);
        this.mSelectedTypeface = Typeface.create((String)attributes.getString(R.styleable.NumberPicker_np_selectedTypeface), (int)0);
        this.mTextAlign = attributes.getInt(R.styleable.NumberPicker_np_textAlign, this.mTextAlign);
        this.mTextColor = attributes.getColor(R.styleable.NumberPicker_np_textColor, this.mTextColor);
        this.mTextSize = attributes.getDimension(R.styleable.NumberPicker_np_textSize, this.spToPx(this.mTextSize));
        this.mTextStrikeThru = attributes.getBoolean(R.styleable.NumberPicker_np_textStrikeThru, this.mTextStrikeThru);
        this.mTextUnderline = attributes.getBoolean(R.styleable.NumberPicker_np_textUnderline, this.mTextUnderline);
        this.mTypeface = Typeface.create((String)attributes.getString(R.styleable.NumberPicker_np_typeface), (int)0);
        this.mFormatter = this.stringToFormatter(attributes.getString(R.styleable.NumberPicker_np_formatter));
        this.mFadingEdgeEnabled = attributes.getBoolean(R.styleable.NumberPicker_np_fadingEdgeEnabled, this.mFadingEdgeEnabled);
        this.mFadingEdgeStrength = attributes.getFloat(R.styleable.NumberPicker_np_fadingEdgeStrength, this.mFadingEdgeStrength);
        this.mScrollerEnabled = attributes.getBoolean(R.styleable.NumberPicker_np_scrollerEnabled, this.mScrollerEnabled);
        this.mWheelItemCount = attributes.getInt(R.styleable.NumberPicker_np_wheelItemCount, this.mWheelItemCount);
        this.mLineSpacingMultiplier = attributes.getFloat(R.styleable.NumberPicker_np_lineSpacingMultiplier, this.mLineSpacingMultiplier);
        this.mMaxFlingVelocityCoefficient = attributes.getInt(R.styleable.NumberPicker_np_maxFlingVelocityCoefficient, this.mMaxFlingVelocityCoefficient);
        this.mHideWheelUntilFocused = attributes.getBoolean(R.styleable.NumberPicker_np_hideWheelUntilFocused, false);
        this.mAccessibilityDescriptionEnabled = attributes.getBoolean(R.styleable.NumberPicker_np_accessibilityDescriptionEnabled, true);
        this.mItemSpacing = attributes.getDimensionPixelSize(R.styleable.NumberPicker_np_itemSpacing, 0);
        this.textBold = attributes.getBoolean(R.styleable.NumberPicker_np_textBold, this.textBold);
        this.selectedTextBold = attributes.getBoolean(R.styleable.NumberPicker_np_selectedTextBold, this.selectedTextBold);
        this.setWillNotDraw(false);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(R.layout.dt_number_picker_material, (ViewGroup)this, true);
        this.mSelectedText = (EditText)this.findViewById(R.id.np__numberpicker_input);
        this.mSelectedText.setEnabled(false);
        this.mSelectedText.setFocusable(false);
        this.mSelectedText.setImeOptions(1);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setTextAlign(Paint.Align.CENTER);
        this.mSelectorWheelPaint = paint;
        this.setSelectedTextColor(this.mSelectedTextColor);
        this.setTextColor(this.mTextColor);
        this.setTextSize(this.mTextSize);
        this.setSelectedTextSize(this.mSelectedTextSize);
        this.setTypeface(this.mTypeface);
        this.setSelectedTypeface(this.mSelectedTypeface);
        this.setFormatter(this.mFormatter);
        this.updateInputTextView();
        this.setValue(this.mValue);
        this.setMaxValue(this.mMaxValue);
        this.setMinValue(this.mMinValue);
        this.setWheelItemCount(this.mWheelItemCount);
        this.mWrapSelectorWheel = attributes.getBoolean(R.styleable.NumberPicker_np_wrapSelectorWheel, this.mWrapSelectorWheel);
        this.setWrapSelectorWheel(this.mWrapSelectorWheel);
        if (width != -1.0f && height != -1.0f) {
            this.setScaleX(width / (float)this.mMinWidth);
            this.setScaleY(height / (float)this.mMaxHeight);
        } else if (width != -1.0f) {
            float scale = width / (float)this.mMinWidth;
            this.setScaleX(scale);
            this.setScaleY(scale);
        } else if (height != -1.0f) {
            float scale = height / (float)this.mMaxHeight;
            this.setScaleX(scale);
            this.setScaleY(scale);
        }
        this.mViewConfiguration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = this.mViewConfiguration.getScaledTouchSlop();
        this.mMinimumFlingVelocity = this.mViewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumFlingVelocity = this.mViewConfiguration.getScaledMaximumFlingVelocity() / this.mMaxFlingVelocityCoefficient;
        this.mFlingScroller = new Scroller(context, null, true);
        this.mAdjustScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator(2.5f));
        if (Build.VERSION.SDK_INT >= 16 && this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        if (Build.VERSION.SDK_INT >= 26 && this.getFocusable() == 16) {
            this.setFocusable(1);
            this.setFocusableInTouchMode(true);
        }
        attributes.recycle();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int msrdWdth = this.getMeasuredWidth();
        int msrdHght = this.getMeasuredHeight();
        int inptTxtMsrdWdth = this.mSelectedText.getMeasuredWidth();
        int inptTxtMsrdHght = this.mSelectedText.getMeasuredHeight();
        int inptTxtLeft = (msrdWdth - inptTxtMsrdWdth) / 2;
        int inptTxtTop = (msrdHght - inptTxtMsrdHght) / 2;
        int inptTxtRight = inptTxtLeft + inptTxtMsrdWdth;
        int inptTxtBottom = inptTxtTop + inptTxtMsrdHght;
        this.mSelectedText.layout(inptTxtLeft, inptTxtTop, inptTxtRight, inptTxtBottom);
        this.mSelectedTextCenterX = this.mSelectedText.getX() + (float)this.mSelectedText.getMeasuredWidth() / 2.0f - 2.0f;
        this.mSelectedTextCenterY = this.mSelectedText.getY() + (float)this.mSelectedText.getMeasuredHeight() / 2.0f - 5.0f;
        if (changed) {
            this.initializeSelectorWheel();
            this.initializeFadingEdges();
            int dividerDistance = 2 * this.mDividerThickness + this.mDividerDistance;
            if (this.isHorizontalMode()) {
                this.mLeftDividerLeft = (this.getWidth() - this.mDividerDistance) / 2 - this.mDividerThickness;
                this.mRightDividerRight = this.mLeftDividerLeft + dividerDistance;
                this.mBottomDividerBottom = this.getHeight();
            } else {
                this.mTopDividerTop = (this.getHeight() - this.mDividerDistance) / 2 - this.mDividerThickness;
                this.mBottomDividerBottom = this.mTopDividerTop + dividerDistance;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int newWidthMeasureSpec = this.makeMeasureSpec(widthMeasureSpec, this.mMaxWidth);
        int newHeightMeasureSpec = this.makeMeasureSpec(heightMeasureSpec, this.mMaxHeight);
        super.onMeasure(newWidthMeasureSpec, newHeightMeasureSpec);
        int widthSize = this.resolveSizeAndStateRespectingMinSize(this.mMinWidth, this.getMeasuredWidth(), widthMeasureSpec);
        int heightSize = this.resolveSizeAndStateRespectingMinSize(this.mMinHeight, this.getMeasuredHeight(), heightMeasureSpec);
        this.setMeasuredDimension(widthSize, heightSize);
    }

    private boolean moveToFinalScrollerPosition(Scroller scroller) {
        scroller.forceFinished(true);
        if (this.isHorizontalMode()) {
            int amountToScroll = scroller.getFinalX() - scroller.getCurrX();
            int futureScrollOffset = (this.mCurrentScrollOffset + amountToScroll) % this.mSelectorElementSize;
            int overshootAdjustment = this.mInitialScrollOffset - futureScrollOffset;
            if (overshootAdjustment != 0) {
                if (Math.abs(overshootAdjustment) > this.mSelectorElementSize / 2) {
                    overshootAdjustment = overshootAdjustment > 0 ? (overshootAdjustment -= this.mSelectorElementSize) : (overshootAdjustment += this.mSelectorElementSize);
                }
                this.scrollBy(amountToScroll += overshootAdjustment, 0);
                return true;
            }
        } else {
            int amountToScroll = scroller.getFinalY() - scroller.getCurrY();
            int futureScrollOffset = (this.mCurrentScrollOffset + amountToScroll) % this.mSelectorElementSize;
            int overshootAdjustment = this.mInitialScrollOffset - futureScrollOffset;
            if (overshootAdjustment != 0) {
                if (Math.abs(overshootAdjustment) > this.mSelectorElementSize / 2) {
                    overshootAdjustment = overshootAdjustment > 0 ? (overshootAdjustment -= this.mSelectorElementSize) : (overshootAdjustment += this.mSelectorElementSize);
                }
                this.scrollBy(0, amountToScroll += overshootAdjustment);
                return true;
            }
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getAction() & 0xFF;
        if (action != 0) {
            return false;
        }
        this.removeAllCallbacks();
        this.getParent().requestDisallowInterceptTouchEvent(true);
        if (this.isHorizontalMode()) {
            this.mLastDownOrMoveEventX = this.mLastDownEventX = event.getX();
            if (!this.mFlingScroller.isFinished()) {
                this.mFlingScroller.forceFinished(true);
                this.mAdjustScroller.forceFinished(true);
                this.onScrollerFinished(this.mFlingScroller);
                this.onScrollStateChange(0);
            } else if (!this.mAdjustScroller.isFinished()) {
                this.mFlingScroller.forceFinished(true);
                this.mAdjustScroller.forceFinished(true);
                this.onScrollerFinished(this.mAdjustScroller);
            } else if (this.mLastDownEventX >= (float)this.mLeftDividerLeft && this.mLastDownEventX <= (float)this.mRightDividerRight) {
                if (this.mOnClickListener != null) {
                    this.mOnClickListener.onClick((View)this);
                }
            } else if (this.mLastDownEventX < (float)this.mLeftDividerLeft) {
                this.postChangeCurrentByOneFromLongPress(false);
            } else if (this.mLastDownEventX > (float)this.mRightDividerRight) {
                this.postChangeCurrentByOneFromLongPress(true);
            }
        } else {
            this.mLastDownOrMoveEventY = this.mLastDownEventY = event.getY();
            if (!this.mFlingScroller.isFinished()) {
                this.mFlingScroller.forceFinished(true);
                this.mAdjustScroller.forceFinished(true);
                this.onScrollStateChange(0);
            } else if (!this.mAdjustScroller.isFinished()) {
                this.mFlingScroller.forceFinished(true);
                this.mAdjustScroller.forceFinished(true);
            } else if (this.mLastDownEventY >= (float)this.mTopDividerTop && this.mLastDownEventY <= (float)this.mBottomDividerBottom) {
                if (this.mOnClickListener != null) {
                    this.mOnClickListener.onClick((View)this);
                }
            } else if (this.mLastDownEventY < (float)this.mTopDividerTop) {
                this.postChangeCurrentByOneFromLongPress(false);
            } else if (this.mLastDownEventY > (float)this.mBottomDividerBottom) {
                this.postChangeCurrentByOneFromLongPress(true);
            }
        }
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.isScrollerEnabled()) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        int action = event.getAction() & 0xFF;
        switch (action) {
            case 2: {
                if (this.isHorizontalMode()) {
                    float currentMoveX = event.getX();
                    if (this.mScrollState != 1) {
                        int deltaDownX = (int)Math.abs(currentMoveX - this.mLastDownEventX);
                        if (deltaDownX > this.mTouchSlop) {
                            this.removeAllCallbacks();
                            this.onScrollStateChange(1);
                        }
                    } else {
                        int deltaMoveX = (int)(currentMoveX - this.mLastDownOrMoveEventX);
                        this.scrollBy(deltaMoveX, 0);
                        this.invalidate();
                    }
                    this.mLastDownOrMoveEventX = currentMoveX;
                    break;
                }
                float currentMoveY = event.getY();
                if (this.mScrollState != 1) {
                    int deltaDownY = (int)Math.abs(currentMoveY - this.mLastDownEventY);
                    if (deltaDownY > this.mTouchSlop) {
                        this.removeAllCallbacks();
                        this.onScrollStateChange(1);
                    }
                } else {
                    int deltaMoveY = (int)(currentMoveY - this.mLastDownOrMoveEventY);
                    this.scrollBy(0, deltaMoveY);
                    this.invalidate();
                }
                this.mLastDownOrMoveEventY = currentMoveY;
                break;
            }
            case 1: {
                this.removeChangeCurrentByOneFromLongPress();
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                if (this.isHorizontalMode()) {
                    int initialVelocity = (int)velocityTracker.getXVelocity();
                    if (Math.abs(initialVelocity) > this.mMinimumFlingVelocity) {
                        this.fling(initialVelocity);
                        this.onScrollStateChange(2);
                    } else {
                        int eventX = (int)event.getX();
                        int deltaMoveX = (int)Math.abs((float)eventX - this.mLastDownEventX);
                        if (deltaMoveX <= this.mTouchSlop) {
                            int selectorIndexOffset = eventX / this.mSelectorElementSize - this.mWheelMiddleItemIndex;
                            if (selectorIndexOffset > 0) {
                                this.changeValueByOne(true);
                            } else if (selectorIndexOffset < 0) {
                                this.changeValueByOne(false);
                            } else {
                                this.ensureScrollWheelAdjusted();
                            }
                        } else {
                            this.ensureScrollWheelAdjusted();
                        }
                        this.onScrollStateChange(0);
                    }
                } else {
                    int initialVelocity = (int)velocityTracker.getYVelocity();
                    if (Math.abs(initialVelocity) > this.mMinimumFlingVelocity) {
                        this.fling(initialVelocity);
                        this.onScrollStateChange(2);
                    } else {
                        int eventY = (int)event.getY();
                        int deltaMoveY = (int)Math.abs((float)eventY - this.mLastDownEventY);
                        if (deltaMoveY <= this.mTouchSlop) {
                            int selectorIndexOffset = eventY / this.mSelectorElementSize - this.mWheelMiddleItemIndex;
                            if (selectorIndexOffset > 0) {
                                this.changeValueByOne(true);
                            } else if (selectorIndexOffset < 0) {
                                this.changeValueByOne(false);
                            } else {
                                this.ensureScrollWheelAdjusted();
                            }
                        } else {
                            this.ensureScrollWheelAdjusted();
                        }
                        this.onScrollStateChange(0);
                    }
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return true;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        int action = event.getAction() & 0xFF;
        switch (action) {
            case 1: 
            case 3: {
                this.removeAllCallbacks();
            }
        }
        return super.dispatchTouchEvent(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 23: 
            case 66: {
                this.removeAllCallbacks();
                return super.dispatchKeyEvent(event);
            }
            case 19: 
            case 20: {
                switch (event.getAction()) {
                    case 0: {
                        if (!this.mWrapSelectorWheel && !(keyCode == 20 ? this.getValue() < this.getMaxValue() : this.getValue() > this.getMinValue())) return super.dispatchKeyEvent(event);
                        this.requestFocus();
                        this.mLastHandledDownDpadKeyCode = keyCode;
                        this.removeAllCallbacks();
                        if (!this.mFlingScroller.isFinished()) return true;
                        this.changeValueByOne(keyCode == 20);
                        return true;
                    }
                    case 1: {
                        if (this.mLastHandledDownDpadKeyCode != keyCode) return super.dispatchKeyEvent(event);
                        this.mLastHandledDownDpadKeyCode = -1;
                        return true;
                    }
                }
            }
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean dispatchTrackballEvent(MotionEvent event) {
        int action = event.getAction() & 0xFF;
        switch (action) {
            case 1: 
            case 3: {
                this.removeAllCallbacks();
            }
        }
        return super.dispatchTrackballEvent(event);
    }

    public void computeScroll() {
        if (!this.isScrollerEnabled()) {
            return;
        }
        Scroller scroller = this.mFlingScroller;
        if (scroller.isFinished() && (scroller = this.mAdjustScroller).isFinished()) {
            return;
        }
        scroller.computeScrollOffset();
        if (this.isHorizontalMode()) {
            int currentScrollerX = scroller.getCurrX();
            if (this.mPreviousScrollerX == 0) {
                this.mPreviousScrollerX = scroller.getStartX();
            }
            this.scrollBy(currentScrollerX - this.mPreviousScrollerX, 0);
            this.mPreviousScrollerX = currentScrollerX;
        } else {
            int currentScrollerY = scroller.getCurrY();
            if (this.mPreviousScrollerY == 0) {
                this.mPreviousScrollerY = scroller.getStartY();
            }
            this.scrollBy(0, currentScrollerY - this.mPreviousScrollerY);
            this.mPreviousScrollerY = currentScrollerY;
        }
        if (scroller.isFinished()) {
            this.onScrollerFinished(scroller);
        } else {
            this.postInvalidate();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mSelectedText.setEnabled(enabled);
    }

    public void scrollBy(int x, int y) {
        if (!this.isScrollerEnabled()) {
            return;
        }
        int[] selectorIndices = this.getSelectorIndices();
        int startScrollOffset = this.mCurrentScrollOffset;
        int gap = (int)this.getMaxTextSize();
        if (this.isHorizontalMode()) {
            if (this.isAscendingOrder()) {
                if (!this.mWrapSelectorWheel && x > 0 && selectorIndices[this.mWheelMiddleItemIndex] <= this.mMinValue) {
                    this.mCurrentScrollOffset = this.mInitialScrollOffset;
                    return;
                }
                if (!this.mWrapSelectorWheel && x < 0 && selectorIndices[this.mWheelMiddleItemIndex] >= this.mMaxValue) {
                    this.mCurrentScrollOffset = this.mInitialScrollOffset;
                    return;
                }
            } else {
                if (!this.mWrapSelectorWheel && x > 0 && selectorIndices[this.mWheelMiddleItemIndex] >= this.mMaxValue) {
                    this.mCurrentScrollOffset = this.mInitialScrollOffset;
                    return;
                }
                if (!this.mWrapSelectorWheel && x < 0 && selectorIndices[this.mWheelMiddleItemIndex] <= this.mMinValue) {
                    this.mCurrentScrollOffset = this.mInitialScrollOffset;
                    return;
                }
            }
            this.mCurrentScrollOffset += x;
        } else {
            if (this.isAscendingOrder()) {
                if (!this.mWrapSelectorWheel && y > 0 && selectorIndices[this.mWheelMiddleItemIndex] <= this.mMinValue) {
                    this.mCurrentScrollOffset = this.mInitialScrollOffset;
                    return;
                }
                if (!this.mWrapSelectorWheel && y < 0 && selectorIndices[this.mWheelMiddleItemIndex] >= this.mMaxValue) {
                    this.mCurrentScrollOffset = this.mInitialScrollOffset;
                    return;
                }
            } else {
                if (!this.mWrapSelectorWheel && y > 0 && selectorIndices[this.mWheelMiddleItemIndex] >= this.mMaxValue) {
                    this.mCurrentScrollOffset = this.mInitialScrollOffset;
                    return;
                }
                if (!this.mWrapSelectorWheel && y < 0 && selectorIndices[this.mWheelMiddleItemIndex] <= this.mMinValue) {
                    this.mCurrentScrollOffset = this.mInitialScrollOffset;
                    return;
                }
            }
            this.mCurrentScrollOffset += y;
        }
        while (this.mCurrentScrollOffset - this.mInitialScrollOffset > gap) {
            this.mCurrentScrollOffset -= this.mSelectorElementSize;
            if (this.isAscendingOrder()) {
                this.decrementSelectorIndices(selectorIndices);
            } else {
                this.incrementSelectorIndices(selectorIndices);
            }
            this.setValueInternal(selectorIndices[this.mWheelMiddleItemIndex], true);
            if (this.mWrapSelectorWheel || selectorIndices[this.mWheelMiddleItemIndex] >= this.mMinValue) continue;
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
        }
        while (this.mCurrentScrollOffset - this.mInitialScrollOffset < -gap) {
            this.mCurrentScrollOffset += this.mSelectorElementSize;
            if (this.isAscendingOrder()) {
                this.incrementSelectorIndices(selectorIndices);
            } else {
                this.decrementSelectorIndices(selectorIndices);
            }
            this.setValueInternal(selectorIndices[this.mWheelMiddleItemIndex], true);
            if (this.mWrapSelectorWheel || selectorIndices[this.mWheelMiddleItemIndex] <= this.mMaxValue) continue;
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
        }
        if (startScrollOffset != this.mCurrentScrollOffset) {
            if (this.isHorizontalMode()) {
                this.onScrollChanged(this.mCurrentScrollOffset, 0, startScrollOffset, 0);
            } else {
                this.onScrollChanged(0, this.mCurrentScrollOffset, 0, startScrollOffset);
            }
        }
    }

    private int computeScrollOffset(boolean isHorizontalMode) {
        return isHorizontalMode ? this.mCurrentScrollOffset : 0;
    }

    private int computeScrollRange(boolean isHorizontalMode) {
        return isHorizontalMode ? (this.mMaxValue - this.mMinValue + 1) * this.mSelectorElementSize : 0;
    }

    private int computeScrollExtent(boolean isHorizontalMode) {
        return isHorizontalMode ? this.getWidth() : this.getHeight();
    }

    protected int computeHorizontalScrollOffset() {
        return this.computeScrollOffset(this.isHorizontalMode());
    }

    protected int computeHorizontalScrollRange() {
        return this.computeScrollRange(this.isHorizontalMode());
    }

    protected int computeHorizontalScrollExtent() {
        return this.computeScrollExtent(this.isHorizontalMode());
    }

    protected int computeVerticalScrollOffset() {
        return this.computeScrollOffset(!this.isHorizontalMode());
    }

    protected int computeVerticalScrollRange() {
        return this.computeScrollRange(!this.isHorizontalMode());
    }

    protected int computeVerticalScrollExtent() {
        return this.computeScrollExtent(this.isHorizontalMode());
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mNumberFormatter = NumberFormat.getInstance();
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }

    public void setOnValueChangedListener(OnValueChangeListener onValueChangedListener) {
        this.mOnValueChangeListener = onValueChangedListener;
    }

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }

    public void setFormatter(Formatter formatter) {
        if (formatter == this.mFormatter) {
            return;
        }
        this.mFormatter = formatter;
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
    }

    public void setValue(int value) {
        this.setValueInternal(value, false);
    }

    private float getMaxTextSize() {
        return Math.max(this.mTextSize, this.mSelectedTextSize);
    }

    private float getPaintCenterY(Paint.FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            return 0.0f;
        }
        return Math.abs(fontMetrics.top + fontMetrics.bottom) / 2.0f;
    }

    private void tryComputeMaxWidth() {
        if (!this.mComputeMaxWidth) {
            return;
        }
        this.mSelectorWheelPaint.setTextSize(this.getMaxTextSize());
        int maxTextWidth = 0;
        if (this.mDisplayedValues == null) {
            float maxDigitWidth = 0.0f;
            for (int i = 0; i <= 9; ++i) {
                float digitWidth = this.mSelectorWheelPaint.measureText(this.formatNumber(i));
                if (!(digitWidth > maxDigitWidth)) continue;
                maxDigitWidth = digitWidth;
            }
            int numberOfDigits = 0;
            for (int current = this.mMaxValue; current > 0; current /= 10) {
                ++numberOfDigits;
            }
            maxTextWidth = (int)((float)numberOfDigits * maxDigitWidth);
        } else {
            for (String displayedValue : this.mDisplayedValues) {
                float textWidth = this.mSelectorWheelPaint.measureText(displayedValue);
                if (!(textWidth > (float)maxTextWidth)) continue;
                maxTextWidth = (int)textWidth;
            }
        }
        if (this.mMaxWidth != (maxTextWidth += this.mSelectedText.getPaddingLeft() + this.mSelectedText.getPaddingRight())) {
            this.mMaxWidth = Math.max(maxTextWidth, this.mMinWidth);
            this.invalidate();
        }
    }

    public boolean getWrapSelectorWheel() {
        return this.mWrapSelectorWheel;
    }

    public void setWrapSelectorWheel(boolean wrapSelectorWheel) {
        this.mWrapSelectorWheelPreferred = wrapSelectorWheel;
        this.updateWrapSelectorWheel();
    }

    private void updateWrapSelectorWheel() {
        this.mWrapSelectorWheel = this.isWrappingAllowed() && this.mWrapSelectorWheelPreferred;
    }

    private boolean isWrappingAllowed() {
        return this.mMaxValue - this.mMinValue >= this.mSelectorIndices.length - 1;
    }

    public void setOnLongPressUpdateInterval(long intervalMillis) {
        this.mLongPressUpdateInterval = intervalMillis;
    }

    public int getValue() {
        return this.mValue;
    }

    public int getMinValue() {
        return this.mMinValue;
    }

    public void setMinValue(int minValue) {
        this.mMinValue = minValue;
        if (this.mMinValue > this.mValue) {
            this.mValue = this.mMinValue;
        }
        this.updateWrapSelectorWheel();
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
        this.tryComputeMaxWidth();
        this.invalidate();
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(int maxValue) {
        if (maxValue < 0) {
            throw new IllegalArgumentException("maxValue must be >= 0");
        }
        this.mMaxValue = maxValue;
        if (this.mMaxValue < this.mValue) {
            this.mValue = this.mMaxValue;
        }
        this.updateWrapSelectorWheel();
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
        this.tryComputeMaxWidth();
        this.invalidate();
    }

    public String[] getDisplayedValues() {
        return this.mDisplayedValues;
    }

    public void setDisplayedValues(String[] displayedValues) {
        if (this.mDisplayedValues == displayedValues) {
            return;
        }
        this.mDisplayedValues = displayedValues;
        if (this.mDisplayedValues != null) {
            this.mSelectedText.setRawInputType(655360);
        } else {
            this.mSelectedText.setRawInputType(655360);
        }
        this.updateInputTextView();
        this.initializeSelectorWheelIndices();
        this.tryComputeMaxWidth();
    }

    private float getFadingEdgeStrength(boolean isHorizontalMode) {
        return isHorizontalMode && this.mFadingEdgeEnabled ? this.mFadingEdgeStrength : 0.0f;
    }

    protected float getTopFadingEdgeStrength() {
        return this.getFadingEdgeStrength(!this.isHorizontalMode());
    }

    protected float getBottomFadingEdgeStrength() {
        return this.getFadingEdgeStrength(!this.isHorizontalMode());
    }

    protected float getLeftFadingEdgeStrength() {
        return this.getFadingEdgeStrength(this.isHorizontalMode());
    }

    protected float getRightFadingEdgeStrength() {
        return this.getFadingEdgeStrength(this.isHorizontalMode());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeAllCallbacks();
    }

    @CallSuper
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mDividerDrawable != null && this.mDividerDrawable.isStateful() && this.mDividerDrawable.setState(this.getDrawableState())) {
            this.invalidateDrawable(this.mDividerDrawable);
        }
    }

    @CallSuper
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mDividerDrawable != null) {
            this.mDividerDrawable.jumpToCurrentState();
        }
    }

    protected void onDraw(Canvas canvas) {
        float y;
        float x;
        boolean showSelectorWheel;
        canvas.save();
        boolean bl = showSelectorWheel = !this.mHideWheelUntilFocused || this.hasFocus();
        if (this.isHorizontalMode()) {
            x = this.mCurrentScrollOffset;
            y = this.mSelectedText.getBaseline() + this.mSelectedText.getTop();
            if (this.mRealWheelItemCount < 3) {
                canvas.clipRect(this.mLeftDividerLeft, 0, this.mRightDividerRight, this.getBottom());
            }
        } else {
            x = (float)(this.getRight() - this.getLeft()) / 2.0f;
            y = this.mCurrentScrollOffset;
            if (this.mRealWheelItemCount < 3) {
                canvas.clipRect(0, this.mTopDividerTop, this.getRight(), this.mBottomDividerBottom);
            }
        }
        int[] selectorIndices = this.getSelectorIndices();
        for (int i = 0; i < selectorIndices.length; ++i) {
            int selectorIndex = selectorIndices[this.isAscendingOrder() ? i : selectorIndices.length - i - 1];
            String scrollSelectorValue = (String)this.mSelectorIndexToStringCache.get(selectorIndex);
            if (i == this.mWheelMiddleItemIndex) {
                this.mSelectorWheelPaint.setTextAlign(Paint.Align.values()[this.mSelectedTextAlign]);
                this.mSelectorWheelPaint.setTextSize(this.mSelectedTextSize);
                this.mSelectorWheelPaint.setColor(this.mSelectedTextColor);
                this.mSelectorWheelPaint.setFakeBoldText(this.selectedTextBold);
                this.mSelectorWheelPaint.setStrikeThruText(this.mSelectedTextStrikeThru);
                this.mSelectorWheelPaint.setUnderlineText(this.mSelectedTextUnderline);
                this.mSelectorWheelPaint.setTypeface(this.mSelectedTypeface);
                scrollSelectorValue = scrollSelectorValue + this.label;
            } else {
                this.mSelectorWheelPaint.setTextAlign(Paint.Align.values()[this.mTextAlign]);
                this.mSelectorWheelPaint.setTextSize(this.mTextSize);
                this.mSelectorWheelPaint.setColor(this.mTextColor);
                this.mSelectorWheelPaint.setFakeBoldText(this.textBold);
                this.mSelectorWheelPaint.setStrikeThruText(this.mTextStrikeThru);
                this.mSelectorWheelPaint.setUnderlineText(this.mTextUnderline);
                this.mSelectorWheelPaint.setTypeface(this.mTypeface);
                scrollSelectorValue = scrollSelectorValue.replace(this.label, "");
            }
            if (scrollSelectorValue == null) continue;
            if (showSelectorWheel && i != this.mWheelMiddleItemIndex || i == this.mWheelMiddleItemIndex && this.mSelectedText.getVisibility() != 0) {
                float textY = y;
                if (!this.isHorizontalMode()) {
                    textY += this.getPaintCenterY(this.mSelectorWheelPaint.getFontMetrics());
                }
                int xOffset = 0;
                int yOffset = 0;
                if (i != this.mWheelMiddleItemIndex && this.mItemSpacing != 0) {
                    if (this.isHorizontalMode()) {
                        xOffset = i > this.mWheelMiddleItemIndex ? this.mItemSpacing : -this.mItemSpacing;
                    } else {
                        yOffset = i > this.mWheelMiddleItemIndex ? this.mItemSpacing : -this.mItemSpacing;
                    }
                }
                this.drawText(scrollSelectorValue, x + (float)xOffset, textY + (float)yOffset, this.mSelectorWheelPaint, canvas);
            }
            if (this.isHorizontalMode()) {
                x += (float)this.mSelectorElementSize;
                continue;
            }
            y += (float)this.mSelectorElementSize;
        }
        canvas.restore();
        if (showSelectorWheel && this.mDividerDrawable != null) {
            if (this.isHorizontalMode()) {
                this.drawHorizontalDividers(canvas);
            } else {
                this.drawVerticalDividers(canvas);
            }
        }
    }

    private void drawHorizontalDividers(Canvas canvas) {
        switch (this.mDividerType) {
            case 0: {
                int bottom;
                int top;
                if (this.mDividerLength > 0 && this.mDividerLength <= this.mMaxHeight) {
                    top = (this.mMaxHeight - this.mDividerLength) / 2;
                    bottom = top + this.mDividerLength;
                } else {
                    top = 0;
                    bottom = this.getBottom();
                }
                int leftOfLeftDivider = this.mLeftDividerLeft;
                int rightOfLeftDivider = leftOfLeftDivider + this.mDividerThickness;
                this.mDividerDrawable.setBounds(leftOfLeftDivider, top, rightOfLeftDivider, bottom);
                this.mDividerDrawable.draw(canvas);
                int rightOfRightDivider = this.mRightDividerRight;
                int leftOfRightDivider = rightOfRightDivider - this.mDividerThickness;
                this.mDividerDrawable.setBounds(leftOfRightDivider, top, rightOfRightDivider, bottom);
                this.mDividerDrawable.draw(canvas);
                break;
            }
            case 1: {
                int right;
                int left;
                if (this.mDividerLength > 0 && this.mDividerLength <= this.mMaxWidth) {
                    left = (this.mMaxWidth - this.mDividerLength) / 2;
                    right = left + this.mDividerLength;
                } else {
                    left = this.mLeftDividerLeft;
                    right = this.mRightDividerRight;
                }
                int bottomOfUnderlineDivider = this.mBottomDividerBottom;
                int topOfUnderlineDivider = bottomOfUnderlineDivider - this.mDividerThickness;
                this.mDividerDrawable.setBounds(left, topOfUnderlineDivider, right, bottomOfUnderlineDivider);
                this.mDividerDrawable.draw(canvas);
            }
        }
    }

    private void drawVerticalDividers(Canvas canvas) {
        int right;
        int left;
        if (this.mDividerLength > 0 && this.mDividerLength <= this.mMaxWidth) {
            left = (this.mMaxWidth - this.mDividerLength) / 2;
            right = left + this.mDividerLength;
        } else {
            left = 0;
            right = this.getRight();
        }
        switch (this.mDividerType) {
            case 0: {
                int topOfTopDivider = this.mTopDividerTop;
                int bottomOfTopDivider = topOfTopDivider + this.mDividerThickness;
                this.mDividerDrawable.setBounds(left, topOfTopDivider, right, bottomOfTopDivider);
                this.mDividerDrawable.draw(canvas);
                int bottomOfBottomDivider = this.mBottomDividerBottom;
                int topOfBottomDivider = bottomOfBottomDivider - this.mDividerThickness;
                this.mDividerDrawable.setBounds(left, topOfBottomDivider, right, bottomOfBottomDivider);
                this.mDividerDrawable.draw(canvas);
                break;
            }
            case 1: {
                int bottomOfUnderlineDivider = this.mBottomDividerBottom;
                int topOfUnderlineDivider = bottomOfUnderlineDivider - this.mDividerThickness;
                this.mDividerDrawable.setBounds(left, topOfUnderlineDivider, right, bottomOfUnderlineDivider);
                this.mDividerDrawable.draw(canvas);
            }
        }
    }

    private void drawText(String text, float x, float y, Paint paint, Canvas canvas) {
        if (text.contains("\n")) {
            String[] lines = text.split("\n");
            float height = Math.abs(paint.descent() + paint.ascent()) * this.mLineSpacingMultiplier;
            float diff = (float)(lines.length - 1) * height / 2.0f;
            y -= diff;
            for (String line : lines) {
                canvas.drawText(line, x, y, paint);
                y += height;
            }
        } else {
            canvas.drawText(text, x, y, paint);
        }
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)NumberPicker.class.getName());
        event.setScrollable(this.isScrollerEnabled());
        int scroll = (this.mMinValue + this.mValue) * this.mSelectorElementSize;
        int maxScroll = (this.mMaxValue - this.mMinValue) * this.mSelectorElementSize;
        if (this.isHorizontalMode()) {
            event.setScrollX(scroll);
            event.setMaxScrollX(maxScroll);
        } else {
            event.setScrollY(scroll);
            event.setMaxScrollY(maxScroll);
        }
    }

    private int makeMeasureSpec(int measureSpec, int maxSize) {
        if (maxSize == -1) {
            return measureSpec;
        }
        int size = View.MeasureSpec.getSize((int)measureSpec);
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        switch (mode) {
            case 0x40000000: {
                return measureSpec;
            }
            case -2147483648: {
                return View.MeasureSpec.makeMeasureSpec((int)Math.min(size, maxSize), (int)0x40000000);
            }
            case 0: {
                return View.MeasureSpec.makeMeasureSpec((int)maxSize, (int)0x40000000);
            }
        }
        throw new IllegalArgumentException("Unknown measure mode: " + mode);
    }

    private int resolveSizeAndStateRespectingMinSize(int minSize, int measuredSize, int measureSpec) {
        if (minSize != -1) {
            int desiredWidth = Math.max(minSize, measuredSize);
            return NumberPicker.resolveSizeAndState(desiredWidth, measureSpec, 0);
        }
        return measuredSize;
    }

    public static int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
        int result = size;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: {
                if (specSize < size) {
                    result = specSize | 0x1000000;
                    break;
                }
                result = size;
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result | childMeasuredState & 0xFF000000;
    }

    private void initializeSelectorWheelIndices() {
        this.mSelectorIndexToStringCache.clear();
        int[] selectorIndices = this.getSelectorIndices();
        int current = this.getValue();
        for (int i = 0; i < selectorIndices.length; ++i) {
            int selectorIndex = current + (i - this.mWheelMiddleItemIndex);
            if (this.mWrapSelectorWheel) {
                selectorIndex = this.getWrappedSelectorIndex(selectorIndex);
            }
            selectorIndices[i] = selectorIndex;
            this.ensureCachedScrollSelectorValue(selectorIndices[i]);
        }
    }

    private void setValueInternal(int current, boolean notifyChange) {
        if (this.mValue == current) {
            return;
        }
        if (this.mWrapSelectorWheel) {
            current = this.getWrappedSelectorIndex(current);
        } else {
            current = Math.max(current, this.mMinValue);
            current = Math.min(current, this.mMaxValue);
        }
        int previous = this.mValue;
        this.mValue = current;
        if (this.mScrollState != 2) {
            this.updateInputTextView();
        }
        if (notifyChange) {
            this.notifyChange(previous, current);
        }
        this.initializeSelectorWheelIndices();
        this.updateAccessibilityDescription();
        this.invalidate();
    }

    private void updateAccessibilityDescription() {
        if (!this.mAccessibilityDescriptionEnabled) {
            return;
        }
        this.setContentDescription(String.valueOf(this.getValue()));
    }

    private void changeValueByOne(boolean increment) {
        if (!this.moveToFinalScrollerPosition(this.mFlingScroller)) {
            this.moveToFinalScrollerPosition(this.mAdjustScroller);
        }
        this.smoothScroll(increment, 1);
    }

    public void smoothScrollToPosition(int position) {
        int currentPosition = this.getSelectorIndices()[this.mWheelMiddleItemIndex];
        if (currentPosition == position) {
            return;
        }
        this.smoothScroll(position > currentPosition, Math.abs(position - currentPosition));
    }

    public void smoothScroll(boolean increment, int steps) {
        int diffSteps = (increment ? -this.mSelectorElementSize : this.mSelectorElementSize) * steps;
        if (this.isHorizontalMode()) {
            this.mPreviousScrollerX = 0;
            this.mFlingScroller.startScroll(0, 0, diffSteps, 0, 300);
        } else {
            this.mPreviousScrollerY = 0;
            this.mFlingScroller.startScroll(0, 0, 0, diffSteps, 300);
        }
        this.invalidate();
    }

    private void initializeSelectorWheel() {
        this.initializeSelectorWheelIndices();
        int[] selectorIndices = this.getSelectorIndices();
        int totalTextSize = (int)((float)(selectorIndices.length - 1) * this.mTextSize + this.mSelectedTextSize);
        float textGapCount = selectorIndices.length;
        if (this.isHorizontalMode()) {
            float totalTextGapWidth = this.getRight() - this.getLeft() - totalTextSize;
            this.mSelectorTextGapWidth = (int)(totalTextGapWidth / textGapCount);
            this.mSelectorElementSize = (int)this.getMaxTextSize() + this.mSelectorTextGapWidth;
            this.mInitialScrollOffset = (int)(this.mSelectedTextCenterX - (float)(this.mSelectorElementSize * this.mWheelMiddleItemIndex));
        } else {
            float totalTextGapHeight = this.getBottom() - this.getTop() - totalTextSize;
            this.mSelectorTextGapHeight = (int)(totalTextGapHeight / textGapCount);
            this.mSelectorElementSize = (int)this.getMaxTextSize() + this.mSelectorTextGapHeight;
            this.mInitialScrollOffset = (int)(this.mSelectedTextCenterY - (float)(this.mSelectorElementSize * this.mWheelMiddleItemIndex));
        }
        this.mCurrentScrollOffset = this.mInitialScrollOffset;
        this.updateInputTextView();
    }

    private void initializeFadingEdges() {
        if (this.isHorizontalMode()) {
            this.setHorizontalFadingEdgeEnabled(true);
            this.setVerticalFadingEdgeEnabled(false);
            this.setFadingEdgeLength((this.getRight() - this.getLeft() - (int)this.mTextSize) / 2);
        } else {
            this.setHorizontalFadingEdgeEnabled(false);
            this.setVerticalFadingEdgeEnabled(true);
            this.setFadingEdgeLength((this.getBottom() - this.getTop() - (int)this.mTextSize) / 2);
        }
    }

    private void onScrollerFinished(Scroller scroller) {
        if (scroller == this.mFlingScroller) {
            this.ensureScrollWheelAdjusted();
            this.updateInputTextView();
            this.onScrollStateChange(0);
        } else if (this.mScrollState != 1) {
            this.updateInputTextView();
        }
    }

    private void onScrollStateChange(int scrollState) {
        if (this.mScrollState == scrollState) {
            return;
        }
        this.mScrollState = scrollState;
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChange(this, scrollState);
        }
    }

    private void fling(int velocity) {
        if (this.isHorizontalMode()) {
            this.mPreviousScrollerX = 0;
            if (velocity > 0) {
                this.mFlingScroller.fling(0, 0, velocity, 0, 0, Integer.MAX_VALUE, 0, 0);
            } else {
                this.mFlingScroller.fling(Integer.MAX_VALUE, 0, velocity, 0, 0, Integer.MAX_VALUE, 0, 0);
            }
        } else {
            this.mPreviousScrollerY = 0;
            if (velocity > 0) {
                this.mFlingScroller.fling(0, 0, 0, velocity, 0, 0, 0, Integer.MAX_VALUE);
            } else {
                this.mFlingScroller.fling(0, Integer.MAX_VALUE, 0, velocity, 0, 0, 0, Integer.MAX_VALUE);
            }
        }
        this.invalidate();
    }

    private int getWrappedSelectorIndex(int selectorIndex) {
        if (selectorIndex > this.mMaxValue) {
            return this.mMinValue + (selectorIndex - this.mMaxValue) % (this.mMaxValue - this.mMinValue) - 1;
        }
        if (selectorIndex < this.mMinValue) {
            return this.mMaxValue - (this.mMinValue - selectorIndex) % (this.mMaxValue - this.mMinValue) + 1;
        }
        return selectorIndex;
    }

    private int[] getSelectorIndices() {
        return this.mSelectorIndices;
    }

    private void incrementSelectorIndices(int[] selectorIndices) {
        for (int i = 0; i < selectorIndices.length - 1; ++i) {
            selectorIndices[i] = selectorIndices[i + 1];
        }
        int nextScrollSelectorIndex = selectorIndices[selectorIndices.length - 2] + 1;
        if (this.mWrapSelectorWheel && nextScrollSelectorIndex > this.mMaxValue) {
            nextScrollSelectorIndex = this.mMinValue;
        }
        selectorIndices[selectorIndices.length - 1] = nextScrollSelectorIndex;
        this.ensureCachedScrollSelectorValue(nextScrollSelectorIndex);
    }

    private void decrementSelectorIndices(int[] selectorIndices) {
        for (int i = selectorIndices.length - 1; i > 0; --i) {
            selectorIndices[i] = selectorIndices[i - 1];
        }
        int nextScrollSelectorIndex = selectorIndices[1] - 1;
        if (this.mWrapSelectorWheel && nextScrollSelectorIndex < this.mMinValue) {
            nextScrollSelectorIndex = this.mMaxValue;
        }
        selectorIndices[0] = nextScrollSelectorIndex;
        this.ensureCachedScrollSelectorValue(nextScrollSelectorIndex);
    }

    private void ensureCachedScrollSelectorValue(int selectorIndex) {
        SparseArray<String> cache = this.mSelectorIndexToStringCache;
        String scrollSelectorValue = (String)cache.get(selectorIndex);
        if (scrollSelectorValue != null) {
            return;
        }
        if (selectorIndex < this.mMinValue || selectorIndex > this.mMaxValue) {
            scrollSelectorValue = "";
        } else if (this.mDisplayedValues != null) {
            int displayedValueIndex = selectorIndex - this.mMinValue;
            if (displayedValueIndex >= this.mDisplayedValues.length) {
                cache.remove(selectorIndex);
                return;
            }
            scrollSelectorValue = this.mDisplayedValues[displayedValueIndex];
        } else {
            scrollSelectorValue = this.formatNumber(selectorIndex);
        }
        cache.put(selectorIndex, (Object)scrollSelectorValue);
    }

    private String formatNumber(int value) {
        return this.mFormatter != null ? this.mFormatter.format(value) : this.formatNumberWithLocale(value);
    }

    private void updateInputTextView() {
        String text;
        String string = text = this.mDisplayedValues == null ? this.formatNumber(this.mValue) : this.mDisplayedValues[this.mValue - this.mMinValue];
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        Editable beforeText = this.mSelectedText.getText();
        if (text.equals(beforeText.toString())) {
            return;
        }
        this.mSelectedText.setText((CharSequence)(text + this.label));
    }

    private void notifyChange(int previous, int current) {
        if (this.mOnValueChangeListener != null) {
            this.mOnValueChangeListener.onValueChange(this, previous, current);
        }
    }

    private void postChangeCurrentByOneFromLongPress(boolean increment, long delayMillis) {
        if (this.mChangeCurrentByOneFromLongPressCommand == null) {
            this.mChangeCurrentByOneFromLongPressCommand = new ChangeCurrentByOneFromLongPressCommand();
        } else {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
        this.mChangeCurrentByOneFromLongPressCommand.setStep(increment);
        this.postDelayed(this.mChangeCurrentByOneFromLongPressCommand, delayMillis);
    }

    private void postChangeCurrentByOneFromLongPress(boolean increment) {
        this.postChangeCurrentByOneFromLongPress(increment, ViewConfiguration.getLongPressTimeout());
    }

    private void removeChangeCurrentByOneFromLongPress() {
        if (this.mChangeCurrentByOneFromLongPressCommand != null) {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
    }

    private void removeAllCallbacks() {
        if (this.mChangeCurrentByOneFromLongPressCommand != null) {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
        if (this.mSetSelectionCommand != null) {
            this.mSetSelectionCommand.cancel();
        }
    }

    private int getSelectedPos(String value) {
        if (this.mDisplayedValues == null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            for (int i = 0; i < this.mDisplayedValues.length; ++i) {
                value = value.toLowerCase();
                if (!this.mDisplayedValues[i].toLowerCase().startsWith(value)) continue;
                return this.mMinValue + i;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.mMinValue;
    }

    private void postSetSelectionCommand(int selectionStart, int selectionEnd) {
        if (this.mSetSelectionCommand == null) {
            this.mSetSelectionCommand = new SetSelectionCommand(this.mSelectedText);
        } else {
            this.mSetSelectionCommand.post(selectionStart, selectionEnd);
        }
    }

    private void ensureScrollWheelAdjusted() {
        int delta = this.mInitialScrollOffset - this.mCurrentScrollOffset;
        if (delta == 0) {
            return;
        }
        if (Math.abs(delta) > this.mSelectorElementSize / 2) {
            delta += delta > 0 ? -this.mSelectorElementSize : this.mSelectorElementSize;
        }
        if (this.isHorizontalMode()) {
            this.mPreviousScrollerX = 0;
            this.mAdjustScroller.startScroll(0, 0, delta, 0, 800);
        } else {
            this.mPreviousScrollerY = 0;
            this.mAdjustScroller.startScroll(0, 0, 0, delta, 800);
        }
        this.invalidate();
    }

    private String formatNumberWithLocale(int value) {
        return value + "";
    }

    private float dpToPx(float dp) {
        return dp * this.getResources().getDisplayMetrics().density;
    }

    private float pxToDp(float px) {
        return px / this.getResources().getDisplayMetrics().density;
    }

    private float spToPx(float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private float pxToSp(float px) {
        return px / this.getResources().getDisplayMetrics().scaledDensity;
    }

    private Formatter stringToFormatter(final String formatter) {
        if (TextUtils.isEmpty((CharSequence)formatter)) {
            return null;
        }
        return new Formatter(){

            @Override
            public String format(int i) {
                return String.format(Locale.getDefault(), formatter, i);
            }
        };
    }

    private void setWidthAndHeight() {
        if (this.isHorizontalMode()) {
            this.mMinHeight = -1;
            this.mMaxHeight = (int)this.dpToPx(58.0f);
            this.mMinWidth = (int)this.dpToPx(180.0f);
            this.mMaxWidth = -1;
        } else {
            this.mMinHeight = -1;
            this.mMaxHeight = (int)this.dpToPx(180.0f);
            this.mMinWidth = (int)this.dpToPx(58.0f);
            this.mMaxWidth = -1;
        }
    }

    public void setAccessibilityDescriptionEnabled(boolean enabled) {
        this.mAccessibilityDescriptionEnabled = enabled;
    }

    public void setDividerColor(@ColorInt int color2) {
        this.mDividerColor = color2;
        this.mDividerDrawable = new ColorDrawable(color2);
    }

    public void setDividerColorResource(@ColorRes int colorId) {
        this.setDividerColor(ContextCompat.getColor((Context)this.mContext, (int)colorId));
    }

    public void setDividerDistance(int distance) {
        this.mDividerDistance = distance;
    }

    public void setDividerDistanceResource(@DimenRes int dimenId) {
        this.setDividerDistance(this.getResources().getDimensionPixelSize(dimenId));
    }

    public void setDividerType(int dividerType) {
        this.mDividerType = dividerType;
        this.invalidate();
    }

    public void setDividerThickness(int thickness) {
        this.mDividerThickness = thickness;
    }

    public void setDividerThicknessResource(@DimenRes int dimenId) {
        this.setDividerThickness(this.getResources().getDimensionPixelSize(dimenId));
    }

    public void setOrder(int order) {
        this.mOrder = order;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
        this.setWidthAndHeight();
        this.requestLayout();
    }

    public void setWheelItemCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Wheel item count must be >= 1");
        }
        this.mRealWheelItemCount = count;
        this.mWheelItemCount = Math.max(count, 3);
        this.mWheelMiddleItemIndex = this.mWheelItemCount / 2;
        this.mSelectorIndices = new int[this.mWheelItemCount];
    }

    public void setFormatter(String formatter) {
        if (TextUtils.isEmpty((CharSequence)formatter)) {
            return;
        }
        this.setFormatter(this.stringToFormatter(formatter));
    }

    public void setFormatter(@StringRes int stringId) {
        this.setFormatter(this.getResources().getString(stringId));
    }

    public void setFadingEdgeEnabled(boolean fadingEdgeEnabled) {
        this.mFadingEdgeEnabled = fadingEdgeEnabled;
    }

    public void setFadingEdgeStrength(float strength) {
        this.mFadingEdgeStrength = strength;
    }

    public void setScrollerEnabled(boolean scrollerEnabled) {
        this.mScrollerEnabled = scrollerEnabled;
    }

    public void setSelectedTextAlign(int align) {
        this.mSelectedTextAlign = align;
    }

    public void setSelectedTextColor(@ColorInt int color2) {
        this.mSelectedTextColor = color2;
        this.mSelectedText.setTextColor(this.mSelectedTextColor);
    }

    public void setSelectedTextColorResource(@ColorRes int colorId) {
        this.setSelectedTextColor(ContextCompat.getColor((Context)this.mContext, (int)colorId));
    }

    public void setSelectedTextSize(float textSize) {
        this.mSelectedTextSize = textSize;
        this.mSelectedText.setTextSize(this.pxToSp(this.mSelectedTextSize));
    }

    public void setSelectedTextSize(@DimenRes int dimenId) {
        this.setSelectedTextSize(this.getResources().getDimension(dimenId));
    }

    public void setSelectedTextStrikeThru(boolean strikeThruText) {
        this.mSelectedTextStrikeThru = strikeThruText;
    }

    public void setSelectedTextUnderline(boolean underlineText) {
        this.mSelectedTextUnderline = underlineText;
    }

    public void setSelectedTypeface(Typeface typeface) {
        this.mSelectedTypeface = typeface;
        if (this.mSelectedTypeface != null) {
            this.mSelectorWheelPaint.setTypeface(this.mSelectedTypeface);
        } else if (this.mTypeface != null) {
            this.mSelectorWheelPaint.setTypeface(this.mTypeface);
        } else {
            this.mSelectorWheelPaint.setTypeface(Typeface.MONOSPACE);
        }
    }

    public void setSelectedTypeface(String string, int style) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.setSelectedTypeface(Typeface.create((String)string, (int)style));
    }

    public void setSelectedTypeface(String string) {
        this.setSelectedTypeface(string, 0);
    }

    public void setSelectedTypeface(@StringRes int stringId, int style) {
        this.setSelectedTypeface(this.getResources().getString(stringId), style);
    }

    public void setSelectedTypeface(@StringRes int stringId) {
        this.setSelectedTypeface(stringId, 0);
    }

    public void setTextAlign(int align) {
        this.mTextAlign = align;
    }

    public void setTextColor(@ColorInt int color2) {
        this.mTextColor = color2;
        this.mSelectorWheelPaint.setColor(this.mTextColor);
    }

    public void setTextColorResource(@ColorRes int colorId) {
        this.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)colorId));
    }

    public void setTextSize(float textSize) {
        this.mTextSize = textSize;
        this.mSelectorWheelPaint.setTextSize(this.mTextSize);
    }

    public void setTextSize(@DimenRes int dimenId) {
        this.setTextSize(this.getResources().getDimension(dimenId));
    }

    public void setTextStrikeThru(boolean strikeThruText) {
        this.mTextStrikeThru = strikeThruText;
    }

    public void setTextUnderline(boolean underlineText) {
        this.mTextUnderline = underlineText;
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
        if (this.mTypeface != null) {
            this.mSelectedText.setTypeface(this.mTypeface);
            this.setSelectedTypeface(this.mSelectedTypeface);
        } else {
            this.mSelectedText.setTypeface(Typeface.MONOSPACE);
        }
    }

    public void setTypeface(String string, int style) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.setTypeface(Typeface.create((String)string, (int)style));
    }

    public void setTypeface(String string) {
        this.setTypeface(string, 0);
    }

    public void setTypeface(@StringRes int stringId, int style) {
        this.setTypeface(this.getResources().getString(stringId), style);
    }

    public void setTypeface(@StringRes int stringId) {
        this.setTypeface(stringId, 0);
    }

    public void setLineSpacingMultiplier(float multiplier) {
        this.mLineSpacingMultiplier = multiplier;
    }

    public void setMaxFlingVelocityCoefficient(int coefficient) {
        this.mMaxFlingVelocityCoefficient = coefficient;
        this.mMaximumFlingVelocity = this.mViewConfiguration.getScaledMaximumFlingVelocity() / this.mMaxFlingVelocityCoefficient;
    }

    public void setItemSpacing(int itemSpacing) {
        this.mItemSpacing = itemSpacing;
    }

    public boolean isHorizontalMode() {
        return this.getOrientation() == 0;
    }

    public boolean isAscendingOrder() {
        return this.getOrder() == 0;
    }

    public boolean isAccessibilityDescriptionEnabled() {
        return this.mAccessibilityDescriptionEnabled;
    }

    public int getDividerColor() {
        return this.mDividerColor;
    }

    public float getDividerDistance() {
        return this.pxToDp(this.mDividerDistance);
    }

    public float getDividerThickness() {
        return this.pxToDp(this.mDividerThickness);
    }

    public int getOrder() {
        return this.mOrder;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getWheelItemCount() {
        return this.mWheelItemCount;
    }

    public Formatter getFormatter() {
        return this.mFormatter;
    }

    public boolean isFadingEdgeEnabled() {
        return this.mFadingEdgeEnabled;
    }

    public float getFadingEdgeStrength() {
        return this.mFadingEdgeStrength;
    }

    public boolean isScrollerEnabled() {
        return this.mScrollerEnabled;
    }

    public int getSelectedTextAlign() {
        return this.mSelectedTextAlign;
    }

    public int getSelectedTextColor() {
        return this.mSelectedTextColor;
    }

    public float getSelectedTextSize() {
        return this.mSelectedTextSize;
    }

    public boolean getSelectedTextStrikeThru() {
        return this.mSelectedTextStrikeThru;
    }

    public boolean getSelectedTextUnderline() {
        return this.mSelectedTextUnderline;
    }

    public int getTextAlign() {
        return this.mTextAlign;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public float getTextSize() {
        return this.spToPx(this.mTextSize);
    }

    public boolean getTextStrikeThru() {
        return this.mTextStrikeThru;
    }

    public boolean getTextUnderline() {
        return this.mTextUnderline;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public float getLineSpacingMultiplier() {
        return this.mLineSpacingMultiplier;
    }

    public int getMaxFlingVelocityCoefficient() {
        return this.mMaxFlingVelocityCoefficient;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isTextBold() {
        return this.textBold;
    }

    public void setTextBold(boolean bold) {
        this.textBold = bold;
    }

    public boolean isSelectedTextBold() {
        return this.selectedTextBold;
    }

    public void setSelectedTextBold(boolean selectBold) {
        this.selectedTextBold = selectBold;
    }

    class ChangeCurrentByOneFromLongPressCommand
    implements Runnable {
        private boolean mIncrement;

        ChangeCurrentByOneFromLongPressCommand() {
        }

        private void setStep(boolean increment) {
            this.mIncrement = increment;
        }

        @Override
        public void run() {
            NumberPicker.this.changeValueByOne(this.mIncrement);
            NumberPicker.this.postDelayed(this, NumberPicker.this.mLongPressUpdateInterval);
        }
    }

    private static class SetSelectionCommand
    implements Runnable {
        private final EditText mInputText;
        private int mSelectionStart;
        private int mSelectionEnd;
        private boolean mPosted;

        SetSelectionCommand(EditText inputText) {
            this.mInputText = inputText;
        }

        void post(int selectionStart, int selectionEnd) {
            this.mSelectionStart = selectionStart;
            this.mSelectionEnd = selectionEnd;
            if (!this.mPosted) {
                this.mInputText.post((Runnable)this);
                this.mPosted = true;
            }
        }

        void cancel() {
            if (this.mPosted) {
                this.mInputText.removeCallbacks((Runnable)this);
                this.mPosted = false;
            }
        }

        @Override
        public void run() {
            this.mPosted = false;
            this.mInputText.setSelection(this.mSelectionStart, this.mSelectionEnd);
        }
    }

    class InputTextFilter
    extends NumberKeyListener {
        InputTextFilter() {
        }

        public int getInputType() {
            return 1;
        }

        protected char[] getAcceptedChars() {
            return DIGIT_CHARACTERS;
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (NumberPicker.this.mSetSelectionCommand != null) {
                NumberPicker.this.mSetSelectionCommand.cancel();
            }
            if (NumberPicker.this.mDisplayedValues == null) {
                String result;
                CharSequence filtered = super.filter(source, start, end, dest, dstart, dend);
                if (filtered == null) {
                    filtered = source.subSequence(start, end);
                }
                if ("".equals(result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length()))) {
                    return result;
                }
                int val = NumberPicker.this.getSelectedPos(result);
                if (val > NumberPicker.this.mMaxValue || result.length() > String.valueOf(NumberPicker.this.mMaxValue).length()) {
                    return "";
                }
                return filtered;
            }
            String filtered = String.valueOf(source.subSequence(start, end));
            if (TextUtils.isEmpty((CharSequence)filtered)) {
                return "";
            }
            String result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length());
            String str = String.valueOf(result).toLowerCase();
            for (String val : NumberPicker.this.mDisplayedValues) {
                String valLowerCase = val.toLowerCase();
                if (!valLowerCase.startsWith(str)) continue;
                NumberPicker.this.postSetSelectionCommand(result.length(), val.length());
                return val.subSequence(dstart, val.length());
            }
            return "";
        }
    }

    public static interface Formatter {
        public String format(int var1);
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChange(NumberPicker var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ScrollState {
        }
    }

    public static interface OnValueChangeListener {
        public void onValueChange(NumberPicker var1, int var2, int var3);
    }

    private static class TwoDigitFormatter
    implements Formatter {
        final StringBuilder mBuilder = new StringBuilder();
        char mZeroDigit;
        java.util.Formatter mFmt;
        final Object[] mArgs = new Object[1];

        TwoDigitFormatter() {
            Locale locale = Locale.getDefault();
            this.init(locale);
        }

        private void init(Locale locale) {
            this.mFmt = this.createFormatter(locale);
            this.mZeroDigit = TwoDigitFormatter.getZeroDigit(locale);
        }

        @Override
        public String format(int value) {
            Locale currentLocale = Locale.getDefault();
            if (this.mZeroDigit != TwoDigitFormatter.getZeroDigit(currentLocale)) {
                this.init(currentLocale);
            }
            this.mArgs[0] = value;
            this.mBuilder.delete(0, this.mBuilder.length());
            this.mFmt.format("%02d", this.mArgs);
            return this.mFmt.toString();
        }

        private static char getZeroDigit(Locale locale) {
            return new DecimalFormatSymbols(locale).getZeroDigit();
        }

        private java.util.Formatter createFormatter(Locale locale) {
            return new java.util.Formatter(this.mBuilder, locale);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DividerType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Align {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Order {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

