/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import com.github.loki4j.client.batch.LogRecordStream;
import com.github.loki4j.client.util.ArrayUtils;
import com.github.loki4j.client.util.Cache;
import com.github.loki4j.client.util.StringUtils;
import com.github.loki4j.logback.Loki4jEncoder;
import com.github.loki4j.logback.MultiPatternExtractor;
import com.github.loki4j.slf4j.marker.AbstractKeyValueMarker;
import com.github.loki4j.slf4j.marker.LabelMarker;
import com.github.loki4j.slf4j.marker.StructuredMetadataMarker;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Marker;

public abstract class AbstractLoki4jEncoder
extends ContextAwareBase
implements Loki4jEncoder {
    private static final String REGEX_STARTER = "regex:";
    private static final String[] EMPTY_KV_PAIRS = new String[0];
    private static final String DEFAULT_MSG_PATTERN = "l=%level c=%logger{20} t=%thread | %msg %ex";
    protected final Charset charset = StandardCharsets.UTF_8;
    private LabelCfg label = new LabelCfg();
    private volatile boolean staticLabels = false;
    private List<String> labelKeys;
    private MultiPatternExtractor<ILoggingEvent> labelValuesExtractor;
    private List<String> metadataKeys;
    private MultiPatternExtractor<ILoggingEvent> metadataValuesExtractor;
    private Layout<ILoggingEvent> messageLayout;
    private LogRecordStream staticLabelStream = null;
    private boolean started = false;

    public void start() {
        String labelPattern;
        String string = labelPattern = this.label.pattern == null ? "level=%level,host=" + this.context.getProperty("HOSTNAME") : this.label.pattern;
        if (this.label.streamCache == null) {
            this.label.streamCache = new Cache.BoundAtomicMapCache<String, LogRecordStream>();
        }
        String[] labelKVPatterns = AbstractLoki4jEncoder.extractKVPairsFromPattern(labelPattern, this.label.pairSeparator, this.label.keyValueSeparator);
        this.labelKeys = AbstractLoki4jEncoder.extractIndexesMod2(labelKVPatterns, 0);
        List<String> labelPatterns = AbstractLoki4jEncoder.extractIndexesMod2(labelKVPatterns, 1);
        try {
            this.labelValuesExtractor = new MultiPatternExtractor(labelPatterns, this.context);
        }
        catch (ScanException e) {
            throw new IllegalArgumentException("Unable to parse label pattern: \"" + labelPattern + "\"", e);
        }
        if (this.label.structuredMetadataPattern != null) {
            String[] metadataKVPatterns = AbstractLoki4jEncoder.extractKVPairsFromPattern(this.label.structuredMetadataPattern, this.label.pairSeparator, this.label.keyValueSeparator);
            this.metadataKeys = AbstractLoki4jEncoder.extractIndexesMod2(metadataKVPatterns, 0);
            List<String> metadataPatterns = AbstractLoki4jEncoder.extractIndexesMod2(metadataKVPatterns, 1);
            try {
                this.metadataValuesExtractor = new MultiPatternExtractor(metadataPatterns, this.context);
            }
            catch (ScanException e) {
                throw new IllegalArgumentException("Unable to parse structured metadata pattern: \"" + this.label.structuredMetadataPattern + "\"", e);
            }
        }
        if (this.messageLayout == null) {
            this.addWarn("No message layout specified in the config. Using PatternLayout with default settings");
            this.messageLayout = this.initPatternLayout(DEFAULT_MSG_PATTERN);
        }
        this.messageLayout.setContext(this.context);
        this.messageLayout.start();
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.messageLayout.stop();
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public LogRecordStream eventToStream(ILoggingEvent e) {
        if (this.staticLabels) {
            if (this.staticLabelStream == null) {
                this.staticLabelStream = LogRecordStream.create(AbstractLoki4jEncoder.mergeKVPairs(this.labelKeys, this.labelValuesExtractor.extract(e)));
            }
            return this.staticLabelStream;
        }
        String[] labelValues = this.labelValuesExtractor.extract(e);
        String[] markerLabels = this.label.readMarkers && e.getMarkerList() != null ? this.extractMarkers(e.getMarkerList(), LabelMarker.class) : EMPTY_KV_PAIRS;
        String streamKey = ArrayUtils.join2(labelValues, markerLabels, " !%! ");
        return this.label.streamCache.get(streamKey, () -> {
            String[] layoutLabels = AbstractLoki4jEncoder.mergeKVPairs(this.labelKeys, labelValues);
            String[] allLabels = ArrayUtils.concat(layoutLabels, markerLabels);
            return LogRecordStream.create(allLabels);
        });
    }

    @Override
    public String eventToMessage(ILoggingEvent e) {
        return this.messageLayout.doLayout((Object)e);
    }

    @Override
    public String[] eventToMetadata(ILoggingEvent e) {
        String[] markerKVs = this.label.readMarkers && e.getMarkerList() != null ? this.extractMarkers(e.getMarkerList(), StructuredMetadataMarker.class) : EMPTY_KV_PAIRS;
        String[] patternKVs = EMPTY_KV_PAIRS;
        if (this.metadataValuesExtractor != null) {
            String[] metadataValues = this.metadataValuesExtractor.extract(e);
            patternKVs = AbstractLoki4jEncoder.mergeKVPairs(this.metadataKeys, metadataValues);
        }
        String[] allKVs = ArrayUtils.concat(patternKVs, markerKVs);
        return allKVs;
    }

    private PatternLayout initPatternLayout(String pattern) {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setPattern(pattern);
        return patternLayout;
    }

    static String[] extractKVPairsFromPattern(String pattern, String pairSeparator, String keyValueSeparator) {
        Pattern pairSeparatorPattern = pairSeparator.startsWith(REGEX_STARTER) ? Pattern.compile(pairSeparator.substring(REGEX_STARTER.length())) : Pattern.compile(Pattern.quote(pairSeparator));
        Pattern keyValueSeparatorPattern = Pattern.compile(Pattern.quote(keyValueSeparator));
        String[] pairs = pairSeparatorPattern.split(pattern);
        String[] result = new String[pairs.length * 2];
        int pos = 0;
        for (int i = 0; i < pairs.length; ++i) {
            if (StringUtils.isBlank(pairs[i])) continue;
            String[] kv = keyValueSeparatorPattern.split(pairs[i]);
            if (kv.length == 2) {
                result[pos] = kv[0].trim();
                result[pos + 1] = kv[1].trim();
                pos += 2;
                continue;
            }
            throw new IllegalArgumentException(String.format("Unable to split '%s' in '%s' to key-value pairs, pairSeparator=%s, keyValueSeparator=%s", pairs[i], pattern, pairSeparator, keyValueSeparator));
        }
        if (pos == 0) {
            throw new IllegalArgumentException("Empty of blank patterns are not supported");
        }
        return Arrays.copyOf(result, pos);
    }

    private <T extends AbstractKeyValueMarker> String[] extractMarkers(List<Marker> markers, Class<T> clazz) {
        for (Marker marker : markers) {
            if (marker == null || !clazz.isAssignableFrom(marker.getClass())) continue;
            return this.extractKVPairsFromMarker((AbstractKeyValueMarker)marker);
        }
        return EMPTY_KV_PAIRS;
    }

    private String[] extractKVPairsFromMarker(AbstractKeyValueMarker marker) {
        Map<String, String> map = marker.getKeyValuePairs();
        String[] markerKVPairs = new String[map.size() * 2];
        int pos = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            markerKVPairs[pos] = entry.getKey();
            markerKVPairs[pos + 1] = entry.getValue();
            pos += 2;
        }
        return markerKVPairs;
    }

    private static List<String> extractIndexesMod2(String[] array, int mod2) {
        return IntStream.range(0, array.length).filter(i -> i % 2 == mod2).mapToObj(i -> array[i]).collect(Collectors.toList());
    }

    private static String[] mergeKVPairs(List<String> keys, String[] values) {
        int resultLen = values.length * 2;
        String[] result = new String[resultLen];
        for (int i = 0; i < resultLen; i += 2) {
            result[i] = keys.get(i / 2);
            result[i + 1] = values[i / 2];
        }
        return result;
    }

    public LabelCfg getLabel() {
        return this.label;
    }

    public void setLabel(LabelCfg label) {
        this.label = label;
    }

    @DefaultClass(value=PatternLayout.class)
    public void setMessage(Layout<ILoggingEvent> message) {
        this.messageLayout = message;
    }

    @Override
    public boolean getStaticLabels() {
        return this.staticLabels;
    }

    public void setStaticLabels(boolean staticLabels) {
        this.staticLabels = staticLabels;
    }

    public static final class LabelCfg {
        String pattern;
        String structuredMetadataPattern;
        String pairSeparator = ",";
        String keyValueSeparator = "=";
        boolean readMarkers = false;
        Cache<String, LogRecordStream> streamCache;

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setStructuredMetadataPattern(String structuredMetadataPattern) {
            this.structuredMetadataPattern = structuredMetadataPattern;
        }

        public void setKeyValueSeparator(String keyValueSeparator) {
            this.keyValueSeparator = keyValueSeparator;
        }

        public void setPairSeparator(String pairSeparator) {
            this.pairSeparator = pairSeparator;
        }

        public void setReadMarkers(boolean readMarkers) {
            this.readMarkers = readMarkers;
        }

        @DefaultClass(value=Cache.BoundAtomicMapCache.class)
        public void setStreamCache(Cache<String, LogRecordStream> streamCache) {
            this.streamCache = streamCache;
        }
    }
}

