/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;

public class LoggerMetrics {
    private Timer appendTimer;
    private Timer encodeTimer;
    private Timer sendTimer;
    private DistributionSummary eventsEncodedSummary;
    private DistributionSummary bytesSentSummary;
    private Counter batchesEncodedCounter;
    private Counter batchesSentCounter;
    private Counter sendErrorsCounter;
    private Counter droppedEventsCounter;

    public LoggerMetrics(String appenderName, String host) {
        List<Tag> tags = Arrays.asList(Tag.of((String)"appender", (String)appenderName), Tag.of((String)"host", (String)host));
        this.appendTimer = Timer.builder((String)"loki4j.append.time").description("Time for a single event append operation").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.encodeTimer = Timer.builder((String)"loki4j.encode.time").description("Time for a batch encode operation").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.sendTimer = Timer.builder((String)"loki4j.send.time").description("Time for a HTTP send operation").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.eventsEncodedSummary = DistributionSummary.builder((String)"loki4j.encode.events").description("Number of log events processed by encoder").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.bytesSentSummary = DistributionSummary.builder((String)"loki4j.send.bytes").description("Size of batches sent to Loki").baseUnit("bytes").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.batchesEncodedCounter = Counter.builder((String)"loki4j.encode.batches").description("Number of batches processed by encoder").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.batchesSentCounter = Counter.builder((String)"loki4j.send.batches").description("Number of batches sent to Loki").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.sendErrorsCounter = Counter.builder((String)"loki4j.send.errors").description("Number of errors occurred while sending batches to Loki").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
        this.droppedEventsCounter = Counter.builder((String)"loki4j.drop.events").description("Number of events dropped due to backpressure settings").tags(tags).register((MeterRegistry)Metrics.globalRegistry);
    }

    private void recordTimer(Timer timer, long startedNs) {
        timer.record(Duration.ofNanos(System.nanoTime() - startedNs));
    }

    public void eventAppended(long startedNs, boolean dropped) {
        this.recordTimer(this.appendTimer, startedNs);
        if (dropped) {
            this.droppedEventsCounter.increment();
        }
    }

    public void batchEncoded(long startedNs, int count) {
        this.recordTimer(this.encodeTimer, startedNs);
        this.eventsEncodedSummary.record((double)count);
        this.batchesEncodedCounter.increment();
    }

    public void batchSent(long startedNs, int bytesCount, boolean failed) {
        this.recordTimer(this.sendTimer, startedNs);
        this.bytesSentSummary.record((double)bytesCount);
        this.batchesSentCounter.increment();
        if (failed) {
            this.sendErrorsCounter.increment();
        }
    }
}

