/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.common;

import com.github.loki4j.common.StringUtils;
import java.util.Arrays;

public class LogRecordStream {
    public final long id;
    public final String[] labels;
    public final int utf8SizeBytes;

    private LogRecordStream(long id, String[] labels) {
        this.id = id;
        this.labels = labels;
        int sizeBytes = 0;
        for (int i = 0; i < labels.length; ++i) {
            sizeBytes += StringUtils.utf8Length(labels[i]);
        }
        this.utf8SizeBytes = sizeBytes;
    }

    public static LogRecordStream create(long id, String ... labels) {
        return new LogRecordStream(id, labels);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogRecordStream other = (LogRecordStream)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "Stream [id=" + this.id + ", labels=" + Arrays.toString(this.labels) + "]";
    }
}

