/*
 * Decompiled with CFR 0.152.
 */
package com.lksnext.sqlite.impl;

import com.davidehrmann.vcdiff.VCDiffEncoderBuilder;
import com.lksnext.sqlite.SQLiteDBPersistManager;
import com.lksnext.sqlite.config.SQLitePropertyConfig;
import com.lksnext.sqlite.file.FileManager;
import com.lksnext.sqlite.impl.util.SQLitePathUtils;
import com.lksnext.sqlite.metadata.SQLiteDBFileInfo;
import com.lksnext.sqlite.metadata.SQLiteDBMetadata;
import com.lksnext.sqlite.metadata.SQLiteDBMetadataManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SQLiteDBPersistManagerImpl
implements SQLiteDBPersistManager {
    private static final Logger LOG = LoggerFactory.getLogger(SQLiteDBPersistManagerImpl.class);
    @Autowired
    private FileManager fileManager;
    @Autowired
    private SQLitePropertyConfig sqliteConfig;
    @Autowired
    private SQLiteDBMetadataManager sqliteDBMetadataManager;

    public void persist(String owner, String database) throws URISyntaxException, IOException {
        this.persist(owner, database, true);
    }

    public void persist(String owner, String database, boolean createDiffPatches) throws URISyntaxException, IOException {
        String newMD5 = this.calculateMD5(this.sqliteConfig.getTemporalPath(), database);
        SQLiteDBMetadata metadata = this.sqliteDBMetadataManager.loadMetadata(database);
        SQLiteDBFileInfo current = metadata.getCurrent();
        if (current == null || !current.getMd5().equals(newMD5)) {
            LOG.info("New database generated {} {} {}", new Object[]{owner, database, newMD5});
            URI srcURI = SQLitePathUtils.getTemporalDBPath(this.sqliteConfig.getTemporalPath(), database);
            URI destURI = SQLitePathUtils.getMasterdataDBPath(this.sqliteConfig.getDatabasePath(), database, newMD5);
            long fileWriteTime = System.currentTimeMillis();
            this.fileManager.moveFile(srcURI, destURI);
            fileWriteTime = System.currentTimeMillis() - fileWriteTime;
            LOG.info("Database {} file written in {} ms", (Object)database, (Object)fileWriteTime);
            List dbsToDelete = this.sqliteDBMetadataManager.addDBtoMetadata(metadata, owner, database, Paths.get(destURI).toString(), newMD5);
            if (!this.sqliteConfig.isSymLinkDisabled()) {
                this.updateOrCreateSymLinkToLatest(metadata, this.sqliteConfig.getDatabasePath(), database);
            }
            if (dbsToDelete != null) {
                for (SQLiteDBFileInfo db : dbsToDelete) {
                    this.fileManager.removeFile(Paths.get(db.getFile(), new String[0]).toUri());
                }
            }
            this.sqliteDBMetadataManager.saveMetadata(metadata, database);
            this.deletePatches(database);
            if (createDiffPatches) {
                this.createPatches(metadata, database);
            }
        }
        this.purgeOrphanedDatabaseFiles(metadata, database);
    }

    public void fixSymbolicLinks(String database) throws IOException {
        SQLiteDBMetadata metadata = null;
        try {
            metadata = this.sqliteDBMetadataManager.loadMetadata(database);
        }
        catch (URISyntaxException e) {
            LOG.error("Error loading metadata", (Throwable)e);
            return;
        }
        catch (IOException e) {
            LOG.error("Error loading metadata", (Throwable)e);
            return;
        }
        Path currentPath = Paths.get(metadata.getCurrent().getFile(), new String[0]);
        Path latestLink = Paths.get(SQLitePathUtils.getMasterdataLatestDBPath(this.sqliteConfig.getDatabasePath(), database));
        if (!Files.exists(latestLink, LinkOption.NOFOLLOW_LINKS)) {
            Files.createSymbolicLink(latestLink, currentPath, new FileAttribute[0]);
            LOG.info("Latest link for {} does not exists. fixed", (Object)database);
            return;
        }
        Path latestFile = Files.readSymbolicLink(latestLink);
        if (Files.exists(latestFile, new LinkOption[0]) && Files.isSameFile(currentPath, latestFile)) {
            LOG.info("Latest link for {} is correct", (Object)database);
        } else {
            if (!Files.isSymbolicLink(latestLink)) {
                LOG.warn("latest.db for {} is not a symbolic link ", (Object)database);
            }
            this.fileManager.removeFile(latestLink.toUri());
            Files.createSymbolicLink(latestLink, currentPath, new FileAttribute[0]);
            LOG.warn("Latest link for {} fixed", (Object)database);
        }
    }

    private void purgeOrphanedDatabaseFiles(SQLiteDBMetadata metadata, String database) throws IOException {
        URI folderURI = SQLitePathUtils.getMasterdataDBFolderPath(this.sqliteConfig.getDatabasePath(), database);
        Path basePath = Paths.get(folderURI);
        List filenames = this.fileManager.getFolderFilenames(folderURI);
        for (String filename : filenames) {
            if (!"db".equals(FilenameUtils.getExtension((String)filename))) continue;
            Path db = Paths.get(basePath.toString(), filename);
            SQLiteDBFileInfo info = metadata.getPrevious().stream().filter(m -> this.isSameFile((SQLiteDBFileInfo)m, db)).findFirst().orElse(null);
            if (info != null || this.isSameFile(metadata.getCurrent(), db)) continue;
            this.fileManager.removeFile(db.toUri());
        }
    }

    private boolean isSameFile(SQLiteDBFileInfo info, Path db) {
        try {
            return Files.isSameFile(Paths.get(info.getFile(), new String[0]), db);
        }
        catch (IOException e) {
            return false;
        }
    }

    private String calculateMD5(URI tempDir, String database) throws URISyntaxException, IOException {
        URI dbPath = SQLitePathUtils.getTemporalDBPath(tempDir, database);
        String md5 = "";
        try (FileInputStream fis = new FileInputStream(new File(dbPath));){
            md5 = DigestUtils.md5Hex((InputStream)fis);
        }
        return md5;
    }

    private void updateOrCreateSymLinkToLatest(SQLiteDBMetadata sqliteDBMetadata, URI targetDir, String database) {
        try {
            this.fileManager.removeFile(SQLitePathUtils.getMasterdataLatestDBPath(targetDir, database));
            Files.createSymbolicLink(Paths.get(SQLitePathUtils.getMasterdataLatestDBPath(targetDir, database)), Paths.get(sqliteDBMetadata.getCurrent().getFile(), new String[0]), new FileAttribute[0]);
        }
        catch (Exception x) {
            LOG.error("Error deleting or updating last db sym link.", (Throwable)x);
        }
    }

    private void deletePatches(String database) {
        LOG.info("Deleting all patches for database {}", (Object)database);
        long deletePatchesTime = System.currentTimeMillis();
        try {
            File folder = new File(SQLitePathUtils.getMasterdataDBFolderPath(this.sqliteConfig.getDatabasePath(), database));
            File[] fList = folder.listFiles();
            long patchTime = 0L;
            for (int i = 0; i < fList.length; ++i) {
                File pes = fList[i];
                if (!pes.getName().endsWith(".patch")) continue;
                patchTime = System.currentTimeMillis();
                pes.delete();
                patchTime = System.currentTimeMillis() - patchTime;
                LOG.info("Patch {} deleted for database {} in {} ms", new Object[]{pes.getName(), database, patchTime});
            }
        }
        catch (Exception e) {
            LOG.error("Error deleting patches for center {}", (Object)database, (Object)e);
        }
        deletePatchesTime = System.currentTimeMillis() - deletePatchesTime;
        LOG.info("All patches deleted for database {} in {} ms", (Object)database, (Object)deletePatchesTime);
    }

    private void createPatches(SQLiteDBMetadata sqliteDBMetadata, String database) {
        for (int patchCount = 0; patchCount < this.sqliteConfig.getMaxPatchNumber() && patchCount < sqliteDBMetadata.getPrevious().size(); ++patchCount) {
            File prev = new File(((SQLiteDBFileInfo)sqliteDBMetadata.getPrevious().get(patchCount)).getFile());
            File current = new File(sqliteDBMetadata.getCurrent().getFile());
            try {
                long patchCreationTime = System.currentTimeMillis();
                this.createPatch(prev, current, ((SQLiteDBFileInfo)sqliteDBMetadata.getPrevious().get(patchCount)).getMd5(), database);
                patchCreationTime = System.currentTimeMillis() - patchCreationTime;
                LOG.info("Patch {} for database {} created in {} ms", new Object[]{((SQLiteDBFileInfo)sqliteDBMetadata.getPrevious().get(patchCount)).getMd5(), database, patchCreationTime});
                continue;
            }
            catch (Exception e) {
                LOG.error("Error generating patch {} for center {}", new Object[]{patchCount, database, e});
            }
        }
    }

    public void createPatchForMD5(SQLiteDBMetadata sqliteDBMetadata, String database, String md5) {
        if (md5 == null) {
            return;
        }
        List prev = sqliteDBMetadata.getPrevious();
        SQLiteDBFileInfo fileInfo = prev.stream().filter(info -> md5.equals(info.getMd5())).findFirst().orElse(null);
        if (fileInfo != null) {
            File previous = new File(fileInfo.getFile());
            File current = new File(sqliteDBMetadata.getCurrent().getFile());
            try {
                this.createPatch(previous, current, fileInfo.getMd5(), database);
            }
            catch (Exception e) {
                LOG.error("Error generating patch {} for center {}", new Object[]{md5, database, e});
            }
        }
    }

    public boolean existsDBForMD5(SQLiteDBMetadata sqliteDBMetadata, String database, String md5) {
        if (md5 == null) {
            return false;
        }
        List prev = sqliteDBMetadata.getPrevious();
        SQLiteDBFileInfo fileInfo = prev.stream().filter(info -> md5.equals(info.getMd5())).findFirst().orElse(null);
        return fileInfo != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPatch(File previous, File current, String md5, String database) throws Exception {
        FileOutputStream out = null;
        OutputStream vcDiffOut = null;
        try (FileInputStream is = new FileInputStream(previous);
             FileInputStream isTarget = new FileInputStream(current);){
            byte[] dictionary = IOUtils.toByteArray((InputStream)is);
            File outFile = new File(SQLitePathUtils.getMasterdataPatchPath(this.sqliteConfig.getDatabasePath(), database, md5));
            outFile.createNewFile();
            out = new FileOutputStream(outFile);
            vcDiffOut = VCDiffEncoderBuilder.builder().withDictionary(dictionary).buildOutputStream((OutputStream)out);
            IOUtils.copyLarge((InputStream)isTarget, (OutputStream)vcDiffOut, (byte[])new byte[32768]);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (vcDiffOut != null) {
                try {
                    vcDiffOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

