/*
 * Decompiled with CFR 0.152.
 */
package com.lksnext.sqlite.impl.file;

import com.lksnext.sqlite.file.FileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class FileManagerImpl
implements FileManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileManagerImpl.class);

    public byte[] getFileContent(String filePath) throws IOException, URISyntaxException {
        URI uri = new URI(filePath);
        return this.getFileContent(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFileContent(URI uri) throws IOException {
        byte[] content;
        block5: {
            LOG.debug("Reading file from uri {}", (Object)uri.getPath());
            content = null;
            try (AbstractInterruptibleChannel fileChannel = null;){
                Path path = Paths.get(uri);
                if (Files.exists(path, new LinkOption[0])) {
                    fileChannel = FileChannel.open(path, StandardOpenOption.READ);
                    ((FileChannel)fileChannel).lock(0L, Long.MAX_VALUE, true);
                    content = Files.readAllBytes(path);
                    break block5;
                }
                byte[] byArray = null;
                return byArray;
            }
        }
        return content;
    }

    public void moveFile(URI source, URI target) throws IOException {
        Files.createDirectories(Paths.get(target).getParent(), new FileAttribute[0]);
        Files.move(Paths.get(source), Paths.get(target), StandardCopyOption.REPLACE_EXISTING);
    }

    public void copyFile(URI source, URI target) throws IOException {
        Files.copy(Paths.get(source), Paths.get(target), StandardCopyOption.REPLACE_EXISTING);
    }

    public void saveFile(byte[] content, String filePath) throws IOException, URISyntaxException {
        URI uri = new URI(filePath);
        this.saveFile(content, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(byte[] content, URI uri) throws IOException {
        LOG.debug("Saving file into uri {}", (Object)uri.getPath());
        try (AbstractInterruptibleChannel fileChannel = null;){
            Path path = Paths.get(uri);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            StandardOpenOption rewriteOption = Files.exists(path, new LinkOption[0]) ? StandardOpenOption.TRUNCATE_EXISTING : StandardOpenOption.CREATE;
            fileChannel = FileChannel.open(path, StandardOpenOption.WRITE, rewriteOption);
            FileLock lock = ((FileChannel)fileChannel).lock();
            ByteBuffer buffer = ByteBuffer.wrap(content);
            ((FileChannel)fileChannel).write(buffer);
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(URI uri) throws IOException {
        LOG.debug("Removing file from uri {}", (Object)uri.getPath());
        try (AbstractInterruptibleChannel fileChannel = null;){
            Path path = Paths.get(uri);
            if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                if (Files.isSymbolicLink(path)) {
                    Files.delete(path);
                } else {
                    fileChannel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE);
                    ((FileChannel)fileChannel).lock();
                    fileChannel.close();
                    Files.deleteIfExists(path);
                }
            }
        }
    }

    public void removeFolder(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("The path should be a folder " + path.toAbsolutePath().toString());
        }
        if (path.normalize().getNameCount() <= 2) {
            throw new IllegalArgumentException("Protection: The directory to be deleted should have at least 3 steps");
        }
        LOG.info("Removing foder {}", (Object)path);
        FileUtils.forceDelete((File)path.toFile());
    }

    public void removeFolder(URI uri) throws IOException {
        Path path = Paths.get(uri);
        this.removeFolder(path);
    }

    public Boolean fileExists(String filePath) throws URISyntaxException {
        URI uri = new URI(filePath);
        Boolean fileExists = Boolean.FALSE;
        Path path = Paths.get(uri);
        fileExists = Files.exists(path, new LinkOption[0]);
        return fileExists;
    }

    public List<String> getFolderFolderNames(URI folderURI) throws IOException {
        List<String> filenames = new ArrayList<String>();
        Path path = Paths.get(folderURI);
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> subpaths = Files.list(path);){
                filenames = subpaths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p -> p.getFileName().toString()).collect(Collectors.toList());
            }
        }
        return filenames;
    }

    public List<String> getFolderFilenames(URI folderURI) throws IOException {
        List<String> filenames = new ArrayList<String>();
        Path path = Paths.get(folderURI);
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> subpaths = Files.list(path);){
                filenames = subpaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(p -> p.getFileName().toString()).collect(Collectors.toList());
            }
        }
        return filenames;
    }

    public void computeMD5forFile(URI sourceFile, URI md5File) throws IOException {
        Path filePath = Paths.get(sourceFile);
        Path md5Path = Paths.get(md5File);
        LOG.debug("Computing MD5 for file {} into {}", (Object)filePath, (Object)md5Path);
        try (FileInputStream fis = new FileInputStream(filePath.toFile());){
            String md5 = DigestUtils.md5DigestAsHex((InputStream)fis);
            try (FileWriter fw = new FileWriter(md5Path.toFile());){
                fw.write(md5);
            }
        }
    }

    public void computeMD5forFolder(URI sourceFolder, URI targetFolder) throws IOException {
        List<String> filenames = this.getFolderFilenames(sourceFolder);
        Path source = Paths.get(sourceFolder);
        Path target = Paths.get(targetFolder);
        for (String filename : filenames) {
            if ("md5".equals(FilenameUtils.getExtension((String)filename))) continue;
            LOG.debug("Computing MD5 for file {}", (Object)filename);
            String md5Filename = FilenameUtils.getBaseName((String)filename) + "-" + FilenameUtils.getExtension((String)filename) + ".md5";
            Path file = Paths.get(source.toString(), filename);
            Path md5File = Paths.get(target.toString(), md5Filename);
            this.computeMD5forFile(file.toUri(), md5File.toUri());
        }
    }

    public void createFolder(String destFolder) throws URISyntaxException {
        Path destPath = Paths.get(new URI(destFolder));
        destPath.getParent().toFile().mkdirs();
    }

    public void touch(URI file) throws IOException {
        FileUtils.touch((File)Paths.get(file).toFile());
    }
}

