/*
 * Decompiled with CFR 0.152.
 */
package com.lin.value;

import com.lin.random.RandomData;
import com.lin.random.base.BaseRandomCreator;
import com.lin.utils.RandomUtils;
import java.util.List;

public final class Values {
    public static <T> RandomData<T> of(final T ... data) {
        return new BaseRandomCreator<T>(){

            @Override
            public T[] createOptionsArray() {
                return data;
            }
        };
    }

    public static <T> RandomData<T> ofList(final List<T> dataList) {
        return new RandomData<T>(){

            @Override
            public T next() {
                return RandomUtils.selectOneInList(dataList);
            }
        };
    }

    public static RandomData<Integer> ofIntRange(final int start, final int end) {
        return new RandomData<Integer>(){

            @Override
            public Integer next() {
                return RandomUtils.nextIntRange(start, end);
            }
        };
    }

    public static RandomData<Long> ofLongRange(final long start, final long end) {
        return new RandomData<Long>(){

            @Override
            public Long next() {
                return RandomUtils.nextLongRange(start, end);
            }
        };
    }

    public static RandomData<Float> ofFloatRange(final float start, final float end) {
        return new RandomData<Float>(){

            @Override
            public Float next() {
                return Float.valueOf(RandomUtils.nextFloatRange(start, end));
            }
        };
    }

    public static RandomData<Float> ofFloatRange(final float start, final float end, final int precision) {
        return new RandomData<Float>(){

            @Override
            public Float next() {
                return Float.valueOf(RandomUtils.nextFloatRange(start, end, precision));
            }
        };
    }

    public static RandomData<Double> ofDoubleRange(final double start, final double end) {
        return new RandomData<Double>(){

            @Override
            public Double next() {
                return RandomUtils.nextDoubleRange(start, end);
            }
        };
    }

    public static RandomData<Double> ofDoubleRange(final double start, final double end, final int precision) {
        return new RandomData<Double>(){

            @Override
            public Double next() {
                return RandomUtils.nextDoubleRange(start, end, precision);
            }
        };
    }

    public static RandomData<String> ofTimeRange(final long startTime, final long endTime) {
        return new RandomData<String>(){

            @Override
            public String next() {
                return RandomUtils.nextTimeRange(startTime, endTime);
            }
        };
    }
}

