/*
 * Decompiled with CFR 0.152.
 */
package com.lin.helper;

import com.lin.logger.Logger;
import com.lin.logger.LoggerFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public final class DatabaseHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseHelper.class);
    private static final ThreadLocal<Connection> CONNECTION_HOLDER = new ThreadLocal();
    private static final QueryRunner QUERY_RUNNER = new QueryRunner();
    private static final BasicDataSource DATA_SOURCE = new BasicDataSource();

    public static BasicDataSource getDataSource() {
        return DATA_SOURCE;
    }

    public static Connection getConnection() {
        Connection conn = CONNECTION_HOLDER.get();
        if (conn == null) {
            try {
                conn = DATA_SOURCE.getConnection();
            }
            catch (SQLException e) {
                LOGGER.error("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
                throw new RuntimeException(e);
            }
            finally {
                CONNECTION_HOLDER.set(conn);
            }
        }
        return conn;
    }

    public static <T> List<T> queryEntityList(Class<T> entityClass, String sql, Object ... params) {
        List entityList;
        try {
            Connection conn = DatabaseHelper.getConnection();
            entityList = (List)QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new BeanListHandler(entityClass), params);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5b9e\u4f53\u5217\u8868\u5931\u8d25");
            throw new RuntimeException(e);
        }
        return entityList;
    }

    public static <T> T queryEntity(Class<T> entityClass, String sql, Object ... params) {
        Object entity;
        try {
            Connection conn = DatabaseHelper.getConnection();
            entity = QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new BeanHandler(entityClass), params);
        }
        catch (SQLException e) {
            LOGGER.error("\u67e5\u8be2\u5b9e\u4f53\u5931\u8d25");
            throw new RuntimeException(e);
        }
        return (T)entity;
    }

    public static List<Map<String, Object>> executeQuery(String sql, Object ... params) {
        List result;
        try {
            Connection conn = DatabaseHelper.getConnection();
            result = (List)QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new MapListHandler(), params);
        }
        catch (SQLException e) {
            LOGGER.error("\u6267\u884c\u67e5\u8be2\u5931\u8d25");
            throw new RuntimeException(e);
        }
        return result;
    }

    public static <T> T query(String sql, Object ... params) {
        Object obj;
        try {
            Connection conn = DatabaseHelper.getConnection();
            obj = QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new ScalarHandler(), params);
        }
        catch (SQLException e) {
            LOGGER.error("\u6267\u884c\u67e5\u8be2\u5931\u8d25");
            throw new RuntimeException(e);
        }
        return (T)obj;
    }

    public static <T> List<T> queryList(String sql, Object ... params) {
        List list;
        try {
            Connection conn = DatabaseHelper.getConnection();
            list = (List)QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new ColumnListHandler(), params);
        }
        catch (SQLException e) {
            LOGGER.error("\u6267\u884c\u67e5\u8be2\u5e76\u8fd4\u56de\u5217\u503c\u5931\u8d25");
            throw new RuntimeException(e);
        }
        return list;
    }

    public static <T> Set<T> querySet(String sql, Object ... params) {
        List<T> valueList = DatabaseHelper.queryList(sql, params);
        return new LinkedHashSet<T>(valueList);
    }

    public static int executeUpdate(String sql, Object ... params) {
        int rows = 0;
        try {
            Connection conn = DatabaseHelper.getConnection();
            rows = QUERY_RUNNER.update(conn, sql, params);
        }
        catch (SQLException e) {
            LOGGER.error("\u6267\u884c\u66f4\u65b0\u5931\u8d25");
            throw new RuntimeException(e);
        }
        return rows;
    }

    public static int executeInsertBatch(List<String> sqlList) {
        int effectCount = 0;
        int rowsCount = 0;
        int commitSize = 1000;
        try {
            Connection conn = DatabaseHelper.getConnection();
            conn.setAutoCommit(false);
            for (String sql : sqlList) {
                effectCount += QUERY_RUNNER.update(conn, sql);
                if (++rowsCount % 1000 != 0) continue;
                conn.commit();
            }
            if (rowsCount % 1000 != 0) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            LOGGER.error("\u6267\u884c\u66f4\u65b0\u5931\u8d25");
            throw new RuntimeException(e);
        }
        return effectCount;
    }

    public static <T> boolean insertEntity(Class<T> entityClass, Map<String, Object> fieldMap) {
        if (fieldMap == null || fieldMap.isEmpty()) {
            LOGGER.error("\u4e0d\u80fd\u63d2\u5165\u5b9e\u4f53\uff1afieldMap\u4e3a\u7a7a");
            return false;
        }
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (String fieldName : fieldMap.keySet()) {
            columns.append(fieldName).append(", ");
            values.append("?, ");
        }
        columns.replace(columns.lastIndexOf(", "), columns.length(), "");
        values.replace(values.lastIndexOf(", "), values.length(), "");
        String sql = String.format("INSERT INTO %s(%s) VALUES (%s)", DatabaseHelper.getTableName(entityClass), columns, values);
        Object[] params = fieldMap.values().toArray();
        DatabaseHelper.logSqlInfo(sql, params);
        return DatabaseHelper.executeUpdate(sql, params) == 1;
    }

    public static <T> boolean updateEntity(Class<T> entityClass, long id, Map<String, Object> fieldMap) {
        if (fieldMap == null || fieldMap.isEmpty()) {
            LOGGER.error("\u4e0d\u80fd\u63d2\u5165\u5b9e\u4f53\uff1afieldMap\u4e3a\u7a7a");
            return false;
        }
        StringBuilder columns = new StringBuilder();
        for (String fieldName : fieldMap.keySet()) {
            columns.append(fieldName).append(" = ?, ");
        }
        String sql = String.format("UPDATE %s SET %s WHERE id = ?", DatabaseHelper.getTableName(entityClass), columns.substring(0, columns.lastIndexOf(", ")));
        ArrayList<Object> paramsList = new ArrayList<Object>(fieldMap.values());
        paramsList.add(id);
        Object[] params = paramsList.toArray();
        DatabaseHelper.logSqlInfo(sql, params);
        return DatabaseHelper.executeUpdate(sql, params) == 1;
    }

    public static <T> boolean deleteEntity(Class<T> entityClass, long id) {
        String sql = String.format("DELETE FROM %s WHERE id = ?", DatabaseHelper.getTableName(entityClass));
        DatabaseHelper.logSqlInfo(sql, id);
        return DatabaseHelper.executeUpdate(sql, id) == 1;
    }

    private static void logSqlInfo(String sql, Object ... values) {
        for (Object value : values) {
            String result = String.valueOf(value);
            if (value instanceof String) {
                result = String.format("'%s'", result);
            }
            sql = sql.replaceFirst("\\?", result);
        }
        LOGGER.info("\u5f53\u524d\u6267\u884c\u7684SQL\u4e3a\uff1a" + sql);
    }

    private static <T> String getTableName(Class<T> entityClass) {
        return entityClass.getSimpleName();
    }

    public static void executeSqlFile(String filePath) {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader reader = null;
        try {
            String sql;
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            isr = new InputStreamReader(is);
            reader = new BufferedReader(isr);
            while ((sql = reader.readLine()) != null) {
                if (sql.isEmpty()) continue;
                DatabaseHelper.executeUpdate(sql, new Object[0]);
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error("\u6267\u884cSQL\u6587\u4ef6\u5931\u8d25");
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseHelper.closeStream(reader);
                DatabaseHelper.closeStream(isr);
                DatabaseHelper.closeStream(is);
                throw throwable;
            }
        }
        DatabaseHelper.closeStream(reader);
        DatabaseHelper.closeStream(isr);
        DatabaseHelper.closeStream(is);
    }

    public static int executeSqlFile(File file) {
        FileInputStream is = null;
        InputStreamReader isr = null;
        BufferedReader reader = null;
        int effectCount = 0;
        int rowsCount = 0;
        int commitSize = 1000;
        try {
            String sql;
            is = new FileInputStream(file);
            isr = new InputStreamReader(is);
            reader = new BufferedReader(isr);
            Connection conn = DatabaseHelper.getConnection();
            conn.setAutoCommit(false);
            while ((sql = reader.readLine()) != null) {
                if (sql.isEmpty()) continue;
                effectCount += QUERY_RUNNER.update(conn, sql);
                if (++rowsCount % 1000 != 0) continue;
                conn.commit();
            }
            if (rowsCount % 1000 != 0) {
                conn.commit();
            }
        }
        catch (Exception e) {
            try {
                LOGGER.error("\u6267\u884cSQL\u6587\u4ef6\u5931\u8d25");
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseHelper.closeStream(reader);
                DatabaseHelper.closeStream(isr);
                DatabaseHelper.closeStream(is);
                throw throwable;
            }
        }
        DatabaseHelper.closeStream(reader);
        DatabaseHelper.closeStream(isr);
        DatabaseHelper.closeStream(is);
        return effectCount;
    }

    private static void closeStream(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void beginTransaction() {
        Connection conn = DatabaseHelper.getConnection();
        if (conn != null) {
            try {
                conn.setAutoCommit(false);
            }
            catch (SQLException e) {
                LOGGER.error("\u5f00\u542f\u4e8b\u52a1\u5931\u8d25");
                throw new RuntimeException(e);
            }
            finally {
                CONNECTION_HOLDER.set(conn);
            }
        }
    }

    public static void commitBatchTransaction() {
        Connection conn = DatabaseHelper.getConnection();
        if (conn != null) {
            try {
                conn.commit();
            }
            catch (SQLException e) {
                LOGGER.error("\u63d0\u4ea4\u4e8b\u52a1\u5931\u8d25");
                throw new RuntimeException(e);
            }
        }
    }

    public static void commitTransaction() {
        Connection conn = DatabaseHelper.getConnection();
        if (conn != null) {
            try {
                conn.commit();
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.error("\u63d0\u4ea4\u4e8b\u52a1\u5931\u8d25");
                throw new RuntimeException(e);
            }
            finally {
                CONNECTION_HOLDER.remove();
            }
        }
    }

    public static void rollbackTransaction() {
        Connection conn = DatabaseHelper.getConnection();
        if (conn != null) {
            try {
                LOGGER.info("\u8fdb\u884c\u4e8b\u52a1\u56de\u6eda");
                conn.rollback();
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.error("\u56de\u6eda\u4e8b\u52a1\u5931\u8d25");
                throw new RuntimeException(e);
            }
            finally {
                CONNECTION_HOLDER.remove();
            }
        }
    }
}

