/*
 * Decompiled with CFR 0.152.
 */
package com.lin.creator;

import com.lin.entity.FieldInfo;
import com.lin.entity.TableInfo;
import com.lin.entity.common.PathInfo;
import com.lin.helper.DatabaseHelper;
import com.lin.utils.DBTools;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseFakerCreator<TABLE extends TableInfo, FIELD extends FieldInfo> {
    private static Set<String> DB_STRING_TYPE_SET = new HashSet<String>();
    private static final List<String> DATA_TYPE_LIST = Arrays.asList("USERNAME", "PHONE", "TIME", "ADDRESS", "AGE", "SEX", "EMAIL");
    private static Map<String, String> DATABASE_INFER_MAP = new LinkedHashMap<String, String>();
    protected String dbName;
    private String url;
    private String username;
    private String password;
    private String driverClassName;
    private Class<TABLE> tableInfoClazz;
    private Class<FIELD> fieldInfoClazz;

    public BaseFakerCreator() {
        this.setDbStringTypeSet(DB_STRING_TYPE_SET);
        this.setDatabaseInferMap(DATABASE_INFER_MAP);
        this.tableInfoClazz = null;
        this.fieldInfoClazz = null;
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type tableClazz = pType.getActualTypeArguments()[0];
            Type fieldClazz = pType.getActualTypeArguments()[1];
            if (tableClazz instanceof Class) {
                this.tableInfoClazz = (Class)tableClazz;
            }
            if (fieldClazz instanceof Class) {
                this.fieldInfoClazz = (Class)fieldClazz;
            }
        }
    }

    protected BaseFakerCreator setUrl(String url) {
        this.url = url;
        this.dbName = url.substring(url.lastIndexOf("/") + 1);
        return this;
    }

    protected BaseFakerCreator setDbName(String dbName) {
        if (this.url == null) {
            this.url = this.getDefaultUrlPrefix() + dbName;
        }
        this.dbName = dbName;
        return this;
    }

    public BaseFakerCreator username(String username) {
        this.username = username;
        return this;
    }

    public BaseFakerCreator password(String password) {
        this.password = password;
        return this;
    }

    public BaseFakerCreator driverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        return this;
    }

    public void build() {
        this.username = this.username != null ? this.username : this.getDefaultUsername();
        this.password = this.password != null ? this.password : this.getDefaultPassword();
        this.driverClassName = this.driverClassName != null ? this.driverClassName : this.getDefaultDriverClassName();
        try {
            this.executeMainLogic();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executeMainLogic() throws Exception {
        PathInfo pathInfo = BaseFakerCreator.getPathInfo(BaseFakerCreator.getRuntimeClassName());
        this.validUrl();
        DBTools.url(this.url).username(this.username).password(this.password).driverClassName(this.driverClassName).connect();
        String queryTablesInfoSql = this.getQueryTablesInfoSql();
        List<TableInfo> tableInfoList = DatabaseHelper.queryEntityList(this.tableInfoClazz, queryTablesInfoSql, new Object[0]);
        StringBuilder fileContent = new StringBuilder();
        fileContent.append(String.format("package %s;", pathInfo.getPackageName())).append("\n\n");
        fileContent.append("import com.lin.datatype.DataType;").append("\n");
        fileContent.append("import com.lin.faker.Faker;").append("\n");
        fileContent.append("import com.lin.utils.DBTools;").append("\n");
        fileContent.append("import com.lin.value.Times;").append("\n");
        fileContent.append("import com.lin.value.Values;").append("\n\n");
        fileContent.append("/**").append("\n");
        fileContent.append("* Faker\u751f\u6210\u7684\u8868\u7ed3\u6784").append("\n");
        fileContent.append("*/").append("\n");
        fileContent.append("public class CreateFakerTable {").append("\n\n");
        fileContent.append("\t").append("public static void main(String[] args) {").append("\n");
        fileContent.append("\t\t").append("// \u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5\n");
        fileContent.append("\t\t").append(String.format("DBTools.url(\"%s\")", this.url)).append("\n");
        fileContent.append("\t\t\t\t").append(String.format(".driverClassName(\"%s\")", this.driverClassName)).append("\n");
        fileContent.append("\t\t\t\t").append(String.format(".username(\"%s\")", this.username)).append("\n");
        fileContent.append("\t\t\t\t").append(String.format(".password(\"%s\")", this.password)).append("\n");
        fileContent.append("\t\t\t\t").append(".connect();").append("\n\n");
        for (TableInfo tableInfo : tableInfoList) {
            String tableName = tableInfo.getTableName();
            String queryFieldsInfoSql = this.getQueryFieldsInfoSql(tableName);
            List<FIELD> fieldInfoList = DatabaseHelper.queryEntityList(this.fieldInfoClazz, queryFieldsInfoSql, new Object[0]);
            String fakerTable = BaseFakerCreator.createFakerTable(tableName, fieldInfoList);
            System.out.println(fakerTable);
            String tableComment = tableInfo.getTableComment();
            if (tableComment != null && !"".equals(tableComment)) {
                fileContent.append("\t\t").append(String.format("// %s", tableComment)).append("\n");
            }
            fileContent.append(fakerTable).append("\n");
        }
        fileContent.append("\t").append("}").append("\n\n");
        fileContent.append("}").append("\n");
        String fileName = "CreateFakerTable.java";
        if (pathInfo.getCurrentFilePath() != null) {
            fileName = pathInfo.getCurrentFilePath() + fileName;
        }
        System.out.println(String.format("\u5171\u751f\u6210 [ %s ] \u4e2a\u8868\u7ed3\u6784", tableInfoList.size()));
        System.out.println("\u751f\u6210Faker\u8868\u7ed3\u6784\u4f4d\u7f6e\uff0c\u4f4d\u4e8e\u5f53\u524d\u9879\u76ee\uff1a" + fileName);
        BaseFakerCreator.writeContentToFile(fileContent, fileName);
    }

    protected abstract String getQueryTablesInfoSql();

    protected abstract String getQueryFieldsInfoSql(String var1);

    private void validUrl() {
        if (this.url == null || this.url.isEmpty()) {
            throw new RuntimeException("\u6570\u636e\u5e93url\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static void writeContentToFile(StringBuilder fileContent, String fileName) throws IOException {
        FileWriter writer = new FileWriter(fileName);
        writer.write(fileContent.toString());
        writer.flush();
        writer.close();
    }

    private static PathInfo getPathInfo(String className) throws ClassNotFoundException, IOException {
        File pathFile;
        String packageNamePath;
        Class<?> clazz = Class.forName(className);
        String packageName = clazz.getPackage().getName();
        File file = new File("");
        String currentFilePath = file.getCanonicalPath();
        if (!currentFilePath.contains(packageNamePath = packageName.replace(".", "\\"))) {
            currentFilePath = currentFilePath + "\\src\\main\\java\\" + packageNamePath + "\\";
        }
        if (!(pathFile = new File(currentFilePath)).exists()) {
            currentFilePath = null;
        }
        return new PathInfo(packageName, currentFilePath);
    }

    private static String getRuntimeClassName() {
        return Thread.currentThread().getStackTrace()[2].getClassName();
    }

    private static <FIELD extends FieldInfo> String createFakerTable(String tableName, List<FIELD> fieldInfoList) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\t\tFaker.tableName(\"%s\")\n", tableName));
        for (FieldInfo fieldInfo : fieldInfoList) {
            sb.append(String.format("\t\t\t\t.param(\"%s\", %s)%s\n", fieldInfo.getFieldName(), BaseFakerCreator.fieldToInferType(fieldInfo), BaseFakerCreator.addCommon(fieldInfo)));
        }
        sb.append("\t\t\t\t.insertCount(5)\n");
        sb.append("\t\t\t\t.onlyShowSql();\n");
        return sb.toString();
    }

    private static String addCommon(FieldInfo fieldInfo) {
        String comment = fieldInfo.getComments();
        return comment != null && !"".equals(comment) ? String.format(" // %s", comment) : "";
    }

    private static String fieldToInferType(FieldInfo fieldInfo) {
        String fieldName = fieldInfo.getFieldName().toUpperCase();
        String fieldType = BaseFakerCreator.removeBrackets(fieldInfo.getDataType().toUpperCase());
        if (fieldName.contains("ID") && BaseFakerCreator.isStringType(fieldType)) {
            return "DataType.ID";
        }
        if (BaseFakerCreator.checkFieldNameValidToInfer(fieldName, fieldType)) {
            return BaseFakerCreator.getRightDataType(fieldName);
        }
        return BaseFakerCreator.dbTypeToDataType(fieldType);
    }

    private static String dbTypeToDataType(String fieldType) {
        String tempType = DATABASE_INFER_MAP.get(fieldType);
        if (tempType == null) {
            throw new RuntimeException(String.format("\u65e0\u6cd5\u8f6c\u6362 \u3010%s\u3011 \u7c7b\u578b\u7684\u6570\u636e", fieldType));
        }
        switch (tempType) {
            case "INT": {
                return "Values.ofIntRange(1, 18)";
            }
            case "FLOAT": {
                return "Values.ofDoubleRange(1.0, 18.0)";
            }
            case "TIME": {
                return "Values.ofTimeRange(Times.of(2019, 1, 1), Times.of(2019, 5, 1))";
            }
            case "TEXT": {
                return "Values.of(\"example1\", \"example2\", \"example3\")";
            }
        }
        throw new RuntimeException("\u751f\u6210\u7684DataType\u7c7b\u578b\u9519\u8bef");
    }

    private static String getRightDataType(String fieldName) {
        for (String dataTypeName : DATA_TYPE_LIST) {
            if (!fieldName.contains(dataTypeName)) continue;
            return String.format("DataType.%s", dataTypeName);
        }
        throw new RuntimeException("\u672a\u627e\u5230\u5408\u9002\u7684DataType\u6620\u5c04\u7c7b\u578b");
    }

    private static boolean checkFieldNameValidToInfer(String fieldName, String fieldType) {
        return DATA_TYPE_LIST.contains(fieldName) && BaseFakerCreator.isStringType(fieldType);
    }

    private static boolean isStringType(String fieldType) {
        return DB_STRING_TYPE_SET.contains(fieldType.toUpperCase());
    }

    private static String removeBrackets(String fieldType) {
        if (fieldType.contains("(")) {
            int index = fieldType.indexOf("(");
            return fieldType.substring(0, index);
        }
        return fieldType;
    }

    protected abstract String getDefaultUsername();

    protected abstract String getDefaultPassword();

    protected abstract String getDefaultDriverClassName();

    protected abstract String getDefaultUrlPrefix();

    protected abstract void setDbStringTypeSet(Collection<String> var1);

    protected abstract void setDatabaseInferMap(Map<String, String> var1);
}

