/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ChatWindowConfiguration
implements Serializable {
    public static final String KEY_CHAT_WINDOW_CONFIG = "config";
    private static final String DEFAULT_GROUP_ID = "0";
    private static final String TAG = ChatWindowConfiguration.class.getSimpleName();
    public final String licenceNumber;
    public final String groupId;
    public final String visitorName;
    public final String visitorEmail;
    public final HashMap<String, String> customParameters;

    public ChatWindowConfiguration(@NonNull String licenceNumber, @Nullable String groupId, @Nullable String visitorName, @Nullable String visitorEmail, @Nullable HashMap<String, String> customParameters) {
        this.licenceNumber = licenceNumber;
        this.groupId = groupId != null ? groupId : DEFAULT_GROUP_ID;
        this.visitorName = visitorName;
        this.visitorEmail = visitorEmail;
        this.customParameters = customParameters;
    }

    public static ChatWindowConfiguration fromBundle(Bundle extras) {
        ChatWindowConfiguration config = (ChatWindowConfiguration)extras.getSerializable(KEY_CHAT_WINDOW_CONFIG);
        if (config == null) {
            throw new IllegalStateException("Config must be provided");
        }
        return config;
    }

    public String addParamsToChatWindowUrl(String chatUrl) {
        try {
            String customParams;
            chatUrl = this.replaceParameter(chatUrl, "license", this.licenceNumber);
            chatUrl = this.replaceParameter(chatUrl, "group", this.groupId);
            chatUrl = chatUrl + "&native_platform=android";
            chatUrl = chatUrl + "&wrapper_version=" + this.encodeParam("2.4.6");
            if (this.visitorName != null) {
                chatUrl = chatUrl + "&name=" + this.encodeParam(this.visitorName).replace("+", "%20");
            }
            if (this.visitorEmail != null) {
                chatUrl = chatUrl + "&email=" + this.encodeParam(this.visitorEmail);
            }
            if (!TextUtils.isEmpty((CharSequence)(customParams = this.encodeParams(this.customParameters)))) {
                chatUrl = chatUrl + "&params=" + customParams;
            }
            if (!chatUrl.startsWith("http")) {
                chatUrl = "https://" + chatUrl;
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)("Error while encoding URL: " + e.getMessage()), (Throwable)e);
        }
        return chatUrl;
    }

    private String replaceParameter(String url, String key, String value) {
        return url.replace("{%" + key + "%}", value);
    }

    private String encodeParam(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8");
    }

    private String encodeParams(@Nullable Map<String, String> param) {
        if (param == null) {
            return "";
        }
        String params = "";
        for (String key : param.keySet()) {
            if (!TextUtils.isEmpty((CharSequence)params)) {
                params = params + "&";
            }
            params = params + key + "=" + param.get(key);
        }
        return Uri.encode((String)params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatWindowConfiguration that = (ChatWindowConfiguration)o;
        if (!this.licenceNumber.equals(that.licenceNumber)) {
            return false;
        }
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!Objects.equals(this.visitorName, that.visitorName)) {
            return false;
        }
        if (!Objects.equals(this.visitorEmail, that.visitorEmail)) {
            return false;
        }
        return Objects.equals(this.customParameters, that.customParameters);
    }

    public int hashCode() {
        int result = this.licenceNumber.hashCode();
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + (this.visitorName != null ? this.visitorName.hashCode() : 0);
        result = 31 * result + (this.visitorEmail != null ? this.visitorEmail.hashCode() : 0);
        result = 31 * result + (this.customParameters != null ? this.customParameters.hashCode() : 0);
        return result;
    }

    @NonNull
    public String toString() {
        return "licenceNumber='" + this.licenceNumber + "'\ngroupId='" + this.groupId + "'\nvisitorName='" + this.visitorName + "'\nvisitorEmail='" + this.visitorEmail + "'\ncustomParameters=" + this.customParameters;
    }

    public static class Builder {
        private String licenceNumber;
        private String groupId;
        private String visitorName;
        private String visitorEmail;
        private HashMap<String, String> customParameters;

        public ChatWindowConfiguration build() {
            if (TextUtils.isEmpty((CharSequence)this.licenceNumber)) {
                throw new IllegalStateException("Licence Number cannot be null");
            }
            return new ChatWindowConfiguration(this.licenceNumber, this.groupId, this.visitorName, this.visitorEmail, this.customParameters);
        }

        public Builder setLicenceNumber(String licenceNr) {
            this.licenceNumber = licenceNr;
            return this;
        }

        public Builder setGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder setVisitorName(String visitorName) {
            this.visitorName = visitorName;
            return this;
        }

        public Builder setVisitorEmail(String visitorEmail) {
            this.visitorEmail = visitorEmail;
            return this;
        }

        public Builder setCustomParameters(HashMap<String, String> customParameters) {
            this.customParameters = customParameters;
            return this;
        }
    }
}

