/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.annotation.TargetApi;
import android.net.Uri;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.livechatinc.inappchat.ChatWindowErrorType;
import com.livechatinc.inappchat.ChatWindowPresenter;

class LCWebViewClient
extends WebViewClient {
    final ChatWindowPresenter presenter;

    LCWebViewClient(ChatWindowPresenter presenter) {
        this.presenter = presenter;
    }

    public void onPageFinished(WebView webView, String url) {
        this.presenter.onPageLoaded();
        super.onPageFinished(webView, url);
    }

    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        if (request.isForMainFrame()) {
            this.presenter.onErrorDetected(ChatWindowErrorType.WebViewClient, errorResponse.getStatusCode(), errorResponse.getReasonPhrase());
        }
        super.onReceivedHttpError(view, request, errorResponse);
    }

    @TargetApi(value=23)
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        if (request.isForMainFrame()) {
            this.presenter.onErrorDetected(ChatWindowErrorType.WebViewClient, error.getErrorCode(), String.valueOf(error.getDescription()));
        }
        super.onReceivedError(view, request, error);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        this.presenter.onErrorDetected(ChatWindowErrorType.WebViewClient, errorCode, description);
        super.onReceivedError(view, errorCode, description, failingUrl);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        Uri uri = Uri.parse((String)url);
        return this.handleUri(view, uri);
    }

    @TargetApi(value=24)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        Uri uri = request.getUrl();
        return this.handleUri(view, uri);
    }

    private boolean handleUri(WebView webView, Uri uri) {
        return this.presenter.handleUri(uri, webView.getOriginalUrl());
    }
}

