/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.util.Log;
import android.webkit.JavascriptInterface;
import com.google.gson.GsonBuilder;
import com.livechatinc.inappchat.ChatWindowPresenter;
import com.livechatinc.inappchat.models.NewMessageModel;
import org.json.JSONException;
import org.json.JSONObject;

class ChatWindowJsInterface {
    private final ChatWindowPresenter presenter;
    public static final String BRIDGE_OBJECT_NAME = "androidMobileWidget";
    private static final String KEY_MESSAGE_TYPE = "messageType";
    private static final String TYPE_UI_READY = "uiReady";
    private static final String TYPE_HIDE_CHAT_WINDOW = "hideChatWindow";
    private static final String TYPE_NEW_MESSAGE = "newMessage";
    private static final String TAG = ChatWindowJsInterface.class.getSimpleName();

    public ChatWindowJsInterface(ChatWindowPresenter presenter) {
        this.presenter = presenter;
    }

    @JavascriptInterface
    public void postMessage(String messageJson) {
        Log.d((String)TAG, (String)("postMessage: " + messageJson));
        try {
            JSONObject jsonObject = new JSONObject(messageJson);
            if (jsonObject != null && jsonObject.has(KEY_MESSAGE_TYPE)) {
                this.dispatchMessage(jsonObject.getString(KEY_MESSAGE_TYPE), messageJson);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Error serializing js message: " + e.getMessage()), (Throwable)e);
        }
    }

    private void dispatchMessage(String messageType, String json) {
        switch (messageType) {
            case "hideChatWindow": {
                this.presenter.onHideChatWindow();
                break;
            }
            case "uiReady": {
                this.presenter.onUiReady();
                break;
            }
            case "newMessage": {
                this.presenter.onNewMessageReceived((NewMessageModel)new GsonBuilder().create().fromJson(json, NewMessageModel.class));
            }
        }
    }
}

