/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.annotation.TargetApi;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;

public class UriUtils {
    private UriUtils() {
    }

    public static String getFilePathFromUri(Context context, Uri uri) {
        if (UriUtils.isVersionKitKat() && UriUtils.isDocumentUri(context, uri)) {
            return UriUtils.getFilePathFromDocumentUriKitKat(context, uri);
        }
        if (UriUtils.isContentUri(uri)) {
            return UriUtils.getDataColumnForContentUri(context, uri, null, null);
        }
        return uri.getPath();
    }

    private static boolean isVersionKitKat() {
        return Build.VERSION.SDK_INT >= 19;
    }

    @TargetApi(value=19)
    private static boolean isDocumentUri(Context context, Uri uri) {
        return DocumentsContract.isDocumentUri((Context)context, (Uri)uri);
    }

    private static boolean isContentUri(Uri uri) {
        return "content".equalsIgnoreCase(uri.getScheme());
    }

    @TargetApi(value=19)
    private static String getFilePathFromDocumentUriKitKat(Context context, Uri uri) {
        if (UriUtils.isExternalStorageDocument(uri)) {
            return UriUtils.getFilePathForExternalStorageDocumentUri(uri);
        }
        if (UriUtils.isDownloadsDocument(uri)) {
            return UriUtils.getFilePathForDownloadsDocumentUri(context, uri);
        }
        if (UriUtils.isMediaDocument(uri)) {
            return UriUtils.getFilePathFromMediaDocumentUri(context, uri);
        }
        return uri.getPath();
    }

    @TargetApi(value=19)
    private static String getFilePathForExternalStorageDocumentUri(Uri uri) {
        String documentId = DocumentsContract.getDocumentId((Uri)uri);
        String[] split = documentId.split(":");
        String uriContentType = split[0];
        String uriId = split[1];
        if ("primary".equalsIgnoreCase(uriContentType)) {
            return Environment.getExternalStorageDirectory() + "/" + uriId;
        }
        return uri.getPath();
    }

    @TargetApi(value=19)
    private static String getFilePathForDownloadsDocumentUri(Context context, Uri uri) {
        String documentId = DocumentsContract.getDocumentId((Uri)uri);
        Uri downloadsContentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(documentId));
        return UriUtils.getDataColumnForContentUri(context, downloadsContentUri, null, null);
    }

    @TargetApi(value=19)
    private static String getFilePathFromMediaDocumentUri(Context context, Uri uri) {
        String documentId = DocumentsContract.getDocumentId((Uri)uri);
        String[] split = documentId.split(":");
        String uriContentType = split[0];
        String uriId = split[1];
        Uri contentUri = UriUtils.getUriForContentType(uriContentType);
        String selection = "_id=?";
        String[] selectionArgs = new String[]{uriId};
        return UriUtils.getDataColumnForContentUri(context, contentUri, selection, selectionArgs);
    }

    private static Uri getUriForContentType(String type) {
        switch (type) {
            case "image": {
                return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            }
            case "video": {
                return MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            }
            case "audio": {
                return MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumnForContentUri(Context context, Uri uri, String selection, String[] selectionArgs) {
        String column = "_data";
        String[] projection = new String[]{column};
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndexOrThrow(column);
                String string = cursor.getString(columnIndex);
                return string;
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }
}

