/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.chatsdk.src.utils;

import android.content.ActivityNotFoundException;
import android.net.Uri;
import android.webkit.ValueCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.livechatinc.chatsdk.LiveChat;
import com.livechatinc.chatsdk.src.domain.presenters.LiveChatViewPresenter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0018\u001a\u00020\u00132\u0014\u0010\u0019\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\rJ\u001c\u0010\u001a\u001a\u00020\u00132\u0014\u0010\u0019\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/livechatinc/chatsdk/src/utils/FileSharing;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "registry", "Landroidx/activity/result/ActivityResultRegistry;", "presenter", "Lcom/livechatinc/chatsdk/src/domain/presenters/LiveChatViewPresenter;", "<init>", "(Landroidx/activity/result/ActivityResultRegistry;Lcom/livechatinc/chatsdk/src/domain/presenters/LiveChatViewPresenter;)V", "getContent", "Landroidx/activity/result/ActivityResultLauncher;", "", "getMultipleContent", "filesUploadCallback", "Landroid/webkit/ValueCallback;", "", "Landroid/net/Uri;", "getFilesUploadCallback", "()Landroid/webkit/ValueCallback;", "onCreate", "", "owner", "Landroidx/lifecycle/LifecycleOwner;", "registerSingleContentContract", "registerMultipleContentContract", "selectFile", "filePathCallback", "selectFiles", "chat-sdk_release"})
@SourceDebugExtension(value={"SMAP\nFileSharing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSharing.kt\ncom/livechatinc/chatsdk/src/utils/FileSharing\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,74:1\n37#2,2:75\n*S KotlinDebug\n*F\n+ 1 FileSharing.kt\ncom/livechatinc/chatsdk/src/utils/FileSharing\n*L\n48#1:75,2\n*E\n"})
public final class FileSharing
implements DefaultLifecycleObserver {
    @NotNull
    private final ActivityResultRegistry registry;
    @NotNull
    private final LiveChatViewPresenter presenter;
    @Nullable
    private ActivityResultLauncher<String> getContent;
    @Nullable
    private ActivityResultLauncher<String> getMultipleContent;

    public FileSharing(@NotNull ActivityResultRegistry registry, @NotNull LiveChatViewPresenter presenter) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)presenter, (String)"presenter");
        this.registry = registry;
        this.presenter = presenter;
    }

    private final ValueCallback<Uri[]> getFilesUploadCallback() {
        return LiveChat.Companion.getInstance().getFilesUploadCallback$chat_sdk_release();
    }

    public void onCreate(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.registerSingleContentContract(owner);
        this.registerMultipleContentContract(owner);
    }

    private final void registerSingleContentContract(LifecycleOwner owner) {
        this.getContent = this.registry.register("liveChatFileResultRegistryKey", owner, (ActivityResultContract)new ActivityResultContracts.GetContent(), arg_0 -> FileSharing.registerSingleContentContract$lambda$0(this, arg_0));
    }

    private final void registerMultipleContentContract(LifecycleOwner owner) {
        this.getMultipleContent = this.registry.register("liveChatMultipleFilesResultRegistryKey", owner, (ActivityResultContract)new ActivityResultContracts.GetMultipleContents(), arg_0 -> FileSharing.registerMultipleContentContract$lambda$1(this, arg_0));
    }

    public final void selectFile(@Nullable ValueCallback<Uri[]> filePathCallback) {
        block2: {
            LiveChat.Companion.getInstance().setFileUploadCallback$chat_sdk_release(filePathCallback);
            try {
                ActivityResultLauncher<String> activityResultLauncher = this.getContent;
                Intrinsics.checkNotNull(activityResultLauncher);
                activityResultLauncher.launch((Object)"*/*");
            }
            catch (ActivityNotFoundException exception) {
                this.presenter.onFileChooserActivityNotFound$chat_sdk_release();
                ValueCallback<Uri[]> valueCallback = this.getFilesUploadCallback();
                if (valueCallback == null) break block2;
                valueCallback.onReceiveValue((Object)new Uri[0]);
            }
        }
    }

    public final void selectFiles(@Nullable ValueCallback<Uri[]> filePathCallback) {
        block2: {
            LiveChat.Companion.getInstance().setFileUploadCallback$chat_sdk_release(filePathCallback);
            try {
                ActivityResultLauncher<String> activityResultLauncher = this.getMultipleContent;
                Intrinsics.checkNotNull(activityResultLauncher);
                activityResultLauncher.launch((Object)"*/*");
            }
            catch (ActivityNotFoundException exception) {
                this.presenter.onFileChooserActivityNotFound$chat_sdk_release();
                ValueCallback<Uri[]> valueCallback = this.getFilesUploadCallback();
                if (valueCallback == null) break block2;
                valueCallback.onReceiveValue((Object)new Uri[0]);
            }
        }
    }

    private static final void registerSingleContentContract$lambda$0(FileSharing this$0, Uri file) {
        block2: {
            Uri[] uriArray;
            ValueCallback<Uri[]> valueCallback = this$0.getFilesUploadCallback();
            if (valueCallback == null) break block2;
            if (file != null) {
                Uri[] uriArray2 = new Uri[]{file};
                uriArray = uriArray2;
            } else {
                uriArray = new Uri[]{};
            }
            valueCallback.onReceiveValue((Object)uriArray);
        }
    }

    private static final void registerMultipleContentContract$lambda$1(FileSharing this$0, List value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ValueCallback<Uri[]> valueCallback = this$0.getFilesUploadCallback();
            if (valueCallback == null) break block0;
            Collection $this$toTypedArray$iv = value;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            valueCallback.onReceiveValue((Object)thisCollection$iv.toArray(new Uri[0]));
        }
    }
}

