/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.livechatinc.inappchat.ChatWindowConfiguration;
import com.livechatinc.inappchat.ChatWindowErrorType;
import com.livechatinc.inappchat.ChatWindowEventsListener;
import com.livechatinc.inappchat.ChatWindowJsInterface;
import com.livechatinc.inappchat.ChatWindowView;
import com.livechatinc.inappchat.R;
import com.livechatinc.inappchat.UriUtils;
import com.livechatinc.inappchat.models.NewMessageModel;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatWindowViewImpl
extends FrameLayout
implements ChatWindowView {
    private WebView webView;
    private TextView statusText;
    private Button reloadButton;
    private ProgressBar progressBar;
    private WebView webViewPopup;
    private ChatWindowEventsListener eventsListener;
    private static final int REQUEST_CODE_FILE_UPLOAD = 21354;
    private ValueCallback<Uri> mUriUploadCallback;
    private ValueCallback<Uri[]> mUriArrayUploadCallback;
    private ChatWindowConfiguration config;
    private boolean initialized;
    private boolean chatUiReady = false;
    private ViewTreeObserver.OnGlobalLayoutListener layoutListener;

    public ChatWindowViewImpl(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public ChatWindowViewImpl(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        this.setFitsSystemWindows(true);
        this.setVisibility(8);
        LayoutInflater.from((Context)context).inflate(R.layout.view_chat_window_internal, (ViewGroup)this, true);
        this.webView = (WebView)this.findViewById(R.id.chat_window_web_view);
        this.statusText = (TextView)this.findViewById(R.id.chat_window_status_text);
        this.progressBar = (ProgressBar)this.findViewById(R.id.chat_window_progress);
        this.reloadButton = (Button)this.findViewById(R.id.chat_window_button);
        this.reloadButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ChatWindowViewImpl.this.reload();
            }
        });
        if (Build.VERSION.RELEASE.matches("4\\.4(\\.[12])?")) {
            String userAgentString = this.webView.getSettings().getUserAgentString();
            this.webView.getSettings().setUserAgentString(userAgentString + " AndroidNoFilesharing");
        }
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        this.webView.setFocusable(true);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setAppCacheEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.getInstance().setAcceptThirdPartyCookies(this.webView, true);
        }
        this.webView.setWebViewClient((WebViewClient)new LCWebViewClient());
        this.webView.setWebChromeClient((WebChromeClient)new LCWebChromeClient());
        this.webView.requestFocus(130);
        this.webView.setVisibility(8);
        this.webView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: 
                    case 1: {
                        if (v.hasFocus()) break;
                        v.requestFocus();
                    }
                }
                return false;
            }
        });
        this.webView.addJavascriptInterface((Object)new ChatWindowJsInterface(this), "androidMobileWidget");
        this.adjustResizeOnGlobalLayout(this.webView, this.getActivity());
    }

    private Activity getActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    private void adjustResizeOnGlobalLayout(final WebView webView, Activity activity) {
        if (!this.shouldAdjustLayout(this.getActivity())) {
            return;
        }
        View decorView = activity.getWindow().getDecorView();
        this.layoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                View decorView = ChatWindowViewImpl.this.getActivity().getWindow().getDecorView();
                ChatWindowViewImpl viewGroup = ChatWindowViewImpl.this;
                DisplayMetrics displayMetrics = ChatWindowViewImpl.this.getResources().getDisplayMetrics();
                Rect rect = new Rect();
                decorView.getWindowVisibleDisplayFrame(rect);
                int paddingBottom = displayMetrics.heightPixels - rect.bottom;
                if (viewGroup.getPaddingBottom() != paddingBottom) {
                    viewGroup.setPadding(viewGroup.getPaddingLeft(), viewGroup.getPaddingTop(), viewGroup.getPaddingRight(), paddingBottom);
                } else if (paddingBottom != 0 && Build.VERSION.SDK_INT >= 19) {
                    webView.evaluateJavascript("if (document.activeElement) { document.activeElement.scrollIntoView({behavior: \"smooth\", block: \"center\", inline: \"nearest\"}); }", null);
                }
            }
        };
        decorView.getViewTreeObserver().addOnGlobalLayoutListener(this.layoutListener);
    }

    protected void onDetachedFromWindow() {
        this.removeLayoutListener();
        this.webView.destroy();
        super.onDetachedFromWindow();
    }

    private void removeLayoutListener() {
        if (this.layoutListener == null) {
            return;
        }
        View decorView = this.getActivity().getWindow().getDecorView();
        if (Build.VERSION.SDK_INT >= 16) {
            decorView.getViewTreeObserver().removeOnGlobalLayoutListener(this.layoutListener);
        } else {
            decorView.getViewTreeObserver().removeGlobalOnLayoutListener(this.layoutListener);
        }
    }

    private boolean shouldAdjustLayout(Activity activity) {
        if (Build.VERSION.SDK_INT >= 30) {
            return false;
        }
        int flags = activity.getWindow().getAttributes().flags;
        boolean isFullScreen = (flags & 0x400) != 0;
        return isFullScreen;
    }

    private void reload() {
        if (this.initialized) {
            this.chatUiReady = false;
            this.webView.reload();
        } else {
            this.reinitialize();
        }
    }

    private void reinitialize() {
        this.webView.setVisibility(8);
        this.progressBar.setVisibility(0);
        this.statusText.setVisibility(8);
        this.reloadButton.setVisibility(8);
        this.initialized = false;
        this.initialize();
    }

    private String constructChatUrl(JSONObject jsonResponse) {
        String chatUrl = null;
        try {
            String customParams;
            chatUrl = jsonResponse.getString("chat_url");
            chatUrl = chatUrl.replace("{%license%}", this.config.getParams().get("KEY_LICENCE_NUMBER"));
            chatUrl = chatUrl.replace("{%group%}", this.config.getParams().get("KEY_GROUP_ID"));
            chatUrl = chatUrl + "&native_platform=android";
            if (this.config.getParams().get("KEY_VISITOR_NAME") != null) {
                chatUrl = chatUrl + "&name=" + URLEncoder.encode(this.config.getParams().get("KEY_VISITOR_NAME"), "UTF-8").replace("+", "%20");
            }
            if (this.config.getParams().get("KEY_VISITOR_EMAIL") != null) {
                chatUrl = chatUrl + "&email=" + URLEncoder.encode(this.config.getParams().get("KEY_VISITOR_EMAIL"), "UTF-8");
            }
            if (!TextUtils.isEmpty((CharSequence)(customParams = this.escapeCustomParams(this.config.getParams(), chatUrl)))) {
                chatUrl = chatUrl + "&params=" + customParams;
            }
            if (!chatUrl.startsWith("http")) {
                chatUrl = "https://" + chatUrl;
            }
        }
        catch (UnsupportedEncodingException | JSONException e) {
            e.printStackTrace();
        }
        return chatUrl;
    }

    private String escapeCustomParams(Map<String, String> param, String chatUrl) {
        String params = "";
        for (String key : param.keySet()) {
            if (!key.startsWith("#LCcustomParam_")) continue;
            String encodedKey = Uri.encode((String)key.replace("#LCcustomParam_", ""));
            String encodedValue = Uri.encode((String)param.get(key));
            if (!TextUtils.isEmpty((CharSequence)params)) {
                params = params + "&";
            }
            params = params + encodedKey + "=" + encodedValue;
        }
        return Uri.encode((String)params);
    }

    private void checkConfiguration() {
        if (this.config == null) {
            throw new IllegalStateException("Config must be provided before initialization");
        }
        if (this.initialized) {
            throw new IllegalStateException("Chat Window already initialized");
        }
    }

    protected void onHideChatWindow() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ChatWindowViewImpl.this.hideChatWindow();
            }
        });
    }

    @Override
    public void showChatWindow() {
        this.setVisibility(0);
        if (this.eventsListener != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ChatWindowViewImpl.this.eventsListener.onChatWindowVisibilityChanged(true);
                }
            });
        }
    }

    @Override
    public void hideChatWindow() {
        this.setVisibility(8);
        if (this.eventsListener != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ChatWindowViewImpl.this.eventsListener.onChatWindowVisibilityChanged(false);
                }
            });
        }
    }

    @Override
    public boolean isChatLoaded() {
        return this.chatUiReady;
    }

    @Override
    public boolean onBackPressed() {
        if (this.isShown()) {
            this.onHideChatWindow();
            return true;
        }
        return false;
    }

    @Override
    public boolean setConfiguration(@NonNull ChatWindowConfiguration config) {
        boolean isEqualConfig = this.config != null && this.config.equals(config);
        this.config = config;
        return !isEqualConfig;
    }

    @Override
    public void initialize() {
        this.checkConfiguration();
        this.initialized = true;
        RequestQueue queue = Volley.newRequestQueue((Context)this.getContext());
        JsonObjectRequest stringRequest = new JsonObjectRequest(0, "https://cdn.livechatinc.com/app/mobile/urls.json", null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                Log.d((String)"ChatWindowView", (String)("Response: " + response));
                String chatUrl = ChatWindowViewImpl.this.constructChatUrl(response);
                Log.d((String)"ChatWindowView", (String)("constructed url: " + chatUrl));
                ChatWindowViewImpl.this.initialized = true;
                if (chatUrl != null && ChatWindowViewImpl.this.getContext() != null) {
                    ChatWindowViewImpl.this.webView.loadUrl(chatUrl);
                    ChatWindowViewImpl.this.webView.setVisibility(0);
                }
                if (ChatWindowViewImpl.this.eventsListener != null) {
                    ChatWindowViewImpl.this.eventsListener.onWindowInitialized();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                boolean errorHandled;
                Log.d((String)"ChatWindowView", (String)("Error response: " + error));
                ChatWindowViewImpl.this.initialized = false;
                int errorCode = error.networkResponse != null ? error.networkResponse.statusCode : -1;
                boolean bl = errorHandled = ChatWindowViewImpl.this.eventsListener != null && ChatWindowViewImpl.this.eventsListener.onError(ChatWindowErrorType.InitialConfiguration, errorCode, error.getMessage());
                if (ChatWindowViewImpl.this.getContext() != null) {
                    ChatWindowViewImpl.this.onErrorDetected(errorHandled, ChatWindowErrorType.InitialConfiguration, errorCode, error.getMessage());
                }
            }
        });
        queue.add((Request)stringRequest);
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 21354) {
            if (resultCode == -1 && data != null) {
                this.receiveUploadedData(data);
            } else {
                this.resetAllUploadCallbacks();
            }
            return true;
        }
        return false;
    }

    @Override
    public void setEventsListener(ChatWindowEventsListener listener) {
        this.eventsListener = listener;
    }

    @Override
    public void reload(Boolean fullReload) {
        if (fullReload.booleanValue()) {
            this.reinitialize();
        } else {
            this.chatUiReady = false;
            this.webView.reload();
        }
    }

    private void receiveUploadedData(Intent data) {
        if (this.isUriArrayUpload()) {
            this.receiveUploadedUriArray(data);
        } else if (this.isVersionPreHoneycomb()) {
            this.receiveUploadedUriPreHoneycomb(data);
        } else {
            this.receiveUploadedUri(data);
        }
    }

    private boolean isUriArrayUpload() {
        return this.mUriArrayUploadCallback != null;
    }

    private boolean isVersionPreHoneycomb() {
        return Build.VERSION.SDK_INT < 11;
    }

    protected void onUiReady() {
        this.chatUiReady = true;
        this.post(new Runnable(){

            @Override
            public void run() {
                ChatWindowViewImpl.this.hideProgressBar();
            }
        });
    }

    protected void hideProgressBar() {
        this.progressBar.setVisibility(8);
    }

    protected void onNewMessageReceived(final NewMessageModel newMessageModel) {
        if (this.eventsListener != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ChatWindowViewImpl.this.eventsListener.onNewMessage(newMessageModel, ChatWindowViewImpl.this.isShown());
                }
            });
        }
    }

    private void onErrorDetected(boolean errorHandled, ChatWindowErrorType errorType, int errorCode, String errorDescription) {
        this.progressBar.setVisibility(8);
        if (!errorHandled) {
            if (this.chatUiReady && errorType == ChatWindowErrorType.WebViewClient && errorCode == -2) {
                return;
            }
            this.webView.setVisibility(8);
            this.statusText.setVisibility(0);
            this.reloadButton.setVisibility(0);
        }
    }

    private static boolean isSecureLivechatIncDomain(String host) {
        return host != null && Pattern.compile("(secure-?(lc|dal|fra|)\\.(livechat|livechatinc)\\.com)").matcher(host).find();
    }

    private void receiveUploadedUriArray(Intent data) {
        Uri[] uploadedUris;
        try {
            uploadedUris = new Uri[]{Uri.parse((String)data.getDataString())};
        }
        catch (Exception e) {
            uploadedUris = null;
        }
        this.mUriArrayUploadCallback.onReceiveValue(uploadedUris);
        this.mUriArrayUploadCallback = null;
    }

    private void receiveUploadedUriPreHoneycomb(Intent data) {
        Uri uploadedUri = data.getData();
        this.mUriUploadCallback.onReceiveValue((Object)uploadedUri);
        this.mUriUploadCallback = null;
    }

    private void receiveUploadedUri(Intent data) {
        Uri uploadedFileUri;
        try {
            String uploadedUriFilePath = UriUtils.getFilePathFromUri(this.getContext(), data.getData());
            File uploadedFile = new File(uploadedUriFilePath);
            uploadedFileUri = Uri.fromFile((File)uploadedFile);
        }
        catch (Exception e) {
            uploadedFileUri = null;
        }
        this.mUriUploadCallback.onReceiveValue(uploadedFileUri);
        this.mUriUploadCallback = null;
    }

    private void resetAllUploadCallbacks() {
        this.resetUriUploadCallback();
        this.resetUriArrayUploadCallback();
    }

    private void resetUriUploadCallback() {
        if (this.mUriUploadCallback != null) {
            this.mUriUploadCallback.onReceiveValue(null);
            this.mUriUploadCallback = null;
        }
    }

    private void resetUriArrayUploadCallback() {
        if (this.mUriArrayUploadCallback != null) {
            this.mUriArrayUploadCallback.onReceiveValue(null);
            this.mUriArrayUploadCallback = null;
        }
    }

    private void chooseUriToUpload(ValueCallback<Uri> uriValueCallback) {
        this.resetAllUploadCallbacks();
        this.mUriUploadCallback = uriValueCallback;
        this.startFileChooserActivity();
    }

    private void chooseUriArrayToUpload(ValueCallback<Uri[]> uriArrayValueCallback) {
        this.resetAllUploadCallbacks();
        this.mUriArrayUploadCallback = uriArrayValueCallback;
        this.startFileChooserActivity();
    }

    private void startFileChooserActivity() {
        if (this.eventsListener != null) {
            Intent intent = new Intent("android.intent.action.GET_CONTENT");
            intent.addCategory("android.intent.category.OPENABLE");
            intent.setType("*/*");
            this.eventsListener.onStartFilePickerActivity(intent, 21354);
        } else {
            Log.e((String)"ChatWindowView", (String)"You must provide a listener to handle file sharing");
            Toast.makeText((Context)this.getContext(), (int)R.string.cant_share_files, (int)0).show();
        }
    }

    class LCWebChromeClient
    extends WebChromeClient {
        LCWebChromeClient() {
        }

        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            ChatWindowViewImpl.this.webViewPopup = new WebView(ChatWindowViewImpl.this.getContext());
            CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT >= 21) {
                cookieManager.getInstance().setAcceptThirdPartyCookies(ChatWindowViewImpl.this.webViewPopup, true);
            }
            ChatWindowViewImpl.this.webViewPopup.setVerticalScrollBarEnabled(false);
            ChatWindowViewImpl.this.webViewPopup.setHorizontalScrollBarEnabled(false);
            ChatWindowViewImpl.this.webViewPopup.setWebViewClient((WebViewClient)new LCWebViewClient());
            ChatWindowViewImpl.this.webViewPopup.getSettings().setJavaScriptEnabled(true);
            ChatWindowViewImpl.this.webViewPopup.getSettings().setSavePassword(false);
            ChatWindowViewImpl.this.webViewPopup.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            ChatWindowViewImpl.this.addView((View)ChatWindowViewImpl.this.webViewPopup);
            WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
            transport.setWebView(ChatWindowViewImpl.this.webViewPopup);
            resultMsg.sendToTarget();
            return true;
        }

        public void onCloseWindow(WebView window) {
            Log.d((String)"onCloseWindow", (String)"called");
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg) {
            ChatWindowViewImpl.this.chooseUriToUpload((ValueCallback<Uri>)uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType) {
            ChatWindowViewImpl.this.chooseUriToUpload((ValueCallback<Uri>)uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
            ChatWindowViewImpl.this.chooseUriToUpload((ValueCallback<Uri>)uploadMsg);
        }

        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> uploadMsg, WebChromeClient.FileChooserParams fileChooserParams) {
            ChatWindowViewImpl.this.chooseUriArrayToUpload((ValueCallback<Uri[]>)uploadMsg);
            return true;
        }

        public boolean onConsoleMessage(final ConsoleMessage consoleMessage) {
            if (consoleMessage.messageLevel() == ConsoleMessage.MessageLevel.ERROR) {
                final boolean errorHandled = ChatWindowViewImpl.this.eventsListener != null && ChatWindowViewImpl.this.eventsListener.onError(ChatWindowErrorType.Console, -1, consoleMessage.message());
                ChatWindowViewImpl.this.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatWindowViewImpl.this.onErrorDetected(errorHandled, ChatWindowErrorType.Console, -1, consoleMessage.message());
                    }
                });
            }
            Log.i((String)"ChatWindowView", (String)("onConsoleMessage" + consoleMessage.messageLevel().name() + " " + consoleMessage.message()));
            return super.onConsoleMessage(consoleMessage);
        }
    }

    class LCWebViewClient
    extends WebViewClient {
        LCWebViewClient() {
        }

        public void onPageFinished(WebView view, String url) {
            if (url.startsWith("https://www.facebook.com/dialog/return/arbiter") && ChatWindowViewImpl.this.webViewPopup != null) {
                ChatWindowViewImpl.this.webViewPopup.setVisibility(8);
                ChatWindowViewImpl.this.removeView((View)ChatWindowViewImpl.this.webViewPopup);
                ChatWindowViewImpl.this.webViewPopup = null;
            }
            super.onPageFinished(view, url);
        }

        @TargetApi(value=23)
        public void onReceivedError(WebView view, WebResourceRequest request, final WebResourceError error) {
            final boolean errorHandled = ChatWindowViewImpl.this.eventsListener != null && ChatWindowViewImpl.this.eventsListener.onError(ChatWindowErrorType.WebViewClient, error.getErrorCode(), String.valueOf(error.getDescription()));
            ChatWindowViewImpl.this.post(new Runnable(){

                @Override
                public void run() {
                    ChatWindowViewImpl.this.onErrorDetected(errorHandled, ChatWindowErrorType.WebViewClient, error.getErrorCode(), String.valueOf(error.getDescription()));
                }
            });
            super.onReceivedError(view, request, error);
            Log.e((String)"ChatWindow Widget", (String)("onReceivedError: " + error.getErrorCode() + ": desc: " + error.getDescription() + " url: " + request.getUrl()));
        }

        public void onReceivedError(WebView view, final int errorCode, final String description, String failingUrl) {
            final boolean errorHandled = ChatWindowViewImpl.this.eventsListener != null && ChatWindowViewImpl.this.eventsListener.onError(ChatWindowErrorType.WebViewClient, errorCode, description);
            ChatWindowViewImpl.this.post(new Runnable(){

                @Override
                public void run() {
                    ChatWindowViewImpl.this.onErrorDetected(errorHandled, ChatWindowErrorType.WebViewClient, errorCode, description);
                }
            });
            super.onReceivedError(view, errorCode, description, failingUrl);
            Log.e((String)"ChatWindow Widget", (String)("onReceivedError: " + errorCode + ": desc: " + description + " url: " + failingUrl));
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Uri uri = Uri.parse((String)url);
            return this.handleUri(view, uri);
        }

        @TargetApi(value=24)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            Uri uri = request.getUrl();
            return this.handleUri(view, uri);
        }

        private boolean handleUri(WebView webView, Uri uri) {
            String originalUrl;
            String uriString = uri.toString();
            Log.i((String)"ChatWindowView", (String)("handle url: " + uriString));
            boolean facebookLogin = uriString.matches("https://.+facebook.+(/dialog/oauth\\?|/login\\.php\\?|/dialog/return/arbiter\\?).+");
            if (facebookLogin) {
                return false;
            }
            if (ChatWindowViewImpl.this.webViewPopup != null) {
                ChatWindowViewImpl.this.webViewPopup.setVisibility(8);
                ChatWindowViewImpl.this.removeView((View)ChatWindowViewImpl.this.webViewPopup);
                ChatWindowViewImpl.this.webViewPopup = null;
            }
            if (uriString.equals(originalUrl = webView.getOriginalUrl()) || ChatWindowViewImpl.isSecureLivechatIncDomain(uri.getHost())) {
                return false;
            }
            if (ChatWindowViewImpl.this.eventsListener == null || !ChatWindowViewImpl.this.eventsListener.handleUri(uri)) {
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                ChatWindowViewImpl.this.getContext().startActivity(intent);
            }
            return true;
        }
    }
}

