/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.app.Fragment;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.livechatinc.inappchat.ChatWindowConfiguration;
import com.livechatinc.inappchat.ChatWindowErrorType;
import com.livechatinc.inappchat.ChatWindowView;
import com.livechatinc.inappchat.R;
import com.livechatinc.inappchat.models.NewMessageModel;
import java.util.HashMap;

public final class ChatWindowFragment
extends Fragment
implements ChatWindowView.ChatWindowEventsListener {
    private ChatWindowConfiguration configuration;
    private ChatWindowView chatWindow;

    public static ChatWindowFragment newInstance(Object licenceNumber, Object groupId) {
        return ChatWindowFragment.newInstance(licenceNumber, groupId, null, null, null);
    }

    public static ChatWindowFragment newInstance(Object licenceNumber, Object groupId, @Nullable String visitorName, @Nullable String visitorEmail) {
        return ChatWindowFragment.newInstance(licenceNumber, groupId, visitorName, visitorEmail, null);
    }

    public static ChatWindowFragment newInstance(Object licenceNumber, Object groupId, @Nullable String visitorName, @Nullable String visitorEmail, @Nullable HashMap<String, String> customVariables) {
        Bundle arguments = new Bundle();
        arguments.putString("KEY_LICENCE_NUMBER", String.valueOf(licenceNumber));
        arguments.putString("KEY_GROUP_ID", String.valueOf(groupId));
        if (visitorName != null) {
            arguments.putString("KEY_VISITOR_NAME", visitorName);
        }
        if (visitorEmail != null) {
            arguments.putString("KEY_VISITOR_EMAIL", visitorEmail);
        }
        if (customVariables != null) {
            for (String key : customVariables.keySet()) {
                arguments.putString("#LCcustomParam_" + key, customVariables.get(key));
            }
        }
        ChatWindowFragment chatWindowFragment = new ChatWindowFragment();
        chatWindowFragment.setArguments(arguments);
        return chatWindowFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ChatWindowConfiguration.Builder builder = new ChatWindowConfiguration.Builder();
        HashMap<String, String> customParams = new HashMap<String, String>();
        if (this.getArguments() != null) {
            for (String key : this.getArguments().keySet()) {
                if ("KEY_LICENCE_NUMBER".equals(key)) {
                    builder.setLicenceNumber(this.getArguments().getString("KEY_LICENCE_NUMBER"));
                    continue;
                }
                if ("KEY_GROUP_ID".equals(key)) {
                    builder.setGroupId(this.getArguments().getString("KEY_GROUP_ID"));
                    continue;
                }
                if ("KEY_VISITOR_NAME".equals(key)) {
                    builder.setVisitorName(this.getArguments().getString("KEY_VISITOR_NAME"));
                    continue;
                }
                if ("KEY_VISITOR_EMAIL".equals(key)) {
                    builder.setVisitorEmail(this.getArguments().getString("KEY_VISITOR_EMAIL"));
                    continue;
                }
                customParams.put(key, String.valueOf(this.getArguments().get(key)));
            }
            builder.setCustomParams(customParams);
        }
        this.configuration = builder.build();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.chatWindow = (ChatWindowView)inflater.inflate(R.layout.view_chat_window, container, false);
        this.chatWindow.setUpWindow(this.configuration);
        this.chatWindow.setUpListener(this);
        this.chatWindow.initialize();
        this.chatWindow.showChatWindow();
        return this.chatWindow;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.chatWindow.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onChatWindowVisibilityChanged(boolean visible) {
        if (!visible) {
            this.getActivity().onBackPressed();
        }
    }

    @Override
    public void onNewMessage(NewMessageModel message, boolean windowVisible) {
    }

    @Override
    public boolean handleUri(Uri uri) {
        return false;
    }

    @Override
    public void onStartFilePickerActivity(Intent intent, int requestCode) {
        this.startActivityForResult(intent, requestCode);
    }

    @Override
    public boolean onError(ChatWindowErrorType errorType, int errorCode, String errorDescription) {
        return false;
    }
}

