/*
 * Decompiled with CFR 0.152.
 */
package com.spider.autoswitching.bind;

import com.spider.autoswitching.bind.ConfigurationPropertiesBinding;
import java.util.function.Consumer;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;

public class SpringBoot2ConfigurationPropertiesBinding
implements ConfigurationPropertiesBinding,
ApplicationContextAware {
    private Binder binder;

    @Override
    public <T> void bind(T target, String prefix) {
        Bindable bindable = Bindable.of(target.getClass()).withExistingValue(target);
        this.binder.bind(prefix, bindable);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
        this.binder = new Binder(this.getConfigurationPropertySources(configurableApplicationContext), (PlaceholdersResolver)this.getPropertySourcesPlaceholdersResolver(configurableApplicationContext), this.getConversionService(configurableApplicationContext), this.getPropertyEditorInitializer(configurableApplicationContext));
    }

    private Iterable<ConfigurationPropertySource> getConfigurationPropertySources(ConfigurableApplicationContext applicationContext) {
        return ConfigurationPropertySources.from((Iterable)applicationContext.getEnvironment().getPropertySources());
    }

    private PropertySourcesPlaceholdersResolver getPropertySourcesPlaceholdersResolver(ConfigurableApplicationContext applicationContext) {
        return new PropertySourcesPlaceholdersResolver((Iterable)applicationContext.getEnvironment().getPropertySources());
    }

    private ConversionService getConversionService(ConfigurableApplicationContext applicationContext) {
        return applicationContext.getBeanFactory().getConversionService();
    }

    private Consumer<PropertyEditorRegistry> getPropertyEditorInitializer(ConfigurableApplicationContext applicationContext) {
        return arg_0 -> ((ConfigurableListableBeanFactory)applicationContext.getBeanFactory()).copyRegisteredEditorsTo(arg_0);
    }
}

