/*
 * Decompiled with CFR 0.152.
 */
package com.spider.autoswitching;

import com.spider.autoswitching.AsyncTerminateStrategy;
import com.spider.common.SpiderDefaultThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SpinAsyncTerminateStrategy<T>
implements AsyncTerminateStrategy<T> {
    private static final Logger logger = LoggerFactory.getLogger(SpinAsyncTerminateStrategy.class);
    private static final int DEFAULT_MAX_RETRIES = 10;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    private static final int DEFAULT_BASE_SLEEP_TIME_SS = 15;
    private final Executor executor;
    private final AsyncTerminateStrategy.Closeable<T> closeable;
    private final int maxRetries;
    private final TimeUnit unit;
    private final long baseSleepTime;
    private final Class<T> type;

    public SpinAsyncTerminateStrategy(Class<T> type, AsyncTerminateStrategy.Closeable<T> closeable) {
        this(type, closeable, 10, DEFAULT_TIME_UNIT, 15L);
    }

    public SpinAsyncTerminateStrategy(Class<T> type, AsyncTerminateStrategy.Closeable<T> closeable, int maxRetries, TimeUnit unit, long baseSleepTime) {
        Assert.notNull(type, (String)"type can not be empty");
        Assert.notNull(type, (String)"closeable can not be empty");
        this.unit = unit;
        this.maxRetries = maxRetries;
        this.closeable = closeable;
        this.baseSleepTime = baseSleepTime;
        String name = type.getSimpleName();
        this.type = type;
        this.executor = new ThreadPoolExecutor(1, 1, 2L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new SpiderDefaultThreadFactory("spin-" + name + "terminate-pool", "terminate-" + name));
    }

    @Override
    public void terminate(T destroyObj) {
        this.executor.execute(() -> {
            logger.info("type {} start closing", this.type);
            for (int i = 1; !this.closeable.close(destroyObj) && i <= this.maxRetries; ++i) {
                try {
                    logger.debug("type {} closed unfinished [retries={}, maxRetries={}, baseSleepTime={}, unit={}]", new Object[]{this.type, i, this.maxRetries, this.baseSleepTime, this.unit});
                    this.unit.sleep(this.baseSleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            logger.info("type {} closed complete", this.type);
        });
    }
}

