/*
 * Decompiled with CFR 0.152.
 */
package com.spider.autoswitching;

import com.spider.autoswitching.AutoSwitchingBean;
import com.spider.autoswitching.event.ConfigChangeProxy;
import com.spider.proxy.Proxys;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class AutoSwitchingBeanRegistry
implements ApplicationContextAware {
    private ConfigChangeProxy configChangeProxy;
    private ConfigurableApplicationContext applicationContext;

    public AutoSwitchingBeanRegistry(ConfigChangeProxy configChangeProxy) {
        this.configChangeProxy = configChangeProxy;
    }

    public <T> boolean register(AutoSwitchingBean<T> autoSwitchingBean) {
        ConfigurableListableBeanFactory beanFactory = this.applicationContext.getBeanFactory();
        if (!beanFactory.containsLocalBean(autoSwitchingBean.beanName())) {
            T proxyT = Proxys.newProxyInstance(autoSwitchingBean.type(), autoSwitchingBean.autosWitchingProxyHandler());
            beanFactory.registerSingleton(autoSwitchingBean.beanName(), proxyT);
        }
        this.configChangeProxy.addChangeListener(autoSwitchingBean.namespace(), autoSwitchingBean::onChange);
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }
}

