/*
 * Decompiled with CFR 0.152.
 */
package com.rxjava.rxlife;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.rxjava.rxlife.Scope;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import org.jetbrains.annotations.NotNull;

public class BaseScope
implements Scope,
LifecycleEventObserver {
    private CompositeDisposable mDisposables;

    public BaseScope(LifecycleOwner owner) {
        owner.getLifecycle().addObserver((LifecycleObserver)this);
    }

    @Override
    public void onScopeStart(Disposable d) {
        this.addDisposable(d);
    }

    @Override
    public void onScopeEnd() {
    }

    private void addDisposable(Disposable disposable) {
        CompositeDisposable disposables = this.mDisposables;
        if (disposables == null) {
            disposables = this.mDisposables = new CompositeDisposable();
        }
        disposables.add(disposable);
    }

    private void dispose() {
        CompositeDisposable disposables = this.mDisposables;
        if (disposables == null) {
            return;
        }
        disposables.dispose();
    }

    public void onStateChanged(@NotNull LifecycleOwner source, @NotNull Lifecycle.Event event) {
        if (event == Lifecycle.Event.ON_DESTROY) {
            source.getLifecycle().removeObserver((LifecycleObserver)this);
            this.dispose();
        }
    }
}

