/*
 * Decompiled with CFR 0.152.
 */
package com.rxjava.rxlife;

import com.rxjava.rxlife.LifeConditionalSubscriber;
import com.rxjava.rxlife.LifeSubscriber;
import com.rxjava.rxlife.Scope;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.internal.fuseable.ConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import org.reactivestreams.Subscriber;

public class ParallelFlowableLife<T> {
    private ParallelFlowable<T> upStream;
    private Scope scope;
    private boolean onMain;

    ParallelFlowableLife(ParallelFlowable<T> upStream, Scope scope, boolean onMain) {
        this.upStream = upStream;
        this.scope = scope;
        this.onMain = onMain;
    }

    public void subscribe(@NonNull Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> a = subscribers[i];
            parents[i] = a instanceof ConditionalSubscriber ? new LifeConditionalSubscriber((ConditionalSubscriber)a, this.scope) : new LifeSubscriber<T>(a, this.scope);
        }
        ParallelFlowable upStream = this.upStream;
        if (this.onMain) {
            upStream = upStream.runOn(AndroidSchedulers.mainThread());
        }
        upStream.subscribe(parents);
    }

    private int parallelism() {
        return this.upStream.parallelism();
    }

    private boolean validate(@NonNull Subscriber<?>[] subscribers) {
        int p = this.parallelism();
        if (subscribers.length != p) {
            IllegalArgumentException iae = new IllegalArgumentException("parallelism = " + p + ", subscribers = " + subscribers.length);
            for (Subscriber<?> s : subscribers) {
                EmptySubscription.error((Throwable)iae, s);
            }
            return false;
        }
        return true;
    }
}

