/*
 * Decompiled with CFR 0.152.
 */
package com.rxjava.rxlife;

import com.rxjava.rxlife.AbstractLifecycle;
import com.rxjava.rxlife.Scope;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

final class LifeMaybeObserver<T>
extends AbstractLifecycle<Disposable>
implements MaybeObserver<T> {
    private MaybeObserver<? super T> downstream;

    LifeMaybeObserver(MaybeObserver<? super T> downstream, Scope scope) {
        super(scope);
        this.downstream = downstream;
    }

    public void onSubscribe(Disposable d) {
        if (DisposableHelper.setOnce((AtomicReference)this, (Disposable)d)) {
            try {
                this.addObserver();
                this.downstream.onSubscribe(d);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                d.dispose();
                this.onError(ex);
            }
        }
    }

    public void onSuccess(T t) {
        if (this.isDisposed()) {
            return;
        }
        this.lazySet(DisposableHelper.DISPOSED);
        try {
            this.removeObserver();
            this.downstream.onSuccess(t);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            RxJavaPlugins.onError((Throwable)ex);
        }
    }

    public void onError(Throwable t) {
        if (this.isDisposed()) {
            RxJavaPlugins.onError((Throwable)t);
            return;
        }
        this.lazySet(DisposableHelper.DISPOSED);
        try {
            this.removeObserver();
            this.downstream.onError(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, e}));
        }
    }

    public void onComplete() {
        if (this.isDisposed()) {
            return;
        }
        this.lazySet(DisposableHelper.DISPOSED);
        try {
            this.removeObserver();
            this.downstream.onComplete();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            RxJavaPlugins.onError((Throwable)e);
        }
    }

    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
    }

    public void dispose() {
        DisposableHelper.dispose((AtomicReference)this);
    }
}

