/*
 * Decompiled with CFR 0.152.
 */
package com.rxjava.rxlife;

import com.rxjava.rxlife.AbstractLifecycle;
import com.rxjava.rxlife.Scope;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

final class LifeCompletableObserver
extends AbstractLifecycle<Disposable>
implements CompletableObserver {
    private CompletableObserver downstream;

    LifeCompletableObserver(CompletableObserver downstream, Scope scope) {
        super(scope);
        this.downstream = downstream;
    }

    public void onSubscribe(Disposable d) {
        if (DisposableHelper.setOnce((AtomicReference)this, (Disposable)d)) {
            try {
                this.addObserver();
                this.downstream.onSubscribe(d);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                d.dispose();
                this.onError(ex);
            }
        }
    }

    public void onError(Throwable t) {
        if (this.isDisposed()) {
            return;
        }
        this.lazySet(DisposableHelper.DISPOSED);
        try {
            this.removeObserver();
            this.downstream.onError(t);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            RxJavaPlugins.onError((Throwable)ex);
        }
    }

    public void onComplete() {
        if (this.isDisposed()) {
            return;
        }
        this.lazySet(DisposableHelper.DISPOSED);
        try {
            this.removeObserver();
            this.downstream.onComplete();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            RxJavaPlugins.onError((Throwable)ex);
        }
    }

    public void dispose() {
        DisposableHelper.dispose((AtomicReference)this);
    }

    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
    }
}

