/*
 * Decompiled with CFR 0.152.
 */
package com.rxhttp.compiler.ksp;

import com.google.devtools.ksp.KSTypesNotPresentException;
import com.google.devtools.ksp.KspExperimental;
import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSVisitorVoid;
import com.rxhttp.compiler.ksp.KspKt;
import com.rxhttp.compiler.ksp.ParserVisitorKt;
import com.rxhttp.compiler.ksp.RxHttpExtensions;
import com.squareup.javapoet.ClassName;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.javapoet.J2kInteropKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rxhttp.wrapper.annotation.Parser;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0014H\u0017\u00a2\u0006\u0002\u0010\u0017J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/rxhttp/compiler/ksp/ParserVisitor;", "Lcom/google/devtools/ksp/symbol/KSVisitorVoid;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "<init>", "(Lcom/google/devtools/ksp/processing/Resolver;Lcom/google/devtools/ksp/processing/KSPLogger;)V", "ksClassMap", "Ljava/util/LinkedHashMap;", "", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "classNameMap", "", "Lcom/squareup/kotlinpoet/ClassName;", "originatingKSFiles", "Lcom/google/devtools/ksp/symbol/KSFile;", "getOriginatingKSFiles", "()Ljava/util/List;", "visitClassDeclaration", "", "classDeclaration", "data", "(Lcom/google/devtools/ksp/symbol/KSClassDeclaration;Lkotlin/Unit;)V", "getFunList", "Lcom/squareup/kotlinpoet/FunSpec;", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "companionFunList", "", "defaultKsFile", "rxhttp-compiler"})
@SourceDebugExtension(value={"SMAP\nParserVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParserVisitor.kt\ncom/rxhttp/compiler/ksp/ParserVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,390:1\n1557#2:391\n1628#2,3:392\n1557#2:399\n1628#2,3:400\n11158#3:395\n11493#3,3:396\n1#4:403\n216#5,2:404\n*S KotlinDebug\n*F\n+ 1 ParserVisitor.kt\ncom/rxhttp/compiler/ksp/ParserVisitor\n*L\n60#1:391\n60#1:392,3\n77#1:399\n77#1:400,3\n75#1:395\n75#1:396,3\n99#1:404,2\n*E\n"})
public final class ParserVisitor
extends KSVisitorVoid {
    @NotNull
    private final Resolver resolver;
    @NotNull
    private final KSPLogger logger;
    @NotNull
    private final LinkedHashMap<String, KSClassDeclaration> ksClassMap;
    @NotNull
    private final LinkedHashMap<String, List<com.squareup.kotlinpoet.ClassName>> classNameMap;

    public ParserVisitor(@NotNull Resolver resolver, @NotNull KSPLogger logger) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.resolver = resolver;
        this.logger = logger;
        this.ksClassMap = new LinkedHashMap();
        this.classNameMap = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KSFile> getOriginatingKSFiles() {
        void $this$mapTo$iv$iv;
        Collection<KSClassDeclaration> collection = this.ksClassMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KSClassDeclaration kSClassDeclaration = (KSClassDeclaration)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            KSFile kSFile = it.getContainingFile();
            Intrinsics.checkNotNull((Object)kSFile);
            collection2.add(kSFile);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @KspExperimental
    public void visitClassDeclaration(@NotNull KSClassDeclaration classDeclaration, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            List classNames;
            List list;
            ParserVisitorKt.access$checkParserValidClass(classDeclaration, this.resolver);
            KClass[] annotation = (KClass[])SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)classDeclaration), (KClass)Reflection.getOrCreateKotlinClass(Parser.class)));
            String name = null;
            name = annotation != null ? annotation.name() : null;
            CharSequence charSequence = name;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                name = classDeclaration.getSimpleName().toString();
            }
            ((Map)this.ksClassMap).put(name, classDeclaration);
            try {
                List list2;
                KClass[] kClassArray = annotation;
                if (annotation != null && (kClassArray = Reflection.getOrCreateKotlinClasses((Class[])kClassArray.wrappers())) != null) {
                    void $this$mapTo$iv$iv;
                    KClass[] $this$map$iv = kClassArray;
                    boolean $i$f$map = false;
                    KClass[] kClassArray2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var15_23 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        ClassName className = ClassName.get((Class)JvmClassMappingKt.getJavaClass((KClass)it));
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        collection.add(J2kInteropKt.toKClassName((ClassName)className));
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = null;
                }
                list = list2;
            }
            catch (KSTypesNotPresentException e) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = e.getKsTypes();
                boolean $i$f$map = false;
                Iterable destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    KSType it = (KSType)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    KSName kSName = it.getDeclaration().getQualifiedName();
                    String className = String.valueOf(kSName != null ? kSName.asString() : null);
                    ClassName className2 = ClassName.bestGuess((String)className);
                    Intrinsics.checkNotNullExpressionValue((Object)className2, (String)"bestGuess(...)");
                    collection.add(J2kInteropKt.toKClassName((ClassName)className2));
                }
                list = (List)destination$iv$iv2;
            }
            List list3 = classNames = list;
            if (list3 != null) {
                List it = list3;
                boolean bl = false;
                ((Map)this.classNameMap).put(name, it);
            }
        }
        catch (NoSuchElementException e) {
            KspKt.error(this.logger, e, (KSNode)classDeclaration);
        }
    }

    @KspExperimental
    @NotNull
    public final List<FunSpec> getFunList(@NotNull CodeGenerator codeGenerator, @NotNull List<FunSpec> companionFunList, @Nullable KSFile defaultKsFile) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        Intrinsics.checkNotNullParameter(companionFunList, (String)"companionFunList");
        ArrayList funList = new ArrayList();
        RxHttpExtensions rxHttpExtensions = new RxHttpExtensions(this.logger);
        Map $this$forEach$iv = this.ksClassMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String parserAlias = (String)entry.getKey();
            KSClassDeclaration ksClass = (KSClassDeclaration)entry.getValue();
            rxHttpExtensions.generateRxHttpExtendFun(ksClass, parserAlias);
            List toObservableXxxFunList = ParserVisitorKt.access$getToObservableXxxFun(ksClass, parserAlias, this.classNameMap, companionFunList);
            funList.addAll(toObservableXxxFunList);
        }
        rxHttpExtensions.generateClassFile(codeGenerator, defaultKsFile);
        return funList;
    }
}

