/*
 * Decompiled with CFR 0.152.
 */
package com.rxhttp.compiler.kapt;

import com.rxhttp.compiler.ConstantsKt;
import com.rxhttp.compiler.VariablesKt;
import com.rxhttp.compiler.kapt.UtilsKt;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rxhttp.wrapper.annotation.Converter;
import rxhttp.wrapper.annotation.Domain;
import rxhttp.wrapper.annotation.OkClient;
import rxhttp.wrapper.annotation.Param;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/rxhttp/compiler/kapt/RxHttpWrapper;", "", "logger", "Ljavax/annotation/processing/Messager;", "<init>", "(Ljavax/annotation/processing/Messager;)V", "classMap", "Ljava/util/LinkedHashMap;", "", "Lcom/rxhttp/compiler/kapt/RxHttpWrapper$Wrapper;", "Lkotlin/collections/LinkedHashMap;", "elementMap", "Ljavax/lang/model/element/TypeElement;", "add", "", "typeElement", "addOkClient", "variableElement", "Ljavax/lang/model/element/VariableElement;", "addConverter", "addDomain", "generateRxWrapper", "filer", "Ljavax/annotation/processing/Filer;", "generateRequestFunList", "Ljava/util/ArrayList;", "Lcom/squareup/javapoet/MethodSpec;", "Lkotlin/collections/ArrayList;", "getConstructorFun", "", "Ljavax/lang/model/element/ExecutableElement;", "Wrapper", "rxhttp-compiler"})
@SourceDebugExtension(value={"SMAP\nRxHttpWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RxHttpWrapper.kt\ncom/rxhttp/compiler/kapt/RxHttpWrapper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,239:1\n216#2:240\n217#2:242\n216#2,2:243\n216#2:245\n217#2:259\n1#3:241\n1557#4:246\n1628#4,3:247\n1863#4:254\n1628#4,3:255\n1864#4:258\n1863#4,2:260\n37#5:250\n36#5,3:251\n*S KotlinDebug\n*F\n+ 1 RxHttpWrapper.kt\ncom/rxhttp/compiler/kapt/RxHttpWrapper\n*L\n104#1:240\n104#1:242\n171#1:243,2\n183#1:245\n183#1:259\n184#1:246\n184#1:247,3\n196#1:254\n198#1:255,3\n196#1:258\n223#1:260,2\n190#1:250\n190#1:251,3\n*E\n"})
public final class RxHttpWrapper {
    @NotNull
    private final Messager logger;
    @NotNull
    private final LinkedHashMap<String, Wrapper> classMap;
    @NotNull
    private final LinkedHashMap<String, TypeElement> elementMap;

    public RxHttpWrapper(@NotNull Messager logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.classMap = new LinkedHashMap();
        this.elementMap = new LinkedHashMap();
    }

    public final void add(@NotNull TypeElement typeElement) {
        Intrinsics.checkNotNullParameter((Object)typeElement, (String)"typeElement");
        Param annotation = typeElement.getAnnotation(Param.class);
        String name = annotation.methodName();
        ((Map)this.elementMap).put(name, typeElement);
    }

    public final void addOkClient(@NotNull VariableElement variableElement) {
        String name;
        Intrinsics.checkNotNullParameter((Object)variableElement, (String)"variableElement");
        OkClient okClient = variableElement.getAnnotation(OkClient.class);
        if (((CharSequence)okClient.className()).length() == 0) {
            return;
        }
        Wrapper wrapper = this.classMap.get(okClient.className());
        if (wrapper == null) {
            wrapper = new Wrapper();
            ((Map)this.classMap).put(okClient.className(), wrapper);
        }
        if (wrapper.getOkClientName() != null) {
            String msg = "@OkClient annotation className cannot be the same";
            UtilsKt.error(this.logger, msg, variableElement);
        }
        if (StringsKt.isBlank((CharSequence)(name = okClient.name()))) {
            name = UtilsKt.firstLetterUpperCase(variableElement.getSimpleName().toString());
        }
        wrapper.setOkClientName(name);
    }

    public final void addConverter(@NotNull VariableElement variableElement) {
        String name;
        Intrinsics.checkNotNullParameter((Object)variableElement, (String)"variableElement");
        Converter converter = variableElement.getAnnotation(Converter.class);
        if (((CharSequence)converter.className()).length() == 0) {
            return;
        }
        Wrapper wrapper = this.classMap.get(converter.className());
        if (wrapper == null) {
            wrapper = new Wrapper();
            ((Map)this.classMap).put(converter.className(), wrapper);
        }
        if (wrapper.getConverterName() != null) {
            String msg = "@Converter annotation className cannot be the same";
            UtilsKt.error(this.logger, msg, variableElement);
        }
        if (StringsKt.isBlank((CharSequence)(name = converter.name()))) {
            name = UtilsKt.firstLetterUpperCase(variableElement.getSimpleName().toString());
        }
        wrapper.setConverterName(name);
    }

    public final void addDomain(@NotNull VariableElement variableElement) {
        String name;
        Intrinsics.checkNotNullParameter((Object)variableElement, (String)"variableElement");
        Domain domain = variableElement.getAnnotation(Domain.class);
        if (((CharSequence)domain.className()).length() == 0) {
            return;
        }
        Wrapper wrapper = this.classMap.get(domain.className());
        if (wrapper == null) {
            wrapper = new Wrapper();
            ((Map)this.classMap).put(domain.className(), wrapper);
        }
        if (wrapper.getDomainName() != null) {
            String msg = "@Domain annotation className cannot be the same";
            UtilsKt.error(this.logger, msg, variableElement);
        }
        if (StringsKt.isBlank((CharSequence)(name = domain.name()))) {
            name = UtilsKt.firstLetterUpperCase(variableElement.getSimpleName().toString());
        }
        wrapper.setDomainName(name);
    }

    public final void generateRxWrapper(@NotNull Filer filer) {
        Intrinsics.checkNotNullParameter((Object)filer, (String)"filer");
        ArrayList<MethodSpec> requestFunList = this.generateRequestFunList();
        TypeName[] typeNameArray = new TypeName[]{ConstantsKt.getRxhttpClass()};
        TypeVariableName typeVariableR = TypeVariableName.get((String)"R", (TypeName[])typeNameArray);
        Map $this$forEach$iv = this.classMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String it;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String className = (String)entry.getKey();
            Wrapper wrapper = (Wrapper)entry.getValue();
            CodeBlock.Builder funBody = CodeBlock.builder();
            if (wrapper.getConverterName() != null) {
                boolean bl2 = false;
                funBody.addStatement("rxHttp.set" + it + "()", new Object[0]);
            }
            if (wrapper.getOkClientName() != null) {
                boolean bl3 = false;
                funBody.addStatement("rxHttp.set" + it + "()", new Object[0]);
            }
            if (wrapper.getDomainName() != null) {
                boolean bl4 = false;
                funBody.addStatement("rxHttp.setDomainTo" + it + "IfAbsent()", new Object[0]);
            }
            ArrayList<MethodSpec> methodList = new ArrayList<MethodSpec>();
            Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE, Modifier.STATIC};
            Modifier[] $this$generateRxWrapper_u24lambda_u244_u24lambda_u243 = modifierArray = MethodSpec.methodBuilder((String)"wrapper").addJavadoc("\u672c\u7c7b\u6240\u6709\u65b9\u6cd5\u90fd\u4f1a\u8c03\u7528\u672c\u65b9\u6cd5", new Object[0]).addTypeVariable(typeVariableR).addModifiers(modifierArray).addParameter((TypeName)typeVariableR, "rxHttp", new Modifier[0]).addCode(funBody.build()).addStatement("return rxHttp", new Object[0]).returns((TypeName)typeVariableR).build();
            boolean bl5 = false;
            methodList.add((MethodSpec)$this$generateRxWrapper_u24lambda_u244_u24lambda_u243);
            methodList.addAll((Collection)requestFunList);
            Modifier[] modifierArray2 = new Modifier[]{Modifier.PUBLIC};
            TypeSpec.Builder rxHttpBuilder = TypeSpec.classBuilder((String)("Rx" + className + "Http")).addJavadoc("\u672c\u7c7b\u7531@Converter\u3001@Domain\u3001@OkClient\u6ce8\u89e3\u4e2d\u7684className\u5b57\u6bb5\u751f\u6210  \u7c7b\u547d\u540d\u65b9\u5f0f: Rx + {className\u5b57\u6bb5\u503c} + Http\nGithub\nhttps://github.com/liujingxing/rxhttp\nhttps://github.com/liujingxing/rxlife\nhttps://github.com/liujingxing/rxhttp/wiki/FAQ\nhttps://github.com/liujingxing/rxhttp/wiki/\u66f4\u65b0\u65e5\u5fd7", new Object[0]).addModifiers(modifierArray2).addMethods((Iterable)methodList);
            JavaFile.builder((String)VariablesKt.getRxHttpPackage(), (TypeSpec)rxHttpBuilder.build()).skipJavaLangImports(true).build().writeTo(filer);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<MethodSpec> generateRequestFunList() {
        Iterable $this$generateRequestFunList_u24lambda_u246_u24lambda_u245;
        String key;
        boolean bl;
        Map.Entry entry;
        Map.Entry element$iv;
        ArrayTypeName arrayObject = ArrayTypeName.of((TypeName)((TypeName)TypeName.OBJECT));
        ArrayList<MethodSpec> methodList = new ArrayList<MethodSpec>();
        LinkedHashMap methodMap = new LinkedHashMap();
        ((Map)methodMap).put("get", "RxHttpNoBodyParam");
        ((Map)methodMap).put("head", "RxHttpNoBodyParam");
        ((Map)methodMap).put("postBody", "RxHttpBodyParam");
        ((Map)methodMap).put("putBody", "RxHttpBodyParam");
        ((Map)methodMap).put("patchBody", "RxHttpBodyParam");
        ((Map)methodMap).put("deleteBody", "RxHttpBodyParam");
        ((Map)methodMap).put("postForm", "RxHttpFormParam");
        ((Map)methodMap).put("putForm", "RxHttpFormParam");
        ((Map)methodMap).put("patchForm", "RxHttpFormParam");
        ((Map)methodMap).put("deleteForm", "RxHttpFormParam");
        ((Map)methodMap).put("postJson", "RxHttpJsonParam");
        ((Map)methodMap).put("putJson", "RxHttpJsonParam");
        ((Map)methodMap).put("patchJson", "RxHttpJsonParam");
        ((Map)methodMap).put("deleteJson", "RxHttpJsonParam");
        ((Map)methodMap).put("postJsonArray", "RxHttpJsonArrayParam");
        ((Map)methodMap).put("putJsonArray", "RxHttpJsonArrayParam");
        ((Map)methodMap).put("patchJsonArray", "RxHttpJsonArrayParam");
        ((Map)methodMap).put("deleteJsonArray", "RxHttpJsonArrayParam");
        Map $this$forEach$iv = methodMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            bl = false;
            key = (String)entry.getKey();
            String value = (String)entry.getValue();
            ClassName returnType = ConstantsKt.getRxhttpClass().peerClass(value);
            Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
            modifierArray = MethodSpec.methodBuilder((String)key).addModifiers(modifierArray).addParameter(UtilsKt.getSTRING(), "url", new Modifier[0]).addParameter((TypeName)arrayObject, "formatArgs", new Modifier[0]).varargs().addStatement("return wrapper(RxHttp." + key + "(url, formatArgs))", new Object[0]).returns((TypeName)returnType).build();
            $this$generateRequestFunList_u24lambda_u246_u24lambda_u245 = modifierArray;
            boolean bl2 = false;
            methodList.add((MethodSpec)$this$generateRequestFunList_u24lambda_u246_u24lambda_u245);
        }
        $this$forEach$iv = this.elementMap;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            TypeName typeName;
            TypeVariableName[] $this$mapTo$iv$iv;
            entry = element$iv = iterator.next();
            bl = false;
            key = (String)entry.getKey();
            TypeElement typeElement = (TypeElement)entry.getValue();
            List<? extends TypeParameterElement> list = typeElement.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameters(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            $this$generateRequestFunList_u24lambda_u246_u24lambda_u245 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void it;
                TypeParameterElement typeParameterElement = (TypeParameterElement)t;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(TypeVariableName.get((TypeParameterElement)it));
            }
            List rxHttpTypeNames = (List)destination$iv$iv;
            ClassName rxHttpParamName = ConstantsKt.getRxhttpClass().peerClass("RxHttp" + typeElement.getSimpleName());
            if (!((Collection)rxHttpTypeNames).isEmpty()) {
                Intrinsics.checkNotNull((Object)rxHttpParamName);
                Collection $this$toTypedArray$iv = rxHttpTypeNames;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$mapTo$iv$iv = thisCollection$iv.toArray(new TypeVariableName[0]);
                typeName = (TypeName)UtilsKt.parameterizedBy(rxHttpParamName, (TypeName[])Arrays.copyOf($this$mapTo$iv$iv, $this$mapTo$iv$iv.length));
            } else {
                typeName = (TypeName)rxHttpParamName;
            }
            TypeName methodReturnType = typeName;
            Iterable $this$forEach$iv2 = this.getConstructorFun(typeElement);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                void $this$mapTo$iv;
                ExecutableElement executableElement = (ExecutableElement)element$iv2;
                boolean bl4 = false;
                List<? extends VariableElement> list2 = executableElement.getParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
                Iterable bl3 = list2;
                Collection destination$iv = new ArrayList();
                boolean $i$f$mapTo2 = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    VariableElement variableElement = (VariableElement)item$iv;
                    Collection collection = destination$iv;
                    boolean bl5 = false;
                    collection.add(ParameterSpec.get((VariableElement)it));
                }
                ArrayList parameterSpecs = (ArrayList)destination$iv;
                ParameterSpec parameterSpec = (ParameterSpec)CollectionsKt.firstOrNull((List)parameterSpecs);
                boolean firstParamIsStringType = Intrinsics.areEqual((Object)(parameterSpec != null ? parameterSpec.type : null), (Object)UtilsKt.getSTRING());
                if (firstParamIsStringType) {
                    parameterSpecs.add(ParameterSpec.builder((TypeName)((TypeName)arrayObject), (String)"formatArgs", (Modifier[])new Modifier[0]).build());
                }
                String prefix = "return wrapper(RxHttp." + key + '(';
                String postfix = "))";
                String methodBody = UtilsKt.toParamNames(parameterSpecs, prefix, postfix);
                Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
                Modifier[] $this$generateRequestFunList_u24lambda_u2411_u24lambda_u2410_u24lambda_u249 = modifierArray = MethodSpec.methodBuilder((String)key).addModifiers(modifierArray).addTypeVariables((Iterable)rxHttpTypeNames).addParameters((Iterable)parameterSpecs).varargs(firstParamIsStringType).addStatement(methodBody, new Object[0]).returns(methodReturnType).build();
                boolean bl6 = false;
                methodList.add((MethodSpec)$this$generateRequestFunList_u24lambda_u2411_u24lambda_u2410_u24lambda_u249);
            }
        }
        return methodList;
    }

    private final List<ExecutableElement> getConstructorFun(TypeElement typeElement) {
        ArrayList<Element> funList = new ArrayList<Element>();
        List<? extends Element> list = typeElement.getEnclosedElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getEnclosedElements(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            if (!(it instanceof ExecutableElement) || ((ExecutableElement)it).getKind() != ElementKind.CONSTRUCTOR || !((ExecutableElement)it).getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            funList.add(it);
        }
        return funList;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/rxhttp/compiler/kapt/RxHttpWrapper$Wrapper;", "", "<init>", "()V", "domainName", "", "getDomainName", "()Ljava/lang/String;", "setDomainName", "(Ljava/lang/String;)V", "converterName", "getConverterName", "setConverterName", "okClientName", "getOkClientName", "setOkClientName", "rxhttp-compiler"})
    public static final class Wrapper {
        @Nullable
        private String domainName;
        @Nullable
        private String converterName;
        @Nullable
        private String okClientName;

        @Nullable
        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(@Nullable String string) {
            this.domainName = string;
        }

        @Nullable
        public final String getConverterName() {
            return this.converterName;
        }

        public final void setConverterName(@Nullable String string) {
            this.converterName = string;
        }

        @Nullable
        public final String getOkClientName() {
            return this.okClientName;
        }

        public final void setOkClientName(@Nullable String string) {
            this.okClientName = string;
        }
    }
}

