/*
 * Decompiled with CFR 0.152.
 */
package com.levylin.lib.net.loader;

import com.levylin.lib.net.INetworkView;
import com.levylin.lib.net.listener.OnLoadListener;
import com.levylin.lib.net.loader.helper.intf.ILoadStateHelper;
import com.levylin.lib.net.loader.helper.intf.IRefreshViewHelper;
import com.levylin.lib.net.loader.helper.listener.OnRefreshListener;
import com.levylin.lib.net.loader.helper.listener.OnReloadListener;
import com.levylin.lib.net.loader.listener.OnLoadFailureListener;
import com.levylin.lib.net.loader.listener.OnLoadSuccessListener;
import com.levylin.lib.net.loader.model.Model;
import io.reactivex.disposables.Disposable;

public class DataLoader<T>
implements OnRefreshListener,
OnReloadListener {
    private Model<T> model;
    ILoadStateHelper mLoadStateViewHelper;
    IRefreshViewHelper mRefreshViewHelper;
    OnLoadSuccessListener<T> onLoadSuccessListener;
    OnLoadFailureListener onLoadFailureListener;
    Disposable mSubscription;
    private INetworkView view;

    public DataLoader(INetworkView view, Model<T> model) {
        this.view = view;
        this.model = model;
        this.view.setDataLoader(this);
    }

    public void setLoadStateHelper(ILoadStateHelper helper) {
        this.mLoadStateViewHelper = helper;
        this.mLoadStateViewHelper.setReloadListener(this);
    }

    public void setRefreshViewHelper(IRefreshViewHelper helper) {
        this.mRefreshViewHelper = helper;
        this.mRefreshViewHelper.setOnRefreshListener(this);
    }

    public void setOnLoadSuccessListener(OnLoadSuccessListener<T> listener) {
        this.onLoadSuccessListener = listener;
    }

    public void setOnLoadFailureListener(OnLoadFailureListener listener) {
        this.onLoadFailureListener = listener;
    }

    public void load() {
        this.cancel();
        this.mSubscription = this.model.load(new OnLoadListener<T>(){

            @Override
            public void onStart() {
                DataLoader.this.showLoading();
            }

            @Override
            public void onSuccess(T response) {
                DataLoader.this.showContent(response);
                DataLoader.this.model.setManualRefresh(false);
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
                DataLoader.this.showError(throwable);
                DataLoader.this.model.setManualRefresh(false);
            }
        });
    }

    public void manualRefresh() {
        this.model.setManualRefresh(true);
        this.onRefresh();
    }

    @Override
    public void onRefresh() {
        this.model.preRefresh();
        this.load();
    }

    @Override
    public void onReLoad() {
        this.model.preReLoad();
        this.load();
    }

    public void cancel() {
        if (this.mSubscription == null) {
            return;
        }
        if (this.mSubscription.isDisposed()) {
            return;
        }
        this.mSubscription.dispose();
        this.mSubscription = null;
    }

    private void showLoading() {
        if (this.isRefreshing()) {
            return;
        }
        if (this.mLoadStateViewHelper == null) {
            return;
        }
        this.mLoadStateViewHelper.showLoading();
    }

    protected boolean isRefreshing() {
        return this.mRefreshViewHelper != null && this.mRefreshViewHelper.isRefreshing() || this.model.isManualRefresh();
    }

    private void showContent(T response) {
        if (this.isRefreshing() && this.mRefreshViewHelper != null) {
            this.mRefreshViewHelper.refreshComplete(true);
        }
        this.model.setData(this.isRefreshing(), response);
        if (this.mLoadStateViewHelper != null) {
            if (this.model.isEmpty()) {
                this.mLoadStateViewHelper.showEmpty();
            } else {
                this.mLoadStateViewHelper.showContent();
            }
        }
        if (this.onLoadSuccessListener != null) {
            this.onLoadSuccessListener.onSuccess(this.isRefreshing(), response);
        }
    }

    private void showError(Throwable t) {
        if (this.isRefreshing()) {
            if (this.mRefreshViewHelper != null) {
                this.mRefreshViewHelper.refreshComplete(false);
            }
        } else if (this.mLoadStateViewHelper != null) {
            this.mLoadStateViewHelper.showError(this.model.isEmpty(), t);
        }
        if (this.onLoadFailureListener != null) {
            this.onLoadFailureListener.onFailure(this.isRefreshing(), t);
        }
    }

    public void onDestroy() {
        this.cancel();
        this.view = null;
        this.mLoadStateViewHelper = null;
        this.mRefreshViewHelper = null;
    }
}

