/*
 * Decompiled with CFR 0.152.
 */
package com.levylin.loader;

import android.util.Log;
import com.levylin.loader.DataLoader;
import com.levylin.loader.helper.intf.IListViewHelper;
import com.levylin.loader.helper.listener.OnLoadMoreListener;
import com.levylin.loader.helper.listener.OnReloadListener;
import com.levylin.loader.listener.OnLoadListener;
import com.levylin.loader.model.IListModel;

public class ListLoader<INFO, ITEM>
extends DataLoader<INFO> {
    private boolean debug = false;
    private IListModel<INFO, ITEM> model;
    private IListViewHelper mListViewHelper;

    public ListLoader(IListModel<INFO, ITEM> listModel) {
        super(listModel);
        this.model = listModel;
    }

    public void setListViewHelper(IListViewHelper helper) {
        this.mListViewHelper = helper;
        this.mListViewHelper.setOnLoadMoreListener(new OnLoadMoreListener(){

            @Override
            public void onLoadMore() {
                ListLoader.this.model.preLoadNext();
                ListLoader.this.load();
            }
        });
        this.mListViewHelper.setOnReLoadMoreListener(new OnReloadListener(){

            @Override
            public void onReLoad() {
                ListLoader.this.model.preReLoad();
                ListLoader.this.load();
            }
        });
    }

    @Override
    public void load() {
        this.cancel();
        this.model.load(new OnLoadListener<INFO>(){

            @Override
            public void onStart() {
                ListLoader.this.showLoading();
            }

            @Override
            public void onSuccess(INFO response) {
                ListLoader.this.showContent(response);
                ListLoader.this.isSilenceRefresh = false;
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
                ListLoader.this.showError(throwable);
                ListLoader.this.isSilenceRefresh = false;
            }
        });
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void showLoading() {
        this.log("showLoading...");
        if (this.isRefreshing()) {
            return;
        }
        if (this.isLoadingMore()) {
            return;
        }
        if (this.mLoadStateViewHelper == null) {
            return;
        }
        this.mLoadStateViewHelper.showLoading();
    }

    private boolean isLoadingMore() {
        return this.mListViewHelper != null && this.mListViewHelper.isLoadingMore();
    }

    private void showContent(INFO responseModel) {
        this.log("showContent:responseModel=" + responseModel);
        this.model.setData(this.isRefreshing(), responseModel);
        if (this.isRefreshing() && this.mRefreshViewHelper != null) {
            this.mRefreshViewHelper.refreshComplete(true);
        }
        if (this.mListViewHelper != null) {
            this.log("oldCount:" + this.model.getOldCount() + ",newAddCount:" + this.model.getNewAddCount());
            this.mListViewHelper.notifyAdapter(this.model.getOldCount(), this.model.getNewAddCount());
        }
        this.setLoadMoreState(responseModel);
        if (this.mLoadStateViewHelper != null) {
            if (this.model.isEmpty()) {
                this.mLoadStateViewHelper.showEmpty();
            } else {
                this.mLoadStateViewHelper.showContent();
            }
        }
        if (this.onLoadSuccessListener != null) {
            this.onLoadSuccessListener.onSuccess(this.isRefreshing(), responseModel);
        }
    }

    private void setLoadMoreState(INFO response) {
        if (this.mListViewHelper == null) {
            return;
        }
        if (this.model.hasNext()) {
            this.mListViewHelper.showLoadMoreIdle();
        } else {
            this.mListViewHelper.showLoadMoreNoMore();
        }
    }

    private void showError(Throwable t) {
        this.log("showError:t=" + t);
        if (this.isRefreshing() && this.mRefreshViewHelper != null) {
            this.mRefreshViewHelper.refreshComplete(false);
        } else if (this.isLoadingMore()) {
            this.mListViewHelper.showLoadMoreError();
        } else if (this.mLoadStateViewHelper != null) {
            this.mLoadStateViewHelper.showError(this.model.isEmpty(), t);
        }
        if (this.onLoadFailureListener != null) {
            this.onLoadFailureListener.onFailure(this.isRefreshing(), t);
        }
    }

    @Override
    public void detachView() {
        super.detachView();
        this.mListViewHelper = null;
    }

    private void log(String content) {
        if (this.debug) {
            Log.i((String)"ListLoader", (String)content);
        }
    }
}

