/*
 * Decompiled with CFR 0.152.
 */
package linc.com.amplituda;

import java.util.LinkedHashSet;
import linc.com.amplituda.exceptions.AmplitudaException;
import linc.com.amplituda.exceptions.allocation.CodecContextAllocationException;
import linc.com.amplituda.exceptions.allocation.FrameAllocationException;
import linc.com.amplituda.exceptions.allocation.PacketAllocationException;
import linc.com.amplituda.exceptions.io.FileOpenException;
import linc.com.amplituda.exceptions.processing.CodecNotFoundException;
import linc.com.amplituda.exceptions.processing.CodecOpenException;
import linc.com.amplituda.exceptions.processing.CodecParametersException;
import linc.com.amplituda.exceptions.processing.DecodingException;
import linc.com.amplituda.exceptions.processing.PacketSubmittingException;
import linc.com.amplituda.exceptions.processing.SampleOutOfBoundsException;
import linc.com.amplituda.exceptions.processing.StreamInformationNotFoundException;
import linc.com.amplituda.exceptions.processing.StreamNotFoundException;
import linc.com.amplituda.exceptions.processing.UnsupportedSampleFormatException;

final class AmplitudaResultJNI {
    private double duration;
    private String amplitudes;
    private String errors;

    AmplitudaResultJNI() {
    }

    long getDurationMillis() {
        return (long)(this.duration * 1000.0);
    }

    String getAmplitudes() {
        return this.amplitudes;
    }

    LinkedHashSet<AmplitudaException> getErrors() {
        LinkedHashSet<AmplitudaException> errors = new LinkedHashSet<AmplitudaException>();
        for (String error : this.errors.split(" ")) {
            if (error.isEmpty()) continue;
            errors.add(this.getExceptionFromCode(Integer.parseInt(error)));
        }
        return errors;
    }

    private AmplitudaException getExceptionFromCode(int code) {
        switch (code) {
            case 10: {
                return new FrameAllocationException();
            }
            case 11: {
                return new PacketAllocationException();
            }
            case 12: {
                return new CodecContextAllocationException();
            }
            case 20: {
                return new FileOpenException();
            }
            case 30: {
                return new CodecNotFoundException();
            }
            case 31: {
                return new StreamNotFoundException();
            }
            case 32: {
                return new StreamInformationNotFoundException();
            }
            case 33: {
                return new CodecParametersException();
            }
            case 34: {
                return new PacketSubmittingException();
            }
            case 35: {
                return new CodecOpenException();
            }
            case 36: {
                return new UnsupportedSampleFormatException();
            }
            case 37: {
                return new DecodingException();
            }
            case 40: {
                return new SampleOutOfBoundsException();
            }
        }
        return new AmplitudaException();
    }
}

