/*
 * Decompiled with CFR 0.152.
 */
package linc.com.amplituda;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import linc.com.amplituda.InputAudio;

public final class AmplitudaResult<T> {
    private final String amplitudes;
    private final InputAudio<T> inputAudio;

    AmplitudaResult(String amplitudes, InputAudio<T> inputAudio) {
        this.amplitudes = amplitudes;
        this.inputAudio = inputAudio;
    }

    public T getAudioSource() {
        return this.inputAudio.getSource();
    }

    public long getAudioDuration(DurationUnit unit) {
        if (unit == DurationUnit.SECONDS) {
            return this.inputAudio.getDuration() / 1000L;
        }
        return this.inputAudio.getDuration();
    }

    public InputAudio.Type getInputAudioType() {
        return this.inputAudio.getType();
    }

    public List<Integer> amplitudesAsList() {
        if (this.amplitudes == null || this.amplitudes.isEmpty()) {
            return Collections.emptyList();
        }
        String[] log = this.amplitudes.split("\n");
        ArrayList<Integer> amplitudes = new ArrayList<Integer>();
        for (String amplitude : log) {
            if (amplitude.isEmpty()) break;
            amplitudes.add(Integer.valueOf(amplitude));
        }
        return amplitudes;
    }

    public String amplitudesAsJson() {
        if (this.amplitudes == null || this.amplitudes.isEmpty()) {
            return "";
        }
        return Arrays.toString(this.amplitudesAsList().toArray());
    }

    public String amplitudesAsSequence(SequenceFormat format) {
        if (this.amplitudes == null || this.amplitudes.isEmpty()) {
            return "";
        }
        return this.amplitudesAsSequence(format, " ");
    }

    public String amplitudesAsSequence(SequenceFormat format, String singleLineDelimiter) {
        if (this.amplitudes == null || this.amplitudes.isEmpty()) {
            return "";
        }
        if (format == SequenceFormat.SINGLE_LINE) {
            return this.amplitudesToSingleLineSequence(this.amplitudes, singleLineDelimiter);
        }
        return this.amplitudes;
    }

    public List<Integer> amplitudesForSecond(int second) {
        List<Integer> data = this.amplitudesAsList();
        int duration = (int)this.getAudioDuration(DurationUnit.SECONDS);
        if (second > duration || duration == 0) {
            return Collections.emptyList();
        }
        int aps = data.size() / duration;
        int index = second * data.size() / duration;
        ArrayList<Integer> amplitudesForSecond = new ArrayList<Integer>();
        for (int i = index; i > index - aps && i >= 0 && i < data.size(); --i) {
            amplitudesForSecond.add(data.get(i));
        }
        Collections.reverse(amplitudesForSecond);
        return amplitudesForSecond;
    }

    private String amplitudesToSingleLineSequence(String amplitudes, String delimiter) {
        Object[] log = amplitudes.split("\n");
        return TextUtils.join((CharSequence)delimiter, (Object[])log);
    }

    public static enum SequenceFormat {
        SINGLE_LINE,
        NEW_LINE;

    }

    public static enum DurationUnit {
        SECONDS,
        MILLIS;

    }
}

