/*
 * Decompiled with CFR 0.152.
 */
package linc.com.amplituda;

import android.content.Context;
import android.webkit.URLUtil;
import java.io.File;
import java.io.InputStream;
import linc.com.amplituda.AmplitudaLogger;
import linc.com.amplituda.AmplitudaProcessingOutput;
import linc.com.amplituda.AmplitudaProgressListener;
import linc.com.amplituda.AmplitudaResultJNI;
import linc.com.amplituda.Compress;
import linc.com.amplituda.FileManager;
import linc.com.amplituda.InputAudio;
import linc.com.amplituda.ProgressOperation;
import linc.com.amplituda.exceptions.AmplitudaException;
import linc.com.amplituda.exceptions.io.FileNotFoundException;
import linc.com.amplituda.exceptions.io.InvalidAudioUrlException;
import linc.com.amplituda.exceptions.io.InvalidRawResourceException;

public final class Amplituda {
    private final FileManager fileManager;

    public Amplituda(Context context) {
        this.fileManager = new FileManager(context);
    }

    public Amplituda setLogConfig(int priority, boolean enable) {
        AmplitudaLogger.enable(enable);
        AmplitudaLogger.priority(priority);
        return this;
    }

    public AmplitudaProcessingOutput<File> processAudio(File audio) {
        return this.processAudio(audio, null, null);
    }

    public AmplitudaProcessingOutput<String> processAudio(String audio) {
        return this.processAudio(audio, null, null);
    }

    public AmplitudaProcessingOutput<Integer> processAudio(int audio) {
        return this.processAudio(audio, null, null);
    }

    public AmplitudaProcessingOutput<InputStream> processAudio(InputStream audio) {
        return this.processAudio(audio, null, null);
    }

    public AmplitudaProcessingOutput<byte[]> processAudio(byte[] audio) {
        return this.processAudio(audio, null, null);
    }

    public AmplitudaProcessingOutput<File> processAudio(File audio, Compress compressParams) {
        return this.processAudio(audio, compressParams, null);
    }

    public AmplitudaProcessingOutput<String> processAudio(String audio, Compress compressParams) {
        return this.processAudio(audio, compressParams, null);
    }

    public AmplitudaProcessingOutput<Integer> processAudio(int audio, Compress compressParams) {
        return this.processAudio(audio, compressParams, null);
    }

    public AmplitudaProcessingOutput<InputStream> processAudio(InputStream audio, Compress compressParams) {
        return this.processAudio(audio, compressParams, null);
    }

    public AmplitudaProcessingOutput<byte[]> processAudio(byte[] audio, Compress compressParams) {
        return this.processAudio(audio, compressParams, null);
    }

    public AmplitudaProcessingOutput<File> processAudio(File audio, AmplitudaProgressListener listener) {
        return this.processAudio(audio, null, listener);
    }

    public AmplitudaProcessingOutput<String> processAudio(String audio, AmplitudaProgressListener listener) {
        return this.processAudio(audio, null, listener);
    }

    public AmplitudaProcessingOutput<Integer> processAudio(int audio, AmplitudaProgressListener listener) {
        return this.processAudio(audio, null, listener);
    }

    public AmplitudaProcessingOutput<InputStream> processAudio(InputStream audio, AmplitudaProgressListener listener) {
        return this.processAudio(audio, null, listener);
    }

    public AmplitudaProcessingOutput<byte[]> processAudio(byte[] audio, AmplitudaProgressListener listener) {
        return this.processAudio(audio, null, listener);
    }

    public AmplitudaProcessingOutput<File> processAudio(File audio, Compress compress, AmplitudaProgressListener listener) {
        this.startProgress(listener);
        InputAudio<File> inputAudio = new InputAudio<File>(audio, InputAudio.Type.FILE);
        try {
            return new AmplitudaProcessingOutput<File>(this.processFileJNI(audio, inputAudio, this.getValidCompression(compress), listener), inputAudio);
        }
        catch (AmplitudaException exception) {
            return this.errorOutput(exception, inputAudio, listener);
        }
    }

    public AmplitudaProcessingOutput<String> processAudio(String audio, Compress compress, AmplitudaProgressListener listener) {
        this.startProgress(listener);
        InputAudio<String> inputAudio = new InputAudio<String>(audio);
        try {
            if (!URLUtil.isValidUrl((String)audio)) {
                inputAudio.setType(InputAudio.Type.PATH);
                return new AmplitudaProcessingOutput<String>(this.processFileJNI(new File(audio), inputAudio, this.getValidCompression(compress), listener), inputAudio);
            }
            inputAudio.setType(InputAudio.Type.URL);
            long startTime = System.currentTimeMillis();
            this.updateProgressOperation(listener, ProgressOperation.DOWNLOADING);
            File tempAudio = this.fileManager.getUrlFile(audio, listener);
            if (tempAudio == null) {
                return this.errorOutput(new InvalidAudioUrlException(), inputAudio, listener);
            }
            AmplitudaLogger.logOperationTime("Preparing", startTime);
            AmplitudaResultJNI result = this.processFileJNI(tempAudio, inputAudio, this.getValidCompression(compress), listener);
            this.fileManager.deleteFile(tempAudio);
            return new AmplitudaProcessingOutput<String>(result, inputAudio);
        }
        catch (AmplitudaException exception) {
            return this.errorOutput(exception, inputAudio, listener);
        }
    }

    public AmplitudaProcessingOutput<Integer> processAudio(int audio, Compress compress, AmplitudaProgressListener listener) {
        this.startProgress(listener);
        InputAudio<Integer> inputAudio = new InputAudio<Integer>(Integer.valueOf(audio), InputAudio.Type.RESOURCE);
        long startTime = System.currentTimeMillis();
        this.updateProgressOperation(listener, ProgressOperation.DECODING);
        File tempAudio = this.fileManager.getRawFile(audio, listener);
        if (tempAudio == null) {
            return this.errorOutput(new InvalidRawResourceException(), inputAudio, listener);
        }
        AmplitudaLogger.logOperationTime("Preparing", startTime);
        try {
            AmplitudaResultJNI result = this.processFileJNI(tempAudio, inputAudio, this.getValidCompression(compress), listener);
            this.fileManager.deleteFile(tempAudio);
            return new AmplitudaProcessingOutput<Integer>(result, inputAudio);
        }
        catch (AmplitudaException exception) {
            return this.errorOutput(exception, inputAudio, listener);
        }
    }

    public AmplitudaProcessingOutput<InputStream> processAudio(InputStream audio, Compress compress, AmplitudaProgressListener listener) {
        this.startProgress(listener);
        InputAudio<InputStream> inputAudio = new InputAudio<InputStream>(audio, InputAudio.Type.INPUT_STREAM);
        try {
            this.updateProgressOperation(listener, ProgressOperation.DECODING);
            File audioFile = this.fileManager.getUriFile(audio, listener);
            AmplitudaProcessingOutput<InputStream> output = new AmplitudaProcessingOutput<InputStream>(this.processFileJNI(audioFile, inputAudio, this.getValidCompression(compress), listener), inputAudio);
            this.fileManager.deleteFile(audioFile);
            return output;
        }
        catch (AmplitudaException exception) {
            return this.errorOutput(exception, inputAudio, listener);
        }
    }

    public AmplitudaProcessingOutput<byte[]> processAudio(byte[] audio, Compress compress, AmplitudaProgressListener listener) {
        this.startProgress(listener);
        InputAudio<byte[]> inputAudio = new InputAudio<byte[]>(audio, InputAudio.Type.BYTE_ARRAY);
        try {
            this.updateProgressOperation(listener, ProgressOperation.DECODING);
            File audioFile = this.fileManager.getByteArrayFile(audio, listener);
            AmplitudaProcessingOutput<byte[]> output = new AmplitudaProcessingOutput<byte[]>(this.processFileJNI(audioFile, inputAudio, this.getValidCompression(compress), listener), inputAudio);
            this.fileManager.deleteFile(audioFile);
            return output;
        }
        catch (AmplitudaException exception) {
            return this.errorOutput(exception, inputAudio, listener);
        }
    }

    private <T> AmplitudaResultJNI processFileJNI(File audio, InputAudio<T> inputAudio, Compress compress, AmplitudaProgressListener listener) throws AmplitudaException {
        if (!audio.exists()) {
            throw new FileNotFoundException();
        }
        long startTime = System.currentTimeMillis();
        this.updateProgressOperation(listener, ProgressOperation.PROCESSING);
        AmplitudaResultJNI result = this.amplitudesFromAudioJNI(audio.getPath(), compress.getType(), compress.getPreferredSamplesPerSecond(), listener);
        inputAudio.setDuration(result.getDurationMillis());
        AmplitudaLogger.logOperationTime("Processing", startTime);
        this.stopProgress(listener);
        return result;
    }

    private Compress getValidCompression(Compress compress) {
        if (compress == null || compress.isNotValid()) {
            return Compress.withParams(1, 1);
        }
        return compress;
    }

    private synchronized <T> AmplitudaProcessingOutput<T> errorOutput(AmplitudaException exception, InputAudio<T> inputAudio, AmplitudaProgressListener listener) {
        this.stopProgress(listener);
        return new AmplitudaProcessingOutput<T>(exception, inputAudio);
    }

    private synchronized void stopProgress(AmplitudaProgressListener listener) {
        if (listener != null) {
            listener.onStopProgress();
        }
    }

    private synchronized void startProgress(AmplitudaProgressListener listener) {
        if (listener != null) {
            listener.onStartProgress();
        }
    }

    private synchronized void updateProgressOperation(AmplitudaProgressListener listener, ProgressOperation operation) {
        if (listener != null) {
            listener.onOperationChanged(operation);
        }
    }

    native AmplitudaResultJNI amplitudesFromAudioJNI(String var1, int var2, int var3, AmplitudaProgressListener var4);

    static {
        System.loadLibrary("native-lib");
    }
}

