/*
 * Decompiled with CFR 0.152.
 */
package me.leefeng.promptlibrary;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import me.leefeng.promptlibrary.Builder;
import me.leefeng.promptlibrary.OnAdClickListener;
import me.leefeng.promptlibrary.PromptButton;
import me.leefeng.promptlibrary.PromptView;
import me.leefeng.promptlibrary.R;

public class PromptDialog {
    private final String TAG = "PromptDialog";
    private InputMethodManager inputmanger;
    private Animation outAnim;
    private Animation inAnim;
    private PromptView promptView;
    private ViewGroup decorView;
    private ValueAnimator dissmissAnim;
    private boolean dissmissAnimCancle;
    private boolean outAnimRunning;
    public static long viewAnimDuration = 300L;
    private boolean isShowing;
    private AnimationSet inSheetAnim;
    private AlphaAnimation outSheetAnim;
    private AnimationSet inDefaultAnim;
    private AnimationSet outDefaultAnim;
    private OnAdClickListener adListener;

    public void setViewAnimDuration(long viewAnimDuration) {
        PromptDialog.viewAnimDuration = viewAnimDuration;
    }

    public long getViewAnimDuration() {
        return viewAnimDuration;
    }

    public void onDetach() {
        this.isShowing = false;
    }

    public PromptDialog(Activity context) {
        this(Builder.getDefaultBuilder(), context);
    }

    public PromptDialog(Builder builder, Activity context) {
        this.decorView = (ViewGroup)context.getWindow().getDecorView().findViewById(0x1020002);
        this.promptView = new PromptView(context, builder, this);
        this.initAnim(context.getResources().getDisplayMetrics().widthPixels, context.getResources().getDisplayMetrics().heightPixels);
        this.inputmanger = (InputMethodManager)context.getSystemService("input_method");
    }

    private void initAnim(int widthPixels, int heightPixels) {
        this.inDefaultAnim = new AnimationSet(true);
        ScaleAnimation scaleAnimation = new ScaleAnimation(2.0f, 1.0f, 2.0f, 1.0f, (float)widthPixels * 0.5f, (float)heightPixels * 0.45f);
        this.inDefaultAnim.addAnimation((Animation)scaleAnimation);
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        this.inDefaultAnim.addAnimation((Animation)alphaAnimation);
        this.inDefaultAnim.setDuration(viewAnimDuration);
        this.inDefaultAnim.setFillAfter(false);
        this.inDefaultAnim.setInterpolator((Interpolator)new DecelerateInterpolator());
        this.outDefaultAnim = new AnimationSet(true);
        scaleAnimation = new ScaleAnimation(1.0f, 2.0f, 1.0f, 2.0f, (float)widthPixels * 0.5f, (float)heightPixels * 0.45f);
        alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        alphaAnimation.setDuration(200L);
        this.outDefaultAnim.addAnimation((Animation)scaleAnimation);
        this.outDefaultAnim.addAnimation((Animation)alphaAnimation);
        this.outDefaultAnim.setDuration(viewAnimDuration);
        this.outDefaultAnim.setFillAfter(false);
        this.outDefaultAnim.setInterpolator((Interpolator)new AccelerateInterpolator());
        alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        scaleAnimation = new ScaleAnimation(1.0f, 1.0f, 1.0f, 1.0f, (float)widthPixels * 0.5f, (float)heightPixels * 0.5f);
        this.inSheetAnim = new AnimationSet(true);
        this.inSheetAnim.addAnimation((Animation)alphaAnimation);
        this.inSheetAnim.addAnimation((Animation)scaleAnimation);
        this.inSheetAnim.setDuration(viewAnimDuration);
        this.inSheetAnim.setFillAfter(false);
        this.outSheetAnim = new AlphaAnimation(1.0f, 0.0f);
        this.outSheetAnim.setDuration(viewAnimDuration);
        this.outSheetAnim.setFillAfter(false);
    }

    public void setOutAnim(Animation outAnim) {
        this.outAnim = outAnim;
    }

    public void setInAnim(Animation inAnim) {
        this.inAnim = inAnim;
    }

    public void dismissImmediately() {
        if (this.isShowing && !this.outAnimRunning) {
            this.decorView.removeView((View)this.promptView);
            this.isShowing = false;
        }
    }

    public void dismiss() {
        if (this.isShowing && !this.outAnimRunning) {
            if (this.promptView.getBuilder().withAnim && this.outAnim != null) {
                if (this.promptView.getCurrentType() == 102) {
                    this.outAnim.setStartOffset(this.promptView.getBuilder().loadingDuration);
                } else {
                    this.outAnim.setStartOffset(0L);
                }
                this.promptView.dismiss();
                this.promptView.startAnimation(this.outAnim);
                this.outAnim.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                        PromptDialog.this.outAnimRunning = true;
                    }

                    public void onAnimationEnd(Animation animation) {
                        PromptDialog.this.decorView.removeView((View)PromptDialog.this.promptView);
                        PromptDialog.this.outAnimRunning = false;
                        PromptDialog.this.isShowing = false;
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }
                });
            } else {
                this.dismissImmediately();
            }
        }
    }

    public void showError(String msg) {
        this.showError(msg, true);
    }

    public void showError(String msg, boolean withAnim) {
        this.showSomthing(R.drawable.ic_prompt_error, 103, msg, withAnim);
    }

    public void showInfo(String msg) {
        this.showInfo(msg, true);
    }

    public void showInfo(String msg, boolean withAnim) {
        this.showSomthing(R.drawable.ic_prompt_info, 105, msg, withAnim);
    }

    public void showWarn(String msg) {
        this.showWarn(msg, true);
    }

    public void showWarn(String msg, boolean withAnim) {
        this.showSomthing(R.drawable.ic_prompt_warn, 106, msg, withAnim);
    }

    public void showSuccess(String msg) {
        this.showSuccess(msg, true);
    }

    public void showSuccess(String msg, boolean withAnim) {
        this.showSomthing(R.drawable.ic_prompt_success, 101, msg, withAnim);
    }

    public void showSuccessDelay(final String msg, long delay) {
        this.decorView.postDelayed(new Runnable(){

            @Override
            public void run() {
                PromptDialog.this.showSuccess(msg);
            }
        }, delay);
    }

    public void showCustom(int icon, String msg) {
        this.showCustom(icon, msg, true);
    }

    public void showCustom(int icon, String msg, boolean withAnim) {
        this.showSomthing(icon, 108, msg, withAnim);
    }

    private void showSomthing(int icon, int promptError, String msg, boolean withAnim) {
        this.inAnim = this.inDefaultAnim;
        this.outAnim = this.outDefaultAnim;
        Builder builder = Builder.getDefaultBuilder();
        builder.text(msg);
        builder.icon(icon);
        this.closeInput();
        this.checkLoadView(withAnim);
        if (this.isShowing) {
            this.promptView.setBuilder(builder);
            this.promptView.showSomthing(promptError);
            this.dissmissAni(false);
        }
    }

    public void showWarnAlert(String text, PromptButton button) {
        this.showWarnAlert(text, button, false);
    }

    public void showWarnAlert(String text, PromptButton button, boolean withAnim) {
        this.showAlert(text, withAnim, button);
    }

    public void showWarnAlert(String text, PromptButton button1, PromptButton button2, boolean withAnim) {
        this.showAlert(text, withAnim, button1, button2);
    }

    public void showWarnAlert(String text, PromptButton button1, PromptButton button2) {
        this.showWarnAlert(text, button1, button2, true);
    }

    public void showAlertSheet(String title, boolean withAnim, PromptButton ... button) {
        this.showAlert(title, withAnim, button);
    }

    private void showAlert(String text, boolean withAnim, PromptButton ... button) {
        if (button.length > 2) {
            Log.i((String)"PromptDialog", (String)("showAlert: " + this.promptView.getScrollY()));
            this.inAnim = this.inSheetAnim;
            this.outAnim = this.outSheetAnim;
        } else {
            this.inAnim = this.inDefaultAnim;
            this.outAnim = this.outDefaultAnim;
        }
        Builder builder = Builder.getAlertDefaultBuilder();
        builder.text(text);
        builder.icon(R.drawable.ic_prompt_alert_warn);
        this.closeInput();
        this.promptView.setBuilder(builder);
        this.checkLoadView(withAnim);
        this.promptView.showSomthingAlert(button);
        this.dissmissAni(true);
    }

    public ImageView showAd(boolean withAnim, OnAdClickListener listener) {
        this.adListener = listener;
        this.inAnim = this.inSheetAnim;
        this.outAnim = this.outSheetAnim;
        Builder builder = Builder.getDefaultBuilder();
        builder.touchAble(false);
        this.closeInput();
        this.checkLoadView(withAnim);
        this.promptView.setBuilder(builder);
        this.promptView.showAd();
        this.dissmissAni(true);
        return this.promptView;
    }

    public void showLoading(String msg, boolean withAnim) {
        this.inAnim = this.inDefaultAnim;
        this.outAnim = this.outDefaultAnim;
        if (this.promptView.getCurrentType() != 102) {
            Builder builder = Builder.getDefaultBuilder();
            builder.icon(R.drawable.ic_prompt_loading);
            builder.text(msg);
            this.promptView.setBuilder(builder);
            this.closeInput();
            this.checkLoadView(withAnim);
            this.promptView.showLoading();
            this.dissmissAni(true);
        } else {
            this.promptView.setText(msg);
        }
    }

    public void showLoading(String msg) {
        this.showLoading(msg, true);
    }

    private void checkLoadView(boolean withAnim) {
        if (!this.isShowing) {
            this.decorView.addView((View)this.promptView);
            this.isShowing = true;
            if (this.promptView.getBuilder().withAnim && this.inAnim != null && withAnim) {
                this.promptView.startAnimation(this.inAnim);
            }
        }
    }

    private void dissmissAni(boolean isCancle) {
        if (this.dissmissAnim == null) {
            this.dissmissAnim = ValueAnimator.ofInt((int[])new int[]{0, 1});
            this.dissmissAnim.setDuration(this.promptView.getBuilder().stayDuration);
            this.dissmissAnim.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (!PromptDialog.this.dissmissAnimCancle) {
                        PromptDialog.this.dismiss();
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        } else if (this.dissmissAnim.isRunning()) {
            this.dissmissAnimCancle = true;
            this.dissmissAnim.end();
        }
        if (!isCancle) {
            this.dissmissAnim.start();
            this.dissmissAnimCancle = false;
        }
    }

    protected void closeInput() {
        if (this.decorView != null) {
            this.inputmanger.hideSoftInputFromWindow(this.decorView.getWindowToken(), 0);
        }
    }

    public Builder getDefaultBuilder() {
        return Builder.getDefaultBuilder();
    }

    public Builder getAlertDefaultBuilder() {
        return Builder.getAlertDefaultBuilder();
    }

    public boolean onBackPressed() {
        if (this.isShowing && this.promptView.getCurrentType() == 102) {
            return false;
        }
        if (this.isShowing && (this.promptView.getCurrentType() == 107 || this.promptView.getCurrentType() == 109)) {
            this.dismiss();
            return false;
        }
        return true;
    }

    public void onAdClick() {
        if (this.adListener != null) {
            this.adListener.onAdClick();
        }
    }
}

