/*
 * Decompiled with CFR 0.152.
 */
package com.llw.easyutil;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import com.llw.easyutil.EasyDate;
import com.llw.easyutil.EasySP;
import java.util.ArrayList;
import java.util.List;

public final class EasyAppInfo {
    public static final String APP_FIRST_START = "appFirstStart";
    public static final String TODAY_START_UP_APP_TIME = "todayStartUpAppTime";
    private static Context mContext;
    private static PackageManager mPackageManager;
    private static PackageInfo mPackageInfo;
    private static List<AppInfo> appInfoList;

    public static void init(Context context) {
        mContext = context;
        try {
            mPackageManager = mContext.getPackageManager();
            mPackageInfo = mContext.getPackageManager().getPackageInfo(mContext.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static long getVersionCode() {
        return mPackageInfo.getLongVersionCode();
    }

    public static String getVersionName() {
        return EasyAppInfo.mPackageInfo.versionName;
    }

    public static List<PackageInfo> getAllApp() {
        return mPackageManager.getInstalledPackages(0);
    }

    public static List<PackageInfo> getAllApp(boolean isPreInstalled) {
        ArrayList<PackageInfo> preInstallApps = new ArrayList<PackageInfo>();
        ArrayList<PackageInfo> manualInstallationApps = new ArrayList<PackageInfo>();
        List packages = mPackageManager.getInstalledPackages(0);
        for (int i = 0; i < packages.size(); ++i) {
            PackageInfo packageInfo = (PackageInfo)packages.get(i);
            if ((packageInfo.applicationInfo.flags & 1) <= 0) {
                manualInstallationApps.add(packageInfo);
                continue;
            }
            preInstallApps.add(packageInfo);
        }
        return isPreInstalled ? preInstallApps : manualInstallationApps;
    }

    public static String getPackageName() {
        return mContext.getPackageName();
    }

    public static boolean isFirstStartApp() {
        boolean isFirst = EasySP.getBoolean(APP_FIRST_START, true);
        if (isFirst) {
            EasySP.putBoolean(APP_FIRST_START, false);
            return true;
        }
        return false;
    }

    public static boolean isTodayFirstStartApp() {
        String todayDate;
        String saveDate = EasySP.getString(TODAY_START_UP_APP_TIME, "2020-07-14");
        if (!saveDate.equals(todayDate = EasyDate.getTheYearMonthAndDay())) {
            EasySP.putString(TODAY_START_UP_APP_TIME, EasyDate.getTheYearMonthAndDay());
            return true;
        }
        return false;
    }

    public static List<AppInfo> getAppInfoList() {
        List packageInfoList = mPackageManager.getInstalledPackages(0);
        return EasyAppInfo.getAppList(packageInfoList);
    }

    public static List<AppInfo> getAppInfoList(List<PackageInfo> packageInfoList) {
        return EasyAppInfo.getAppList(packageInfoList);
    }

    private static List<AppInfo> getAppList(List<PackageInfo> packageInfoList) {
        appInfoList = new ArrayList<AppInfo>();
        for (PackageInfo packageInfo : packageInfoList) {
            String appName = packageInfo.applicationInfo.loadLabel(mPackageManager).toString();
            String packageName = packageInfo.packageName;
            Drawable appIcon = packageInfo.applicationInfo.loadIcon(mPackageManager);
            appInfoList.add(new AppInfo(appName, packageName, appIcon));
        }
        return appInfoList;
    }

    public static void setAppInfoList(List<AppInfo> appInfoList) {
        EasyAppInfo.appInfoList = appInfoList;
    }

    public static class AppInfo {
        private String appName;
        private String packageName;
        private Drawable appIcon;

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public Drawable getAppIcon() {
            return this.appIcon;
        }

        public void setAppIcon(Drawable appIcon) {
            this.appIcon = appIcon;
        }

        public AppInfo(String appName, String packageName, Drawable appIcon) {
            this.appName = appName;
            this.packageName = packageName;
            this.appIcon = appIcon;
        }
    }
}

