/*
 * Decompiled with CFR 0.152.
 */
package com.lihang;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.lihang.GlideRoundUtils;
import com.lihang.R;

public class ShadowLayout
extends FrameLayout {
    private Paint shadowPaint;
    private int mShadowColor;
    private float mShadowLimit;
    private float mDx;
    private float mDy;
    private float mCornerRadius;
    private float mCornerRadius_leftTop;
    private float mCornerRadius_rightTop;
    private float mCornerRadius_leftBottom;
    private float mCornerRadius_rightBottom;
    private boolean leftShow;
    private boolean rightShow;
    private boolean topShow;
    private boolean bottomShow;
    private int leftPadding;
    private int topPadding;
    private int rightPadding;
    private int bottomPadding;
    private RectF rectf = new RectF();
    private View firstView;
    private boolean isSym;
    private boolean isShowShadow = true;
    private static final int MODE_PRESSED = 1;
    private static final int MODE_SELECTED = 2;
    private static final int MODE_RIPPLE = 3;
    private static final int MODE_DASHLINE = 4;
    private int shapeModeType;
    GradientDrawable gradientDrawable;
    private Drawable layoutBackground;
    private Drawable layoutBackground_true;
    private int mBackGroundColor;
    private int mBackGroundColor_true = -101;
    private int startColor;
    private int centerColor;
    private int endColor;
    private int angle;
    private int current_stroke_color;
    private float stroke_with;
    private int stroke_color;
    private int stroke_color_true;
    private float stroke_dashWidth = -1.0f;
    private float stroke_dashGap = -1.0f;
    private boolean isClickable;
    private Drawable clickAbleFalseDrawable;
    private int clickAbleFalseColor = -101;
    private int mTextViewResId = -1;
    private TextView mTextView;
    private int textColor;
    private int textColor_true;
    private String text;
    private String text_true;
    private Paint mPaintDash;
    private Path dashPath;
    private View.OnClickListener onClickListener;

    @RequiresApi(api=16)
    public ShadowLayout(Context context) {
        this(context, null);
    }

    @RequiresApi(api=16)
    public ShadowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @RequiresApi(api=16)
    public ShadowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    @RequiresApi(api=16)
    private void initView(Context context, AttributeSet attrs) {
        this.initAttributes(attrs);
        if (this.isDashLine()) {
            return;
        }
        this.shadowPaint = new Paint();
        this.shadowPaint.setAntiAlias(true);
        this.shadowPaint.setStyle(Paint.Style.FILL);
        this.gradientDrawable = new GradientDrawable();
        this.gradientDrawable.setColors(new int[]{this.mBackGroundColor, this.mBackGroundColor});
        if (this.stroke_color != -101) {
            this.current_stroke_color = this.stroke_color;
        }
        this.setPadding();
    }

    private boolean isDashLine() {
        return this.shapeModeType == 4;
    }

    private void initDashLine() {
        this.mPaintDash = new Paint();
        this.mPaintDash.setAntiAlias(true);
        this.mPaintDash.setColor(this.stroke_color);
        this.mPaintDash.setStyle(Paint.Style.STROKE);
        this.mPaintDash.setPathEffect((PathEffect)new DashPathEffect(new float[]{this.stroke_dashWidth, this.stroke_dashGap}, 0.0f));
        this.dashPath = new Path();
    }

    @RequiresApi(api=16)
    private void initAttributes(AttributeSet attrs) {
        Drawable trueBackground;
        TypedArray attr2 = this.getContext().obtainStyledAttributes(attrs, R.styleable.ShadowLayout);
        this.shapeModeType = attr2.getInt(R.styleable.ShadowLayout_hl_shapeMode, 1);
        if (this.isDashLine()) {
            this.stroke_color = attr2.getColor(R.styleable.ShadowLayout_hl_strokeColor, -101);
            this.stroke_dashWidth = attr2.getDimension(R.styleable.ShadowLayout_hl_stroke_dashWidth, -1.0f);
            this.stroke_dashGap = attr2.getDimension(R.styleable.ShadowLayout_hl_stroke_dashGap, -1.0f);
            if (this.stroke_color == -101) {
                throw new UnsupportedOperationException("shapeMode\u4e3aMODE_DASHLINE,\u9700\u8bbe\u7f6estroke_color\u503c");
            }
            if (this.stroke_dashWidth == -1.0f) {
                throw new UnsupportedOperationException("shapeMode\u4e3aMODE_DASHLINE,\u9700\u8bbe\u7f6estroke_dashWidth\u503c");
            }
            if (this.stroke_dashWidth == -1.0f && this.stroke_dashGap != -1.0f || this.stroke_dashWidth != -1.0f && this.stroke_dashGap == -1.0f) {
                throw new UnsupportedOperationException("\u4f7f\u7528\u4e86\u865a\u7ebf\u8fb9\u6846,\u5fc5\u987b\u8bbe\u7f6e\u4ee5\u4e0b2\u4e2a\u5c5e\u6027\uff1aShadowLayout_hl_stroke_dashWidth\uff0cShadowLayout_hl_stroke_dashGap");
            }
            this.initDashLine();
            attr2.recycle();
            return;
        }
        this.isShowShadow = !attr2.getBoolean(R.styleable.ShadowLayout_hl_shadowHidden, false);
        this.leftShow = !attr2.getBoolean(R.styleable.ShadowLayout_hl_shadowHiddenLeft, false);
        this.rightShow = !attr2.getBoolean(R.styleable.ShadowLayout_hl_shadowHiddenRight, false);
        this.bottomShow = !attr2.getBoolean(R.styleable.ShadowLayout_hl_shadowHiddenBottom, false);
        this.topShow = !attr2.getBoolean(R.styleable.ShadowLayout_hl_shadowHiddenTop, false);
        this.mCornerRadius = attr2.getDimension(R.styleable.ShadowLayout_hl_cornerRadius, this.getResources().getDimension(R.dimen.dp_0));
        this.mCornerRadius_leftTop = attr2.getDimension(R.styleable.ShadowLayout_hl_cornerRadius_leftTop, -1.0f);
        this.mCornerRadius_leftBottom = attr2.getDimension(R.styleable.ShadowLayout_hl_cornerRadius_leftBottom, -1.0f);
        this.mCornerRadius_rightTop = attr2.getDimension(R.styleable.ShadowLayout_hl_cornerRadius_rightTop, -1.0f);
        this.mCornerRadius_rightBottom = attr2.getDimension(R.styleable.ShadowLayout_hl_cornerRadius_rightBottom, -1.0f);
        this.mShadowLimit = attr2.getDimension(R.styleable.ShadowLayout_hl_shadowLimit, 0.0f);
        if (this.mShadowLimit == 0.0f) {
            this.isShowShadow = false;
        }
        this.mDx = attr2.getDimension(R.styleable.ShadowLayout_hl_shadowOffsetX, 0.0f);
        this.mDy = attr2.getDimension(R.styleable.ShadowLayout_hl_shadowOffsetY, 0.0f);
        this.mShadowColor = attr2.getColor(R.styleable.ShadowLayout_hl_shadowColor, this.getResources().getColor(R.color.default_shadow_color));
        this.isSym = attr2.getBoolean(R.styleable.ShadowLayout_hl_shadowSymmetry, true);
        this.mBackGroundColor = this.getResources().getColor(R.color.default_shadowback_color);
        Drawable background = attr2.getDrawable(R.styleable.ShadowLayout_hl_layoutBackground);
        if (background != null) {
            if (background instanceof ColorDrawable) {
                ColorDrawable colorDrawable = (ColorDrawable)background;
                this.mBackGroundColor = colorDrawable.getColor();
            } else {
                this.layoutBackground = background;
            }
        }
        if ((trueBackground = attr2.getDrawable(R.styleable.ShadowLayout_hl_layoutBackground_true)) != null) {
            if (trueBackground instanceof ColorDrawable) {
                ColorDrawable colorDrawableTrue = (ColorDrawable)trueBackground;
                this.mBackGroundColor_true = colorDrawableTrue.getColor();
            } else {
                this.layoutBackground_true = trueBackground;
            }
        }
        if (this.mBackGroundColor_true != -101 && this.layoutBackground != null) {
            throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground_true\u5c5e\u6027\uff0c\u5fc5\u987b\u5148\u8bbe\u7f6eShadowLayout_hl_layoutBackground\u5c5e\u6027\u3002\u4e14\u8bbe\u7f6e\u989c\u8272\u65f6\uff0c\u5fc5\u987b\u4fdd\u6301\u90fd\u4e3a\u989c\u8272");
        }
        if (this.layoutBackground == null && this.layoutBackground_true != null) {
            throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground_true\u5c5e\u6027\uff0c\u5fc5\u987b\u5148\u8bbe\u7f6eShadowLayout_hl_layoutBackground\u5c5e\u6027\u3002\u4e14\u8bbe\u7f6e\u56fe\u7247\u65f6\uff0c\u5fc5\u987b\u4fdd\u6301\u90fd\u4e3a\u56fe\u7247");
        }
        this.stroke_color = attr2.getColor(R.styleable.ShadowLayout_hl_strokeColor, -101);
        this.stroke_color_true = attr2.getColor(R.styleable.ShadowLayout_hl_strokeColor_true, -101);
        if (this.stroke_color == -101 && this.stroke_color_true != -101) {
            throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_strokeColor_true\u5c5e\u6027\uff0c\u5fc5\u987b\u5148\u8bbe\u7f6eShadowLayout_hl_strokeColor\u5c5e\u6027");
        }
        this.stroke_with = attr2.getDimension(R.styleable.ShadowLayout_hl_strokeWith, (float)this.dip2px(1.0f));
        this.stroke_dashWidth = attr2.getDimension(R.styleable.ShadowLayout_hl_stroke_dashWidth, -1.0f);
        this.stroke_dashGap = attr2.getDimension(R.styleable.ShadowLayout_hl_stroke_dashGap, -1.0f);
        if (this.stroke_dashWidth == -1.0f && this.stroke_dashGap != -1.0f || this.stroke_dashWidth != -1.0f && this.stroke_dashGap == -1.0f) {
            throw new UnsupportedOperationException("\u4f7f\u7528\u4e86\u865a\u7ebf\u8fb9\u6846,\u5fc5\u987b\u8bbe\u7f6e\u4ee5\u4e0b2\u4e2a\u5c5e\u6027\uff1aShadowLayout_hl_stroke_dashWidth\uff0cShadowLayout_hl_stroke_dashGap");
        }
        Drawable clickAbleFalseBackground = attr2.getDrawable(R.styleable.ShadowLayout_hl_layoutBackground_clickFalse);
        if (clickAbleFalseBackground != null) {
            if (clickAbleFalseBackground instanceof ColorDrawable) {
                ColorDrawable colorDrawableClickableFalse = (ColorDrawable)clickAbleFalseBackground;
                this.clickAbleFalseColor = colorDrawableClickableFalse.getColor();
            } else {
                this.clickAbleFalseDrawable = clickAbleFalseBackground;
            }
        }
        this.startColor = attr2.getColor(R.styleable.ShadowLayout_hl_startColor, -101);
        this.centerColor = attr2.getColor(R.styleable.ShadowLayout_hl_centerColor, -101);
        this.endColor = attr2.getColor(R.styleable.ShadowLayout_hl_endColor, -101);
        if (this.startColor != -101 && this.endColor == -101) {
            throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_startColor\u6e10\u53d8\u8d77\u59cb\u8272\uff0c\u5fc5\u987b\u642d\u914d\u7ec8\u6b62\u8272ShadowLayout_hl_endColor");
        }
        this.angle = attr2.getInt(R.styleable.ShadowLayout_hl_angle, 0);
        if (this.angle % 45 != 0) {
            throw new IllegalArgumentException("Linear gradient requires 'angle' attribute to be a multiple of 45");
        }
        if (this.shapeModeType == 3) {
            if (this.mBackGroundColor == -101 || this.mBackGroundColor_true == -101) {
                throw new NullPointerException("\u4f7f\u7528\u4e86ShadowLayout\u7684\u6c34\u6ce2\u7eb9\uff0c\u5fc5\u987b\u8bbe\u7f6e\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground\u548c\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground_true\u5c5e\u6027\uff0c\u4e14\u4e3a\u989c\u8272\u503c");
            }
            if (this.layoutBackground != null) {
                this.shapeModeType = 1;
            }
        }
        this.mTextViewResId = attr2.getResourceId(R.styleable.ShadowLayout_hl_bindTextView, -1);
        this.textColor = attr2.getColor(R.styleable.ShadowLayout_hl_textColor, -101);
        this.textColor_true = attr2.getColor(R.styleable.ShadowLayout_hl_textColor_true, -101);
        this.text = attr2.getString(R.styleable.ShadowLayout_hl_text);
        this.text_true = attr2.getString(R.styleable.ShadowLayout_hl_text_true);
        this.isClickable = attr2.getBoolean(R.styleable.ShadowLayout_clickable, true);
        this.setClickable(this.isClickable);
        attr2.recycle();
    }

    @RequiresApi(api=16)
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.isDashLine()) {
            this.setBackgroundColor(Color.parseColor((String)"#00000000"));
            return;
        }
        if (w > 0 && h > 0) {
            this.setBackgroundCompat(w, h);
            if (this.startColor != -101) {
                this.gradient(this.gradientDrawable);
            }
        }
    }

    @RequiresApi(api=16)
    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.isDashLine()) {
            if (this.getChildAt(0) != null) {
                throw new UnsupportedOperationException("shapeMode\u4e3aMODE_DASHLINE\uff0c\u4e0d\u652f\u6301\u5b50view");
            }
            return;
        }
        if (this.mTextViewResId != -1) {
            this.mTextView = (TextView)this.findViewById(this.mTextViewResId);
            if (this.mTextView == null) {
                throw new NullPointerException("ShadowLayout\u627e\u4e0d\u5230hl_bindTextView\uff0c\u8bf7\u786e\u4fdd\u7ed1\u5b9a\u7684\u8d44\u6e90id\u5728ShadowLayout\u5185");
            }
            if (this.textColor == -101) {
                this.textColor = this.mTextView.getCurrentTextColor();
            }
            if (this.textColor_true == -101) {
                this.textColor_true = this.mTextView.getCurrentTextColor();
            }
            this.mTextView.setTextColor(this.textColor);
            if (!TextUtils.isEmpty((CharSequence)this.text)) {
                this.mTextView.setText((CharSequence)this.text);
            }
        }
        this.firstView = this.getChildAt(0);
        if (this.layoutBackground != null && this.isShowShadow && this.mShadowLimit > 0.0f && this.getChildAt(0) == null) {
            throw new UnsupportedOperationException("\u4f7f\u7528\u4e86\u56fe\u7247\u53c8\u52a0\u4e0a\u9634\u5f71\u7684\u60c5\u51b5\u4e0b\uff0c\u5fc5\u987b\u52a0\u4e0a\u5b50view\u624d\u4f1a\u751f\u6548!~");
        }
        if (this.firstView == null) {
            this.firstView = this;
            this.isShowShadow = false;
        }
        if (this.firstView != null) {
            if (this.shapeModeType == 2) {
                this.setmBackGround(this.layoutBackground, "onFinishInflate");
            } else if (this.isClickable) {
                this.setmBackGround(this.layoutBackground, "onFinishInflate");
            } else {
                this.setmBackGround(this.clickAbleFalseDrawable, "onFinishInflate");
                if (this.clickAbleFalseColor != -101) {
                    this.gradientDrawable.setColors(new int[]{this.clickAbleFalseColor, this.clickAbleFalseColor});
                }
            }
        }
    }

    @RequiresApi(api=16)
    public boolean onTouchEvent(MotionEvent event) {
        if (this.shapeModeType == 3) {
            if (this.isClickable) {
                switch (event.getAction()) {
                    case 0: {
                        if (this.mTextView == null) break;
                        this.mTextView.setTextColor(this.textColor_true);
                        if (TextUtils.isEmpty((CharSequence)this.text_true)) break;
                        this.mTextView.setText((CharSequence)this.text_true);
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (this.mTextView == null) break;
                        this.mTextView.setTextColor(this.textColor);
                        if (TextUtils.isEmpty((CharSequence)this.text)) break;
                        this.mTextView.setText((CharSequence)this.text);
                    }
                }
            }
            return super.onTouchEvent(event);
        }
        if ((this.mBackGroundColor_true != -101 || this.stroke_color_true != -101 || this.layoutBackground_true != null) && this.isClickable && this.shapeModeType == 1) {
            switch (event.getAction()) {
                case 0: {
                    if (this.mBackGroundColor_true != -101) {
                        this.gradientDrawable.setColors(new int[]{this.mBackGroundColor_true, this.mBackGroundColor_true});
                    }
                    if (this.stroke_color_true != -101) {
                        this.current_stroke_color = this.stroke_color_true;
                    }
                    if (this.layoutBackground_true != null) {
                        this.setmBackGround(this.layoutBackground_true, "onTouchEvent");
                    }
                    this.postInvalidate();
                    if (this.mTextView == null) break;
                    this.mTextView.setTextColor(this.textColor_true);
                    if (TextUtils.isEmpty((CharSequence)this.text_true)) break;
                    this.mTextView.setText((CharSequence)this.text_true);
                    break;
                }
                case 1: 
                case 3: {
                    this.gradientDrawable.setColors(new int[]{this.mBackGroundColor, this.mBackGroundColor});
                    if (this.startColor != -101) {
                        this.gradient(this.gradientDrawable);
                    }
                    if (this.stroke_color != -101) {
                        this.current_stroke_color = this.stroke_color;
                    }
                    if (this.layoutBackground != null) {
                        this.setmBackGround(this.layoutBackground, "onTouchEvent");
                    }
                    this.postInvalidate();
                    if (this.mTextView == null) break;
                    this.mTextView.setTextColor(this.textColor);
                    if (TextUtils.isEmpty((CharSequence)this.text)) break;
                    this.mTextView.setText((CharSequence)this.text);
                }
            }
        }
        return super.onTouchEvent(event);
    }

    @RequiresApi(api=16)
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.getWidth() != 0) {
            if (this.shapeModeType == 2) {
                if (selected) {
                    if (this.mBackGroundColor_true != -101) {
                        this.gradientDrawable.setColors(new int[]{this.mBackGroundColor_true, this.mBackGroundColor_true});
                    }
                    if (this.stroke_color_true != -101) {
                        this.current_stroke_color = this.stroke_color_true;
                    }
                    if (this.layoutBackground_true != null) {
                        this.setmBackGround(this.layoutBackground_true, "setSelected");
                    }
                    if (this.mTextView != null) {
                        this.mTextView.setTextColor(this.textColor_true);
                        if (!TextUtils.isEmpty((CharSequence)this.text_true)) {
                            this.mTextView.setText((CharSequence)this.text_true);
                        }
                    }
                } else {
                    this.gradientDrawable.setColors(new int[]{this.mBackGroundColor, this.mBackGroundColor});
                    if (this.startColor != -101) {
                        this.gradient(this.gradientDrawable);
                    }
                    if (this.stroke_color != -101) {
                        this.current_stroke_color = this.stroke_color;
                    }
                    if (this.layoutBackground != null) {
                        this.setmBackGround(this.layoutBackground, "setSelected");
                    }
                    if (this.mTextView != null) {
                        this.mTextView.setTextColor(this.textColor);
                        if (!TextUtils.isEmpty((CharSequence)this.text)) {
                            this.mTextView.setText((CharSequence)this.text);
                        }
                    }
                }
                this.postInvalidate();
            }
        } else {
            this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    ShadowLayout.this.removeOnLayoutChangeListener(this);
                    ShadowLayout.this.setSelected(ShadowLayout.this.isSelected());
                }
            });
        }
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.onClickListener = l;
        if (this.isClickable) {
            super.setOnClickListener(l);
        }
    }

    @RequiresApi(api=16)
    private void changeSwitchClickable() {
        if (this.shapeModeType == 1 && this.firstView != null) {
            if (!this.isClickable) {
                if (this.clickAbleFalseColor != -101) {
                    if (this.layoutBackground != null) {
                        this.firstView.getBackground().setAlpha(0);
                    }
                    this.gradientDrawable.setColors(new int[]{this.clickAbleFalseColor, this.clickAbleFalseColor});
                    this.postInvalidate();
                } else if (this.clickAbleFalseDrawable != null) {
                    this.setmBackGround(this.clickAbleFalseDrawable, "changeSwitchClickable");
                    this.gradientDrawable.setColors(new int[]{Color.parseColor((String)"#00000000"), Color.parseColor((String)"#00000000")});
                    this.postInvalidate();
                }
            } else {
                if (this.layoutBackground != null) {
                    this.setmBackGround(this.layoutBackground, "changeSwitchClickable");
                } else if (this.firstView.getBackground() != null) {
                    this.firstView.getBackground().setAlpha(0);
                }
                this.gradientDrawable.setColors(new int[]{this.mBackGroundColor, this.mBackGroundColor});
                this.postInvalidate();
            }
        }
    }

    @RequiresApi(api=21)
    protected void dispatchDraw(Canvas canvas) {
        int trueHeight = (int)(this.rectf.bottom - this.rectf.top);
        if (this.getChildAt(0) != null) {
            if (this.mCornerRadius_leftTop == -1.0f && this.mCornerRadius_leftBottom == -1.0f && this.mCornerRadius_rightTop == -1.0f && this.mCornerRadius_rightBottom == -1.0f) {
                if (this.mCornerRadius > (float)(trueHeight / 2)) {
                    Path path = new Path();
                    path.addRoundRect(this.rectf, (float)(trueHeight / 2), (float)(trueHeight / 2), Path.Direction.CW);
                    canvas.clipPath(path);
                } else {
                    Path path = new Path();
                    path.addRoundRect(this.rectf, this.mCornerRadius, this.mCornerRadius, Path.Direction.CW);
                    canvas.clipPath(path);
                }
            } else {
                float[] outerR = this.getCornerValue(trueHeight);
                Path path = new Path();
                path.addRoundRect((float)this.leftPadding, (float)this.topPadding, (float)(this.getWidth() - this.rightPadding), (float)(this.getHeight() - this.bottomPadding), outerR, Path.Direction.CW);
                canvas.clipPath(path);
            }
        }
        super.dispatchDraw(canvas);
    }

    @RequiresApi(api=21)
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isDashLine()) {
            this.drawLine(canvas);
            return;
        }
        this.rectf.left = this.leftPadding;
        this.rectf.top = this.topPadding;
        this.rectf.right = this.getWidth() - this.rightPadding;
        this.rectf.bottom = this.getHeight() - this.bottomPadding;
        int trueHeight = (int)(this.rectf.bottom - this.rectf.top);
        if (this.stroke_color != -101 && this.stroke_with > (float)(trueHeight / 2)) {
            this.stroke_with = trueHeight / 2;
        }
        if (this.layoutBackground == null && this.layoutBackground_true == null) {
            float[] outerR = this.getCornerValue(trueHeight);
            if (this.shapeModeType != 3) {
                this.drawGradientDrawable(canvas, this.rectf, outerR);
            } else {
                this.ripple(outerR);
            }
        }
    }

    public void drawLine(Canvas canvas) {
        int currentHeight;
        int currentWidth = this.getWidth();
        if (currentWidth > (currentHeight = this.getHeight())) {
            this.mPaintDash.setStrokeWidth((float)currentHeight);
            this.dashPath.reset();
            this.dashPath.moveTo(0.0f, (float)(currentHeight / 2));
            this.dashPath.lineTo((float)currentWidth, (float)(currentHeight / 2));
        } else {
            this.mPaintDash.setStrokeWidth((float)currentWidth);
            this.dashPath.reset();
            this.dashPath.moveTo((float)(currentWidth / 2), 0.0f);
            this.dashPath.lineTo((float)(currentWidth / 2), (float)currentHeight);
        }
        canvas.drawPath(this.dashPath, this.mPaintDash);
    }

    @RequiresApi(api=16)
    public void drawGradientDrawable(Canvas canvas, RectF rectf, float[] cornerRadiusArr) {
        this.gradientDrawable.setBounds((int)rectf.left, (int)rectf.top, (int)rectf.right, (int)rectf.bottom);
        if (this.stroke_color != -101) {
            if (this.stroke_dashWidth != -1.0f) {
                this.gradientDrawable.setStroke(Math.round(this.stroke_with), this.current_stroke_color, this.stroke_dashWidth, this.stroke_dashGap);
            } else {
                this.gradientDrawable.setStroke(Math.round(this.stroke_with), this.current_stroke_color);
            }
        }
        this.gradientDrawable.setCornerRadii(cornerRadiusArr);
        this.gradientDrawable.draw(canvas);
    }

    private float[] getCornerValue(int trueHeight) {
        int leftBottom;
        int rightBottom;
        int rightTop;
        int leftTop = this.mCornerRadius_leftTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftTop;
        if (leftTop > trueHeight / 2) {
            leftTop = trueHeight / 2;
        }
        if ((rightTop = this.mCornerRadius_rightTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightTop) > trueHeight / 2) {
            rightTop = trueHeight / 2;
        }
        if ((rightBottom = this.mCornerRadius_rightBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightBottom) > trueHeight / 2) {
            rightBottom = trueHeight / 2;
        }
        if ((leftBottom = this.mCornerRadius_leftBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftBottom) > trueHeight / 2) {
            leftBottom = trueHeight / 2;
        }
        float[] outerR = new float[]{leftTop, leftTop, rightTop, rightTop, rightBottom, rightBottom, leftBottom, leftBottom};
        return outerR;
    }

    @RequiresApi(api=21)
    private void ripple(float[] outRadius) {
        int[][] stateList = new int[][]{{16842919}, {16842908}, {16843518}, new int[0]};
        int normalColor = this.mBackGroundColor;
        int pressedColor = this.mBackGroundColor_true;
        int[] stateColorList = new int[]{pressedColor, pressedColor, pressedColor, normalColor};
        ColorStateList colorStateList = new ColorStateList((int[][])stateList, stateColorList);
        RoundRectShape roundRectShape = new RoundRectShape(outRadius, null, null);
        ShapeDrawable maskDrawable = new ShapeDrawable();
        maskDrawable.setShape((Shape)roundRectShape);
        maskDrawable.getPaint().setStyle(Paint.Style.FILL);
        if (this.stroke_color != -101) {
            if (this.stroke_dashWidth != -1.0f) {
                this.gradientDrawable.setStroke(Math.round(this.stroke_with), this.current_stroke_color, this.stroke_dashWidth, this.stroke_dashGap);
            } else {
                this.gradientDrawable.setStroke(Math.round(this.stroke_with), this.current_stroke_color);
            }
        }
        this.gradientDrawable.setCornerRadii(outRadius);
        if (this.startColor != -101) {
            this.gradient(this.gradientDrawable);
        }
        RippleDrawable rippleDrawable = new RippleDrawable(colorStateList, (Drawable)this.gradientDrawable, (Drawable)maskDrawable);
        this.firstView.setBackground((Drawable)rippleDrawable);
    }

    @RequiresApi(api=16)
    private void gradient(GradientDrawable gradientDrawable) {
        int trueAngle;
        if (!this.isClickable) {
            return;
        }
        int[] colors = this.centerColor == -101 ? new int[]{this.startColor, this.endColor} : new int[]{this.startColor, this.centerColor, this.endColor};
        gradientDrawable.setColors(colors);
        if (this.angle < 0) {
            trueAngle = this.angle % 360;
            this.angle = trueAngle + 360;
        }
        trueAngle = this.angle % 360;
        int angleFlag = trueAngle / 45;
        switch (angleFlag) {
            case 0: {
                gradientDrawable.setOrientation(GradientDrawable.Orientation.LEFT_RIGHT);
                break;
            }
            case 1: {
                gradientDrawable.setOrientation(GradientDrawable.Orientation.BL_TR);
                break;
            }
            case 2: {
                gradientDrawable.setOrientation(GradientDrawable.Orientation.BOTTOM_TOP);
                break;
            }
            case 3: {
                gradientDrawable.setOrientation(GradientDrawable.Orientation.BR_TL);
                break;
            }
            case 4: {
                gradientDrawable.setOrientation(GradientDrawable.Orientation.RIGHT_LEFT);
                break;
            }
            case 5: {
                gradientDrawable.setOrientation(GradientDrawable.Orientation.TR_BL);
                break;
            }
            case 6: {
                gradientDrawable.setOrientation(GradientDrawable.Orientation.TOP_BOTTOM);
                break;
            }
            case 7: {
                gradientDrawable.setOrientation(GradientDrawable.Orientation.TL_BR);
            }
        }
    }

    private int dip2px(float dipValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    private void setPadding() {
        if (this.isShowShadow && this.mShadowLimit > 0.0f) {
            if (this.isSym) {
                int xPadding = (int)(this.mShadowLimit + Math.abs(this.mDx));
                int yPadding = (int)(this.mShadowLimit + Math.abs(this.mDy));
                this.leftPadding = this.leftShow ? xPadding : 0;
                this.topPadding = this.topShow ? yPadding : 0;
                this.rightPadding = this.rightShow ? xPadding : 0;
                this.bottomPadding = this.bottomShow ? yPadding : 0;
            } else {
                if (Math.abs(this.mDy) > this.mShadowLimit) {
                    this.mDy = this.mDy > 0.0f ? this.mShadowLimit : 0.0f - this.mShadowLimit;
                }
                if (Math.abs(this.mDx) > this.mShadowLimit) {
                    this.mDx = this.mDx > 0.0f ? this.mShadowLimit : 0.0f - this.mShadowLimit;
                }
                this.topPadding = this.topShow ? (int)(this.mShadowLimit - this.mDy) : 0;
                this.bottomPadding = this.bottomShow ? (int)(this.mShadowLimit + this.mDy) : 0;
                this.rightPadding = this.rightShow ? (int)(this.mShadowLimit - this.mDx) : 0;
                this.leftPadding = this.leftShow ? (int)(this.mShadowLimit + this.mDx) : 0;
            }
            this.setPadding(this.leftPadding, this.topPadding, this.rightPadding, this.bottomPadding);
        }
    }

    @RequiresApi(api=16)
    private void setBackgroundCompat(int w, int h) {
        if (this.isShowShadow) {
            this.isAddAlpha(this.mShadowColor);
            Bitmap bitmap = this.createShadowBitmap(w, h, this.mCornerRadius, this.mShadowLimit, this.mDx, this.mDy, this.mShadowColor, 0);
            BitmapDrawable drawable = new BitmapDrawable(bitmap);
            if (Build.VERSION.SDK_INT <= 16) {
                this.setBackgroundDrawable((Drawable)drawable);
            } else {
                this.setBackground((Drawable)drawable);
            }
        } else if (this.getChildAt(0) == null) {
            if (this.layoutBackground != null) {
                this.firstView = this;
                if (this.isClickable) {
                    this.setmBackGround(this.layoutBackground, "setBackgroundCompat");
                } else {
                    this.changeSwitchClickable();
                }
            } else {
                this.setBackgroundColor(Color.parseColor((String)"#00000000"));
            }
        } else {
            this.setBackgroundColor(Color.parseColor((String)"#00000000"));
        }
    }

    private Bitmap createShadowBitmap(int shadowWidth, int shadowHeight, float cornerRadius, float shadowRadius, float dx, float dy, int shadowColor, int fillColor) {
        float maxRightBottom;
        float maxLeftTop;
        dx /= 4.0f;
        dy /= 4.0f;
        shadowWidth = shadowWidth / 4 == 0 ? 1 : shadowWidth / 4;
        shadowHeight = shadowHeight / 4 == 0 ? 1 : shadowHeight / 4;
        cornerRadius /= 4.0f;
        shadowRadius /= 4.0f;
        Bitmap output = Bitmap.createBitmap((int)shadowWidth, (int)shadowHeight, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(output);
        float rect_left = 0.0f;
        float rect_right = 0.0f;
        float rect_top = 0.0f;
        float rect_bottom = 0.0f;
        if (this.leftShow) {
            rect_left = shadowRadius;
        } else {
            maxLeftTop = Math.max(cornerRadius, this.mCornerRadius_leftTop);
            float maxLeftBottom = Math.max(cornerRadius, this.mCornerRadius_leftBottom);
            float maxLeft = Math.max(maxLeftTop, maxLeftBottom);
            float trueMaxLeft = Math.max(maxLeft, shadowRadius);
            rect_left = trueMaxLeft / 2.0f;
        }
        if (this.topShow) {
            rect_top = shadowRadius;
        } else {
            maxLeftTop = Math.max(cornerRadius, this.mCornerRadius_leftTop);
            float maxRightTop = Math.max(cornerRadius, this.mCornerRadius_rightTop);
            float maxTop = Math.max(maxLeftTop, maxRightTop);
            float trueMaxTop = Math.max(maxTop, shadowRadius);
            rect_top = trueMaxTop / 2.0f;
        }
        if (this.rightShow) {
            rect_right = (float)shadowWidth - shadowRadius;
        } else {
            float maxRightTop = Math.max(cornerRadius, this.mCornerRadius_rightTop);
            maxRightBottom = Math.max(cornerRadius, this.mCornerRadius_rightBottom);
            float maxRight = Math.max(maxRightTop, maxRightBottom);
            float trueMaxRight = Math.max(maxRight, shadowRadius);
            rect_right = (float)shadowWidth - trueMaxRight / 2.0f;
        }
        if (this.bottomShow) {
            rect_bottom = (float)shadowHeight - shadowRadius;
        } else {
            float maxLeftBottom = Math.max(cornerRadius, this.mCornerRadius_leftBottom);
            maxRightBottom = Math.max(cornerRadius, this.mCornerRadius_rightBottom);
            float maxBottom = Math.max(maxLeftBottom, maxRightBottom);
            float trueMaxBottom = Math.max(maxBottom, shadowRadius);
            rect_bottom = (float)shadowHeight - trueMaxBottom / 2.0f;
        }
        RectF shadowRect = new RectF(rect_left, rect_top, rect_right, rect_bottom);
        if (this.isSym) {
            if (dy > 0.0f) {
                shadowRect.top += dy;
                shadowRect.bottom -= dy;
            } else if (dy < 0.0f) {
                shadowRect.top += Math.abs(dy);
                shadowRect.bottom -= Math.abs(dy);
            }
            if (dx > 0.0f) {
                shadowRect.left += dx;
                shadowRect.right -= dx;
            } else if (dx < 0.0f) {
                shadowRect.left += Math.abs(dx);
                shadowRect.right -= Math.abs(dx);
            }
        } else {
            shadowRect.top -= dy;
            shadowRect.bottom -= dy;
            shadowRect.right -= dx;
            shadowRect.left -= dx;
        }
        this.shadowPaint.setColor(fillColor);
        if (!this.isInEditMode()) {
            this.shadowPaint.setShadowLayer(shadowRadius / 2.0f, dx, dy, shadowColor);
        }
        if (this.mCornerRadius_leftBottom == -1.0f && this.mCornerRadius_leftTop == -1.0f && this.mCornerRadius_rightTop == -1.0f && this.mCornerRadius_rightBottom == -1.0f) {
            canvas.drawRoundRect(shadowRect, cornerRadius, cornerRadius, this.shadowPaint);
        } else {
            this.rectf.left = this.leftPadding;
            this.rectf.top = this.topPadding;
            this.rectf.right = this.getWidth() - this.rightPadding;
            this.rectf.bottom = this.getHeight() - this.bottomPadding;
            this.shadowPaint.setAntiAlias(true);
            int leftTop = this.mCornerRadius_leftTop == -1.0f ? (int)this.mCornerRadius / 4 : (int)this.mCornerRadius_leftTop / 4;
            int leftBottom = this.mCornerRadius_leftBottom == -1.0f ? (int)this.mCornerRadius / 4 : (int)this.mCornerRadius_leftBottom / 4;
            int rightTop = this.mCornerRadius_rightTop == -1.0f ? (int)this.mCornerRadius / 4 : (int)this.mCornerRadius_rightTop / 4;
            int rightBottom = this.mCornerRadius_rightBottom == -1.0f ? (int)this.mCornerRadius / 4 : (int)this.mCornerRadius_rightBottom / 4;
            float[] outerR = new float[]{leftTop, leftTop, rightTop, rightTop, rightBottom, rightBottom, leftBottom, leftBottom};
            Path path = new Path();
            path.addRoundRect(shadowRect, outerR, Path.Direction.CW);
            canvas.drawPath(path, this.shadowPaint);
        }
        return output;
    }

    private void isAddAlpha(int color2) {
        if (Color.alpha((int)color2) == 255) {
            String red = Integer.toHexString(Color.red((int)color2));
            String green = Integer.toHexString(Color.green((int)color2));
            String blue = Integer.toHexString(Color.blue((int)color2));
            if (red.length() == 1) {
                red = "0" + red;
            }
            if (green.length() == 1) {
                green = "0" + green;
            }
            if (blue.length() == 1) {
                blue = "0" + blue;
            }
            String endColor = "#2a" + red + green + blue;
            this.mShadowColor = ShadowLayout.convertToColorInt(endColor);
        }
    }

    private static int convertToColorInt(String argb) throws IllegalArgumentException {
        if (!argb.startsWith("#")) {
            argb = "#" + argb;
        }
        return Color.parseColor((String)argb);
    }

    private void setmBackGround(Drawable drawable, String currentTag) {
        this.firstView.setTag(R.id.action_container, (Object)currentTag);
        if (this.firstView != null && drawable != null) {
            if (this.mCornerRadius_leftTop == -1.0f && this.mCornerRadius_leftBottom == -1.0f && this.mCornerRadius_rightTop == -1.0f && this.mCornerRadius_rightBottom == -1.0f) {
                GlideRoundUtils.setRoundCorner(this.firstView, drawable, this.mCornerRadius, currentTag);
            } else {
                int leftTop = this.mCornerRadius_leftTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftTop;
                int leftBottom = this.mCornerRadius_leftBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftBottom;
                int rightTop = this.mCornerRadius_rightTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightTop;
                int rightBottom = this.mCornerRadius_rightBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightBottom;
                GlideRoundUtils.setCorners(this.firstView, drawable, leftTop, leftBottom, rightTop, rightBottom, currentTag);
            }
        }
    }

    @RequiresApi(api=16)
    public void setClickable(boolean clickable) {
        this.isExceptionByDashLine();
        super.setClickable(clickable);
        this.isClickable = clickable;
        this.changeSwitchClickable();
        if (this.isClickable) {
            super.setOnClickListener(this.onClickListener);
        }
        if (this.gradientDrawable != null && this.startColor != -101 && this.endColor != -101) {
            this.gradient(this.gradientDrawable);
        }
    }

    @RequiresApi(api=16)
    public ShadowLayout setGradientColor(int startColor, int endColor) {
        this.setGradientColor(this.angle, startColor, endColor);
        return this;
    }

    @RequiresApi(api=16)
    public ShadowLayout setGradientColor(int angle, int startColor, int endColor) {
        this.setGradientColor(angle, startColor, -101, endColor);
        return this;
    }

    @RequiresApi(api=16)
    public ShadowLayout setGradientColor(int angle, int startColor, int centerColor, int endColor) {
        this.isExceptionByDashLine();
        if (angle % 45 != 0) {
            throw new IllegalArgumentException("Linear gradient requires 'angle' attribute to be a multiple of 45");
        }
        this.angle = angle;
        this.startColor = startColor;
        this.centerColor = centerColor;
        this.endColor = endColor;
        this.gradient(this.gradientDrawable);
        this.postInvalidate();
        return this;
    }

    private void isExceptionByDashLine() {
        if (this.isDashLine()) {
            throw new RuntimeException("shapeMode\u4e3aMODE_DASHLINE,\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u6b64\u5c5e\u6027");
        }
    }

    @RequiresApi(api=16)
    public ShadowLayout setShadowHidden(boolean isShowShadow) {
        this.isExceptionByDashLine();
        this.isShowShadow = !isShowShadow;
        this.setPadding();
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setBackgroundCompat(this.getWidth(), this.getHeight());
        }
        return this;
    }

    public ShadowLayout setShadowOffsetX(float mDx) {
        this.isExceptionByDashLine();
        if (this.isShowShadow) {
            this.mDx = Math.abs(mDx) > this.mShadowLimit ? (mDx > 0.0f ? this.mShadowLimit : -this.mShadowLimit) : mDx;
            this.setPadding();
        }
        return this;
    }

    public ShadowLayout setShadowOffsetY(float mDy) {
        this.isExceptionByDashLine();
        if (this.isShowShadow) {
            this.mDy = Math.abs(mDy) > this.mShadowLimit ? (mDy > 0.0f ? this.mShadowLimit : -this.mShadowLimit) : mDy;
            this.setPadding();
        }
        return this;
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    @RequiresApi(api=16)
    public ShadowLayout setCornerRadius(int mCornerRadius) {
        this.isExceptionByDashLine();
        this.mCornerRadius = mCornerRadius;
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setBackgroundCompat(this.getWidth(), this.getHeight());
        }
        return this;
    }

    public float getShadowLimit() {
        return this.mShadowLimit;
    }

    public ShadowLayout setShadowLimit(int mShadowLimit) {
        this.isExceptionByDashLine();
        this.mShadowLimit = mShadowLimit;
        if (this.isShowShadow) {
            this.setPadding();
        }
        return this;
    }

    @RequiresApi(api=16)
    public ShadowLayout setShadowColor(int mShadowColor) {
        this.isExceptionByDashLine();
        this.mShadowColor = mShadowColor;
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setBackgroundCompat(this.getWidth(), this.getHeight());
        }
        return this;
    }

    @RequiresApi(api=16)
    public ShadowLayout setSpecialCorner(int leftTop, int rightTop, int leftBottom, int rightBottom) {
        this.isExceptionByDashLine();
        this.mCornerRadius_leftTop = leftTop;
        this.mCornerRadius_rightTop = rightTop;
        this.mCornerRadius_leftBottom = leftBottom;
        this.mCornerRadius_rightBottom = rightBottom;
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setBackgroundCompat(this.getWidth(), this.getHeight());
        }
        return this;
    }

    public ShadowLayout setShadowHiddenTop(boolean topShow) {
        this.isExceptionByDashLine();
        this.topShow = !topShow;
        this.setPadding();
        return this;
    }

    public ShadowLayout setShadowHiddenBottom(boolean bottomShow) {
        this.isExceptionByDashLine();
        this.bottomShow = !bottomShow;
        this.setPadding();
        return this;
    }

    public ShadowLayout setShadowHiddenRight(boolean rightShow) {
        this.isExceptionByDashLine();
        this.rightShow = !rightShow;
        this.setPadding();
        return this;
    }

    public ShadowLayout setShadowHiddenLeft(boolean leftShow) {
        this.isExceptionByDashLine();
        this.leftShow = !leftShow;
        this.setPadding();
        return this;
    }

    @RequiresApi(api=16)
    public ShadowLayout setLayoutBackground(int color2) {
        this.isExceptionByDashLine();
        if (!this.isClickable) {
            return this;
        }
        if (this.layoutBackground_true != null) {
            throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground_true\u5c5e\u6027\uff0c\u8981\u4e0eShadowLayout_hl_layoutBackground\u5c5e\u6027\u7edf\u4e00\u4e3a\u989c\u8272");
        }
        this.mBackGroundColor = color2;
        this.startColor = -101;
        this.centerColor = -101;
        this.endColor = -101;
        if (this.shapeModeType == 2) {
            if (!this.isSelected()) {
                this.gradientDrawable.setColors(new int[]{this.mBackGroundColor, this.mBackGroundColor});
            }
        } else {
            this.gradientDrawable.setColors(new int[]{this.mBackGroundColor, this.mBackGroundColor});
        }
        this.postInvalidate();
        return this;
    }

    @RequiresApi(api=16)
    public ShadowLayout setLayoutBackgroundTrue(int color2) {
        this.isExceptionByDashLine();
        if (this.layoutBackground != null) {
            throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground\u5c5e\u6027\uff0c\u8981\u4e0eShadowLayout_hl_layoutBackground_true\u5c5e\u6027\u7edf\u4e00\u4e3a\u989c\u8272");
        }
        this.mBackGroundColor_true = color2;
        if (this.shapeModeType == 2 && this.isSelected()) {
            this.gradientDrawable.setColors(new int[]{this.mBackGroundColor_true, this.mBackGroundColor_true});
        }
        this.postInvalidate();
        return this;
    }

    public ShadowLayout setStrokeColor(int color2) {
        this.isExceptionByDashLine();
        this.stroke_color = color2;
        if (this.shapeModeType == 2) {
            if (!this.isSelected()) {
                this.current_stroke_color = this.stroke_color;
            }
        } else {
            this.current_stroke_color = this.stroke_color;
        }
        this.postInvalidate();
        return this;
    }

    public ShadowLayout setStrokeColorTrue(int color2) {
        this.isExceptionByDashLine();
        this.stroke_color_true = color2;
        if (this.shapeModeType == 2 && this.isSelected()) {
            this.current_stroke_color = this.stroke_color_true;
        }
        this.postInvalidate();
        return this;
    }

    public ShadowLayout setStrokeWidth(float stokeWidth) {
        this.isExceptionByDashLine();
        this.stroke_with = stokeWidth;
        this.postInvalidate();
        return this;
    }
}

