/*
 * Decompiled with CFR 0.152.
 */
package com.lihang;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.lihang.GlideRoundUtils;
import com.lihang.R;

public class ShadowLayout
extends FrameLayout {
    private Drawable clickAbleFalseDrawable;
    private int clickAbleFalseColor = -101;
    private Drawable layoutBackground;
    private Drawable layoutBackground_true;
    private View firstView;
    private int mBackGroundColor;
    private int mBackGroundColor_true = -101;
    private int mShadowColor;
    private float mShadowLimit;
    private float mCornerRadius;
    private float mDx;
    private float mDy;
    private boolean leftShow;
    private boolean rightShow;
    private boolean topShow;
    private boolean bottomShow;
    private Paint shadowPaint;
    private Paint paint;
    private int leftPadding;
    private int topPadding;
    private int rightPadding;
    private int bottomPadding;
    private RectF rectf = new RectF();
    private int selectorType = 1;
    private boolean isShowShadow = true;
    private boolean isSym;
    private float mCornerRadius_leftTop;
    private float mCornerRadius_rightTop;
    private float mCornerRadius_leftBottom;
    private float mCornerRadius_rightBottom;
    private Paint paint_stroke;
    private float stroke_with;
    private int stroke_color;
    private int stroke_color_true;
    private boolean isClickable;
    private int startColor;
    private int centerColor;
    private int endColor;
    private int angle;
    private int mTextViewResId = -1;
    private TextView mTextView;
    private int textColor;
    private int textColor_true;
    private String text;
    private String text_true;
    private View.OnClickListener onClickListener;

    public ShadowLayout(Context context) {
        this(context, null);
    }

    public ShadowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShadowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    public void setClickable(boolean clickable) {
        super.setClickable(clickable);
        this.isClickable = clickable;
        this.changeSwitchClickable();
        if (this.isClickable) {
            super.setOnClickListener(this.onClickListener);
        }
        if (this.paint != null && this.startColor != -101 && this.endColor != -101) {
            this.gradient(this.paint);
        }
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.onClickListener = l;
        if (this.isClickable) {
            super.setOnClickListener(l);
        }
    }

    public void changeSwitchClickable() {
        if (this.selectorType == 1 && this.firstView != null) {
            if (!this.isClickable) {
                if (this.clickAbleFalseColor != -101) {
                    if (this.layoutBackground != null) {
                        this.firstView.getBackground().setAlpha(0);
                    }
                    this.paint.setColor(this.clickAbleFalseColor);
                    this.postInvalidate();
                } else if (this.clickAbleFalseDrawable != null) {
                    this.setmBackGround(this.clickAbleFalseDrawable);
                    this.paint.setColor(Color.parseColor((String)"#00000000"));
                    this.postInvalidate();
                }
            } else {
                if (this.layoutBackground != null) {
                    this.setmBackGround(this.layoutBackground);
                } else if (this.firstView.getBackground() != null) {
                    this.firstView.getBackground().setAlpha(0);
                }
                this.paint.setColor(this.mBackGroundColor);
                this.postInvalidate();
            }
        }
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.getWidth() != 0) {
            if (this.selectorType == 2) {
                if (selected) {
                    if (this.mBackGroundColor_true != -101) {
                        this.paint.setColor(this.mBackGroundColor_true);
                    }
                    this.paint.setShader(null);
                    if (this.stroke_color_true != -101) {
                        this.paint_stroke.setColor(this.stroke_color_true);
                    }
                    if (this.layoutBackground_true != null) {
                        this.setmBackGround(this.layoutBackground_true);
                    }
                    if (this.mTextView != null) {
                        this.mTextView.setTextColor(this.textColor_true);
                        if (!TextUtils.isEmpty((CharSequence)this.text_true)) {
                            this.mTextView.setText((CharSequence)this.text_true);
                        }
                    }
                } else {
                    this.paint.setColor(this.mBackGroundColor);
                    if (this.startColor != -101) {
                        this.gradient(this.paint);
                    }
                    if (this.stroke_color != -101) {
                        this.paint_stroke.setColor(this.stroke_color);
                    }
                    if (this.layoutBackground != null) {
                        this.setmBackGround(this.layoutBackground);
                    }
                    if (this.mTextView != null) {
                        this.mTextView.setTextColor(this.textColor);
                        if (!TextUtils.isEmpty((CharSequence)this.text)) {
                            this.mTextView.setText((CharSequence)this.text);
                        }
                    }
                }
                this.postInvalidate();
            }
        } else {
            this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    ShadowLayout.this.removeOnLayoutChangeListener(this);
                    ShadowLayout.this.setSelected(ShadowLayout.this.isSelected());
                }
            });
        }
    }

    public void setShadowHidden(boolean isShowShadow) {
        boolean bl = this.isShowShadow = !isShowShadow;
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setBackgroundCompat(this.getWidth(), this.getHeight());
        }
    }

    public void setShadowOffsetX(float mDx) {
        if (this.isShowShadow) {
            this.mDx = Math.abs(mDx) > this.mShadowLimit ? (mDx > 0.0f ? this.mShadowLimit : -this.mShadowLimit) : mDx;
            this.setPadding();
        }
    }

    public void setShadowOffsetY(float mDy) {
        if (this.isShowShadow) {
            this.mDy = Math.abs(mDy) > this.mShadowLimit ? (mDy > 0.0f ? this.mShadowLimit : -this.mShadowLimit) : mDy;
            this.setPadding();
        }
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    public void setCornerRadius(int mCornerRadius) {
        this.mCornerRadius = mCornerRadius;
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setBackgroundCompat(this.getWidth(), this.getHeight());
        }
    }

    public float getShadowLimit() {
        return this.mShadowLimit;
    }

    public void setShadowLimit(int mShadowLimit) {
        if (this.isShowShadow) {
            int dip5 = (int)this.getContext().getResources().getDimension(R.dimen.dp_5);
            this.mShadowLimit = mShadowLimit >= dip5 ? (float)mShadowLimit : (float)dip5;
            this.setPadding();
        }
    }

    public void setShadowColor(int mShadowColor) {
        this.mShadowColor = mShadowColor;
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setBackgroundCompat(this.getWidth(), this.getHeight());
        }
    }

    public void setSpecialCorner(int leftTop, int rightTop, int leftBottom, int rightBottom) {
        this.mCornerRadius_leftTop = leftTop;
        this.mCornerRadius_rightTop = rightTop;
        this.mCornerRadius_leftBottom = leftBottom;
        this.mCornerRadius_rightBottom = rightBottom;
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setBackgroundCompat(this.getWidth(), this.getHeight());
        }
    }

    public void setShadowHiddenTop(boolean topShow) {
        this.topShow = !topShow;
        this.setPadding();
    }

    public void setShadowHiddenBottom(boolean bottomShow) {
        this.bottomShow = !bottomShow;
        this.setPadding();
    }

    public void setShadowHiddenRight(boolean rightShow) {
        this.rightShow = !rightShow;
        this.setPadding();
    }

    public void setShadowHiddenLeft(boolean leftShow) {
        this.leftShow = !leftShow;
        this.setPadding();
    }

    public void setLayoutBackground(int color2) {
        if (this.layoutBackground_true != null) {
            throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground_true\u5c5e\u6027\uff0c\u8981\u4e0eShadowLayout_hl_layoutBackground\u5c5e\u6027\u7edf\u4e00\u4e3a\u989c\u8272");
        }
        this.mBackGroundColor = color2;
        if (this.selectorType == 2) {
            if (!this.isSelected()) {
                this.paint.setColor(this.mBackGroundColor);
            }
        } else {
            this.paint.setColor(this.mBackGroundColor);
        }
        this.postInvalidate();
    }

    public void setLayoutBackgroundTrue(int color2) {
        if (this.layoutBackground != null) {
            throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground\u5c5e\u6027\uff0c\u8981\u4e0eShadowLayout_hl_layoutBackground_true\u5c5e\u6027\u7edf\u4e00\u4e3a\u989c\u8272");
        }
        this.mBackGroundColor_true = color2;
        if (this.selectorType == 2 && this.isSelected()) {
            this.paint.setColor(this.mBackGroundColor_true);
        }
        this.postInvalidate();
    }

    public void setStrokeColor(int color2) {
        this.stroke_color = color2;
        if (this.selectorType == 2) {
            if (!this.isSelected()) {
                this.paint_stroke.setColor(this.stroke_color);
            }
        } else {
            this.paint_stroke.setColor(this.stroke_color);
        }
        this.postInvalidate();
    }

    public void setStrokeColorTrue(int color2) {
        this.stroke_color_true = color2;
        if (this.selectorType == 2 && this.isSelected()) {
            this.paint_stroke.setColor(this.stroke_color_true);
        }
        this.postInvalidate();
    }

    public void setStrokeWidth(int stokeWidth) {
        this.stroke_with = stokeWidth;
        if (this.stroke_with > (float)this.dip2px(7.0f)) {
            this.stroke_with = this.dip2px(5.0f);
        }
        this.paint_stroke.setStrokeWidth(this.stroke_with);
        this.postInvalidate();
    }

    @RequiresApi(api=16)
    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mTextViewResId != -1) {
            this.mTextView = (TextView)this.findViewById(this.mTextViewResId);
            if (this.mTextView == null) {
                throw new NullPointerException("ShadowLayout\u627e\u4e0d\u5230hl_bindTextView\uff0c\u8bf7\u786e\u4fdd\u7ed1\u5b9a\u7684\u8d44\u6e90id\u5728ShadowLayout\u5185");
            }
            if (this.textColor == -101) {
                this.textColor = this.mTextView.getCurrentTextColor();
            }
            if (this.textColor_true == -101) {
                this.textColor_true = this.mTextView.getCurrentTextColor();
            }
            this.mTextView.setTextColor(this.textColor);
            if (!TextUtils.isEmpty((CharSequence)this.text)) {
                this.mTextView.setText((CharSequence)this.text);
            }
        }
        this.firstView = this.getChildAt(0);
        if (this.firstView == null) {
            this.firstView = this;
            this.isShowShadow = false;
        }
        if (this.firstView != null && this.selectorType != 2) {
            if (this.isClickable) {
                this.setmBackGround(this.layoutBackground);
            } else {
                this.setmBackGround(this.clickAbleFalseDrawable);
                if (this.clickAbleFalseColor != -101) {
                    this.paint.setColor(this.clickAbleFalseColor);
                }
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.setBackgroundCompat(w, h);
            if (this.startColor != -101) {
                this.gradient(this.paint);
            }
        }
    }

    private void initView(Context context, AttributeSet attrs) {
        this.initAttributes(attrs);
        this.shadowPaint = new Paint();
        this.shadowPaint.setAntiAlias(true);
        this.shadowPaint.setStyle(Paint.Style.FILL);
        this.paint_stroke = new Paint();
        this.paint_stroke.setAntiAlias(true);
        this.paint_stroke.setStyle(Paint.Style.STROKE);
        this.paint_stroke.setStrokeWidth(this.stroke_with);
        if (this.stroke_color != -101) {
            this.paint_stroke.setColor(this.stroke_color);
        }
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.mBackGroundColor);
        this.setPadding();
    }

    public void gradient(Paint paint) {
        int trueAngle;
        if (!this.isClickable) {
            paint.setShader(null);
            return;
        }
        int[] colors = this.centerColor == -101 ? new int[]{this.startColor, this.endColor} : new int[]{this.startColor, this.centerColor, this.endColor};
        if (this.angle < 0) {
            trueAngle = this.angle % 360;
            this.angle = trueAngle + 360;
        }
        trueAngle = this.angle % 360;
        int angleFlag = trueAngle / 45;
        switch (angleFlag) {
            case 0: {
                LinearGradient linearGradient = new LinearGradient((float)this.leftPadding, (float)this.topPadding, (float)(this.getWidth() - this.rightPadding), (float)this.topPadding, colors, null, Shader.TileMode.CLAMP);
                paint.setShader((Shader)linearGradient);
                break;
            }
            case 1: {
                LinearGradient linearGradient = new LinearGradient((float)this.leftPadding, (float)(this.getHeight() - this.bottomPadding), (float)(this.getWidth() - this.rightPadding), (float)this.topPadding, colors, null, Shader.TileMode.CLAMP);
                paint.setShader((Shader)linearGradient);
                break;
            }
            case 2: {
                int x_ = (this.getWidth() - this.rightPadding - this.leftPadding) / 2 + this.leftPadding;
                LinearGradient linearGradient = new LinearGradient((float)x_, (float)(this.getHeight() - this.bottomPadding), (float)x_, (float)this.topPadding, colors, null, Shader.TileMode.CLAMP);
                paint.setShader((Shader)linearGradient);
                break;
            }
            case 3: {
                LinearGradient linearGradient = new LinearGradient((float)(this.getWidth() - this.rightPadding), (float)(this.getHeight() - this.bottomPadding), (float)this.leftPadding, (float)this.topPadding, colors, null, Shader.TileMode.CLAMP);
                paint.setShader((Shader)linearGradient);
                break;
            }
            case 4: {
                LinearGradient linearGradient = new LinearGradient((float)(this.getWidth() - this.rightPadding), (float)this.topPadding, (float)this.leftPadding, (float)this.topPadding, colors, null, Shader.TileMode.CLAMP);
                paint.setShader((Shader)linearGradient);
                break;
            }
            case 5: {
                LinearGradient linearGradient = new LinearGradient((float)(this.getWidth() - this.rightPadding), (float)this.topPadding, (float)this.leftPadding, (float)(this.getHeight() - this.bottomPadding), colors, null, Shader.TileMode.CLAMP);
                paint.setShader((Shader)linearGradient);
                break;
            }
            case 6: {
                int x = (this.getWidth() - this.rightPadding - this.leftPadding) / 2 + this.leftPadding;
                LinearGradient linearGradient = new LinearGradient((float)x, (float)this.topPadding, (float)x, (float)(this.getHeight() - this.bottomPadding), colors, null, Shader.TileMode.CLAMP);
                paint.setShader((Shader)linearGradient);
                break;
            }
            case 7: {
                LinearGradient linearGradient = new LinearGradient((float)this.leftPadding, (float)this.topPadding, (float)(this.getWidth() - this.rightPadding), (float)(this.getHeight() - this.bottomPadding), colors, null, Shader.TileMode.CLAMP);
                paint.setShader((Shader)linearGradient);
            }
        }
    }

    public int dip2px(float dipValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public void setPadding() {
        if (this.isShowShadow && this.mShadowLimit > 0.0f) {
            if (this.isSym) {
                int xPadding = (int)(this.mShadowLimit + Math.abs(this.mDx));
                int yPadding = (int)(this.mShadowLimit + Math.abs(this.mDy));
                this.leftPadding = this.leftShow ? xPadding : 0;
                this.topPadding = this.topShow ? yPadding : 0;
                this.rightPadding = this.rightShow ? xPadding : 0;
                this.bottomPadding = this.bottomShow ? yPadding : 0;
            } else {
                if (Math.abs(this.mDy) > this.mShadowLimit) {
                    this.mDy = this.mDy > 0.0f ? this.mShadowLimit : 0.0f - this.mShadowLimit;
                }
                if (Math.abs(this.mDx) > this.mShadowLimit) {
                    this.mDx = this.mDx > 0.0f ? this.mShadowLimit : 0.0f - this.mShadowLimit;
                }
                this.topPadding = this.topShow ? (int)(this.mShadowLimit - this.mDy) : 0;
                this.bottomPadding = this.bottomShow ? (int)(this.mShadowLimit + this.mDy) : 0;
                this.rightPadding = this.rightShow ? (int)(this.mShadowLimit - this.mDx) : 0;
                this.leftPadding = this.leftShow ? (int)(this.mShadowLimit + this.mDx) : 0;
            }
            this.setPadding(this.leftPadding, this.topPadding, this.rightPadding, this.bottomPadding);
        }
    }

    private void setBackgroundCompat(int w, int h) {
        if (this.isShowShadow) {
            this.isAddAlpha(this.mShadowColor);
            Bitmap bitmap = this.createShadowBitmap(w, h, this.mCornerRadius, this.mShadowLimit, this.mDx, this.mDy, this.mShadowColor, 0);
            BitmapDrawable drawable = new BitmapDrawable(bitmap);
            if (Build.VERSION.SDK_INT <= 16) {
                this.setBackgroundDrawable((Drawable)drawable);
            } else {
                this.setBackground((Drawable)drawable);
            }
        } else if (this.getChildAt(0) == null) {
            if (this.layoutBackground != null) {
                this.firstView = this;
                if (this.isClickable) {
                    this.setmBackGround(this.layoutBackground);
                } else {
                    this.changeSwitchClickable();
                }
            } else {
                this.setBackgroundColor(Color.parseColor((String)"#00000000"));
            }
        } else {
            this.setBackgroundColor(Color.parseColor((String)"#00000000"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(AttributeSet attrs) {
        TypedArray attr2 = this.getContext().obtainStyledAttributes(attrs, R.styleable.ShadowLayout);
        if (attr2 == null) {
            return;
        }
        try {
            Drawable clickAbleFalseBackground;
            Drawable trueBackground;
            this.isShowShadow = !attr2.getBoolean(R.styleable.ShadowLayout_hl_shadowHidden, false);
            this.leftShow = !attr2.getBoolean(R.styleable.ShadowLayout_hl_shadowHiddenLeft, false);
            this.rightShow = !attr2.getBoolean(R.styleable.ShadowLayout_hl_shadowHiddenRight, false);
            this.bottomShow = !attr2.getBoolean(R.styleable.ShadowLayout_hl_shadowHiddenBottom, false);
            this.topShow = !attr2.getBoolean(R.styleable.ShadowLayout_hl_shadowHiddenTop, false);
            this.mCornerRadius = attr2.getDimension(R.styleable.ShadowLayout_hl_cornerRadius, this.getResources().getDimension(R.dimen.dp_0));
            this.mCornerRadius_leftTop = attr2.getDimension(R.styleable.ShadowLayout_hl_cornerRadius_leftTop, -1.0f);
            this.mCornerRadius_leftBottom = attr2.getDimension(R.styleable.ShadowLayout_hl_cornerRadius_leftBottom, -1.0f);
            this.mCornerRadius_rightTop = attr2.getDimension(R.styleable.ShadowLayout_hl_cornerRadius_rightTop, -1.0f);
            this.mCornerRadius_rightBottom = attr2.getDimension(R.styleable.ShadowLayout_hl_cornerRadius_rightBottom, -1.0f);
            this.mShadowLimit = attr2.getDimension(R.styleable.ShadowLayout_hl_shadowLimit, 0.0f);
            if (this.mShadowLimit == 0.0f) {
                this.isShowShadow = false;
            } else {
                int dip5 = (int)this.getContext().getResources().getDimension(R.dimen.dp_5);
                if (this.mShadowLimit < (float)dip5) {
                    this.mShadowLimit = dip5;
                }
            }
            this.mDx = attr2.getDimension(R.styleable.ShadowLayout_hl_shadowOffsetX, 0.0f);
            this.mDy = attr2.getDimension(R.styleable.ShadowLayout_hl_shadowOffsetY, 0.0f);
            this.mShadowColor = attr2.getColor(R.styleable.ShadowLayout_hl_shadowColor, this.getResources().getColor(R.color.default_shadow_color));
            this.selectorType = attr2.getInt(R.styleable.ShadowLayout_hl_shapeMode, 1);
            this.isSym = attr2.getBoolean(R.styleable.ShadowLayout_hl_shadowSymmetry, true);
            this.mBackGroundColor = this.getResources().getColor(R.color.default_shadowback_color);
            Drawable background = attr2.getDrawable(R.styleable.ShadowLayout_hl_layoutBackground);
            if (background != null) {
                if (background instanceof ColorDrawable) {
                    ColorDrawable colorDrawable = (ColorDrawable)background;
                    this.mBackGroundColor = colorDrawable.getColor();
                } else {
                    this.layoutBackground = background;
                }
            }
            if ((trueBackground = attr2.getDrawable(R.styleable.ShadowLayout_hl_layoutBackground_true)) != null) {
                if (trueBackground instanceof ColorDrawable) {
                    ColorDrawable colorDrawableTrue = (ColorDrawable)trueBackground;
                    this.mBackGroundColor_true = colorDrawableTrue.getColor();
                } else {
                    this.layoutBackground_true = trueBackground;
                }
            }
            if (this.mBackGroundColor_true != -101 && this.layoutBackground != null) {
                throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground_true\u5c5e\u6027\uff0c\u5fc5\u987b\u5148\u8bbe\u7f6eShadowLayout_hl_layoutBackground\u5c5e\u6027\u3002\u4e14\u8bbe\u7f6e\u989c\u8272\u65f6\uff0c\u5fc5\u987b\u4fdd\u6301\u90fd\u4e3a\u989c\u8272");
            }
            if (this.layoutBackground == null && this.layoutBackground_true != null) {
                throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground_true\u5c5e\u6027\uff0c\u5fc5\u987b\u5148\u8bbe\u7f6eShadowLayout_hl_layoutBackground\u5c5e\u6027\u3002\u4e14\u8bbe\u7f6e\u56fe\u7247\u65f6\uff0c\u5fc5\u987b\u4fdd\u6301\u90fd\u4e3a\u56fe\u7247");
            }
            this.stroke_color = attr2.getColor(R.styleable.ShadowLayout_hl_strokeColor, -101);
            this.stroke_color_true = attr2.getColor(R.styleable.ShadowLayout_hl_strokeColor_true, -101);
            if (this.stroke_color == -101 && this.stroke_color_true != -101) {
                throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_strokeColor_true\u5c5e\u6027\uff0c\u5fc5\u987b\u5148\u8bbe\u7f6eShadowLayout_hl_strokeColor\u5c5e\u6027");
            }
            this.stroke_with = attr2.getDimension(R.styleable.ShadowLayout_hl_strokeWith, (float)this.dip2px(1.0f));
            if (this.stroke_with > (float)this.dip2px(7.0f)) {
                this.stroke_with = this.dip2px(5.0f);
            }
            if ((clickAbleFalseBackground = attr2.getDrawable(R.styleable.ShadowLayout_hl_layoutBackground_clickFalse)) != null) {
                if (clickAbleFalseBackground instanceof ColorDrawable) {
                    ColorDrawable colorDrawableClickableFalse = (ColorDrawable)clickAbleFalseBackground;
                    this.clickAbleFalseColor = colorDrawableClickableFalse.getColor();
                } else {
                    this.clickAbleFalseDrawable = clickAbleFalseBackground;
                }
            }
            this.startColor = attr2.getColor(R.styleable.ShadowLayout_hl_startColor, -101);
            this.centerColor = attr2.getColor(R.styleable.ShadowLayout_hl_centerColor, -101);
            this.endColor = attr2.getColor(R.styleable.ShadowLayout_hl_endColor, -101);
            if (this.startColor != -101 && this.endColor == -101) {
                throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_startColor\u6e10\u53d8\u8d77\u59cb\u8272\uff0c\u5fc5\u987b\u642d\u914d\u7ec8\u6b62\u8272ShadowLayout_hl_endColor");
            }
            this.angle = attr2.getInt(R.styleable.ShadowLayout_hl_angle, 0);
            if (this.angle % 45 != 0) {
                throw new IllegalArgumentException("Linear gradient requires 'angle' attribute to be a multiple of 45");
            }
            if (this.selectorType == 3) {
                if (this.mBackGroundColor == -101 || this.mBackGroundColor_true == -101) {
                    throw new NullPointerException("\u4f7f\u7528\u4e86ShadowLayout\u7684\u6c34\u6ce2\u7eb9\uff0c\u5fc5\u987b\u8bbe\u7f6e\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground\u548c\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground_true\u5c5e\u6027\uff0c\u4e14\u4e3a\u989c\u8272\u503c");
                }
                if (this.layoutBackground != null) {
                    this.selectorType = 1;
                }
            }
            this.mTextViewResId = attr2.getResourceId(R.styleable.ShadowLayout_hl_bindTextView, -1);
            this.textColor = attr2.getColor(R.styleable.ShadowLayout_hl_textColor, -101);
            this.textColor_true = attr2.getColor(R.styleable.ShadowLayout_hl_textColor_true, -101);
            this.text = attr2.getString(R.styleable.ShadowLayout_hl_text);
            this.text_true = attr2.getString(R.styleable.ShadowLayout_hl_text_true);
            this.isClickable = attr2.getBoolean(R.styleable.ShadowLayout_clickable, true);
            this.setClickable(this.isClickable);
        }
        finally {
            attr2.recycle();
        }
    }

    private Bitmap createShadowBitmap(int shadowWidth, int shadowHeight, float cornerRadius, float shadowRadius, float dx, float dy, int shadowColor, int fillColor) {
        float maxRightBottom;
        float maxLeftTop;
        dx /= 4.0f;
        dy /= 4.0f;
        shadowWidth = shadowWidth / 4 == 0 ? 1 : shadowWidth / 4;
        shadowHeight = shadowHeight / 4 == 0 ? 1 : shadowHeight / 4;
        cornerRadius /= 4.0f;
        shadowRadius /= 4.0f;
        Bitmap output = Bitmap.createBitmap((int)shadowWidth, (int)shadowHeight, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(output);
        float rect_left = 0.0f;
        float rect_right = 0.0f;
        float rect_top = 0.0f;
        float rect_bottom = 0.0f;
        if (this.leftShow) {
            rect_left = shadowRadius;
        } else {
            float maxLeft;
            maxLeftTop = Math.max(cornerRadius, this.mCornerRadius_leftTop);
            float maxLeftBottom = Math.max(cornerRadius, this.mCornerRadius_leftBottom);
            rect_left = maxLeft = Math.max(maxLeftTop, maxLeftBottom);
        }
        if (this.topShow) {
            rect_top = shadowRadius;
        } else {
            float maxTop;
            maxLeftTop = Math.max(cornerRadius, this.mCornerRadius_leftTop);
            float maxRightTop = Math.max(cornerRadius, this.mCornerRadius_rightTop);
            rect_top = maxTop = Math.max(maxLeftTop, maxRightTop);
        }
        if (this.rightShow) {
            rect_right = (float)shadowWidth - shadowRadius;
        } else {
            float maxRightTop = Math.max(cornerRadius, this.mCornerRadius_rightTop);
            maxRightBottom = Math.max(cornerRadius, this.mCornerRadius_rightBottom);
            float maxRight = Math.max(maxRightTop, maxRightBottom);
            rect_right = (float)shadowWidth - maxRight;
        }
        if (this.bottomShow) {
            rect_bottom = (float)shadowHeight - shadowRadius;
        } else {
            float maxLeftBottom = Math.max(cornerRadius, this.mCornerRadius_leftBottom);
            maxRightBottom = Math.max(cornerRadius, this.mCornerRadius_rightBottom);
            float maxBottom = Math.max(maxLeftBottom, maxRightBottom);
            rect_bottom = (float)shadowHeight - maxBottom;
        }
        RectF shadowRect = new RectF(rect_left, rect_top, rect_right, rect_bottom);
        if (this.isSym) {
            if (dy > 0.0f) {
                shadowRect.top += dy;
                shadowRect.bottom -= dy;
            } else if (dy < 0.0f) {
                shadowRect.top += Math.abs(dy);
                shadowRect.bottom -= Math.abs(dy);
            }
            if (dx > 0.0f) {
                shadowRect.left += dx;
                shadowRect.right -= dx;
            } else if (dx < 0.0f) {
                shadowRect.left += Math.abs(dx);
                shadowRect.right -= Math.abs(dx);
            }
        } else {
            shadowRect.top -= dy;
            shadowRect.bottom -= dy;
            shadowRect.right -= dx;
            shadowRect.left -= dx;
        }
        this.shadowPaint.setColor(fillColor);
        if (!this.isInEditMode()) {
            this.shadowPaint.setShadowLayer(shadowRadius / 2.0f, dx, dy, shadowColor);
        }
        if (this.mCornerRadius_leftBottom == -1.0f && this.mCornerRadius_leftTop == -1.0f && this.mCornerRadius_rightTop == -1.0f && this.mCornerRadius_rightBottom == -1.0f) {
            canvas.drawRoundRect(shadowRect, cornerRadius, cornerRadius, this.shadowPaint);
        } else {
            this.rectf.left = this.leftPadding;
            this.rectf.top = this.topPadding;
            this.rectf.right = this.getWidth() - this.rightPadding;
            this.rectf.bottom = this.getHeight() - this.bottomPadding;
            this.shadowPaint.setAntiAlias(true);
            int leftTop = this.mCornerRadius_leftTop == -1.0f ? (int)this.mCornerRadius / 4 : (int)this.mCornerRadius_leftTop / 4;
            int leftBottom = this.mCornerRadius_leftBottom == -1.0f ? (int)this.mCornerRadius / 4 : (int)this.mCornerRadius_leftBottom / 4;
            int rightTop = this.mCornerRadius_rightTop == -1.0f ? (int)this.mCornerRadius / 4 : (int)this.mCornerRadius_rightTop / 4;
            int rightBottom = this.mCornerRadius_rightBottom == -1.0f ? (int)this.mCornerRadius / 4 : (int)this.mCornerRadius_rightBottom / 4;
            float[] outerR = new float[]{leftTop, leftTop, rightTop, rightTop, rightBottom, rightBottom, leftBottom, leftBottom};
            Path path = new Path();
            path.addRoundRect(shadowRect, outerR, Path.Direction.CW);
            canvas.drawPath(path, this.shadowPaint);
        }
        return output;
    }

    @RequiresApi(api=21)
    protected void dispatchDraw(Canvas canvas) {
        int trueHeight = (int)(this.rectf.bottom - this.rectf.top);
        if (this.getChildAt(0) != null) {
            if (this.mCornerRadius_leftTop == -1.0f && this.mCornerRadius_leftBottom == -1.0f && this.mCornerRadius_rightTop == -1.0f && this.mCornerRadius_rightBottom == -1.0f) {
                if (this.mCornerRadius > (float)(trueHeight / 2)) {
                    Path path = new Path();
                    path.addRoundRect(this.rectf, (float)(trueHeight / 2), (float)(trueHeight / 2), Path.Direction.CW);
                    canvas.clipPath(path);
                } else {
                    Path path = new Path();
                    path.addRoundRect(this.rectf, this.mCornerRadius, this.mCornerRadius, Path.Direction.CW);
                    canvas.clipPath(path);
                }
            } else {
                float[] outerR = this.getCornerValue(trueHeight);
                Path path = new Path();
                path.addRoundRect((float)this.leftPadding, (float)this.topPadding, (float)(this.getWidth() - this.rightPadding), (float)(this.getHeight() - this.bottomPadding), outerR, Path.Direction.CW);
                canvas.clipPath(path);
            }
        }
        super.dispatchDraw(canvas);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.rectf.left = this.leftPadding;
        this.rectf.top = this.topPadding;
        this.rectf.right = this.getWidth() - this.rightPadding;
        this.rectf.bottom = this.getHeight() - this.bottomPadding;
        int trueHeight = (int)(this.rectf.bottom - this.rectf.top);
        if (this.getChildAt(0) != null) {
            if (this.mCornerRadius_leftTop == -1.0f && this.mCornerRadius_leftBottom == -1.0f && this.mCornerRadius_rightTop == -1.0f && this.mCornerRadius_rightBottom == -1.0f) {
                if (this.mCornerRadius > (float)(trueHeight / 2)) {
                    if (this.selectorType != 3) {
                        if (this.layoutBackground == null && this.layoutBackground_true == null) {
                            canvas.drawRoundRect(this.rectf, (float)(trueHeight / 2), (float)(trueHeight / 2), this.paint);
                            if (this.stroke_color != -101) {
                                int the_height = (int)(this.rectf.bottom - this.rectf.top);
                                int the_height_stoke = (int)(this.rectf.bottom - this.stroke_with / 2.0f - this.rectf.top - this.stroke_with / 2.0f);
                                int trueCorner = trueHeight * the_height_stoke / 2 / the_height;
                                RectF rectFStroke = new RectF(this.rectf.left + this.stroke_with / 2.0f, this.rectf.top + this.stroke_with / 2.0f, this.rectf.right - this.stroke_with / 2.0f, this.rectf.bottom - this.stroke_with / 2.0f);
                                canvas.drawRoundRect(rectFStroke, (float)trueCorner, (float)trueCorner, this.paint_stroke);
                            }
                        }
                    } else if (Build.VERSION.SDK_INT >= 21) {
                        float[] outerR = this.getCornerValue(trueHeight);
                        this.ripple(outerR);
                    }
                } else if (this.selectorType != 3) {
                    if (this.layoutBackground == null && this.layoutBackground_true == null) {
                        canvas.drawRoundRect(this.rectf, this.mCornerRadius, this.mCornerRadius, this.paint);
                        if (this.stroke_color != -101) {
                            int the_height = (int)(this.rectf.bottom - this.rectf.top);
                            int the_height_stoke = (int)(this.rectf.bottom - this.stroke_with / 2.0f - this.rectf.top - this.stroke_with / 2.0f);
                            int trueCorner = (int)(this.mCornerRadius * (float)the_height_stoke / (float)the_height);
                            RectF rectFStroke = new RectF(this.rectf.left + this.stroke_with / 2.0f, this.rectf.top + this.stroke_with / 2.0f, this.rectf.right - this.stroke_with / 2.0f, this.rectf.bottom - this.stroke_with / 2.0f);
                            canvas.drawRoundRect(rectFStroke, (float)trueCorner, (float)trueCorner, this.paint_stroke);
                        }
                    }
                } else if (Build.VERSION.SDK_INT >= 21) {
                    float[] outerR = this.getCornerValue(trueHeight);
                    this.ripple(outerR);
                }
            } else if (this.layoutBackground == null && this.layoutBackground_true == null) {
                this.setSpaceCorner(canvas, trueHeight);
            }
        }
    }

    public float[] getCornerValue(int trueHeight) {
        int leftBottom;
        int rightBottom;
        int rightTop;
        int leftTop = this.mCornerRadius_leftTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftTop;
        if (leftTop > trueHeight / 2) {
            leftTop = trueHeight / 2;
        }
        if ((rightTop = this.mCornerRadius_rightTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightTop) > trueHeight / 2) {
            rightTop = trueHeight / 2;
        }
        if ((rightBottom = this.mCornerRadius_rightBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightBottom) > trueHeight / 2) {
            rightBottom = trueHeight / 2;
        }
        if ((leftBottom = this.mCornerRadius_leftBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftBottom) > trueHeight / 2) {
            leftBottom = trueHeight / 2;
        }
        float[] outerR = new float[]{leftTop, leftTop, rightTop, rightTop, rightBottom, rightBottom, leftBottom, leftBottom};
        return outerR;
    }

    public float[] getCornerValueOther(int trueHeight, int stokeWith) {
        int leftBottom;
        int rightBottom;
        int rightTop;
        int leftTop = this.mCornerRadius_leftTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftTop;
        if (leftTop > (trueHeight -= stokeWith * 2) / 2) {
            leftTop = trueHeight / 2;
        }
        if ((rightTop = this.mCornerRadius_rightTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightTop) > trueHeight / 2) {
            rightTop = trueHeight / 2;
        }
        if ((rightBottom = this.mCornerRadius_rightBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightBottom) > trueHeight / 2) {
            rightBottom = trueHeight / 2;
        }
        if ((leftBottom = this.mCornerRadius_leftBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftBottom) > trueHeight / 2) {
            leftBottom = trueHeight / 2;
        }
        float[] outerR = new float[]{leftTop -= stokeWith, leftTop, rightTop -= stokeWith, rightTop, rightBottom -= stokeWith, rightBottom, leftBottom -= stokeWith, leftBottom};
        return outerR;
    }

    private void setSpaceCorner(Canvas canvas, int trueHeight) {
        float[] outerR = this.getCornerValue(trueHeight);
        if (this.stroke_color != -101) {
            if (this.selectorType != 3) {
                ShapeDrawable mDrawables = new ShapeDrawable((Shape)new RoundRectShape(outerR, null, null));
                if (this.paint.getShader() != null) {
                    mDrawables.getPaint().setShader(this.paint.getShader());
                } else {
                    mDrawables.getPaint().setColor(this.paint.getColor());
                }
                mDrawables.setBounds(this.leftPadding, this.topPadding, this.getWidth() - this.rightPadding, this.getHeight() - this.bottomPadding);
                mDrawables.draw(canvas);
                float[] outerR_stroke = this.getCornerValueOther(trueHeight, (int)this.stroke_with);
                ShapeDrawable mDrawablesStroke = new ShapeDrawable((Shape)new RoundRectShape(outerR_stroke, null, null));
                mDrawablesStroke.getPaint().setColor(this.paint_stroke.getColor());
                mDrawablesStroke.getPaint().setStyle(Paint.Style.STROKE);
                mDrawablesStroke.getPaint().setStrokeWidth(this.stroke_with);
                mDrawablesStroke.setBounds((int)((float)this.leftPadding + this.stroke_with / 2.0f), (int)((float)this.topPadding + this.stroke_with / 2.0f), (int)((float)(this.getWidth() - this.rightPadding) - this.stroke_with / 2.0f), (int)((float)(this.getHeight() - this.bottomPadding) - this.stroke_with / 2.0f));
                mDrawablesStroke.draw(canvas);
            } else if (Build.VERSION.SDK_INT >= 21) {
                this.ripple(outerR);
            }
        } else if (this.selectorType != 3) {
            ShapeDrawable mDrawables = new ShapeDrawable((Shape)new RoundRectShape(outerR, null, null));
            if (this.paint.getShader() != null) {
                mDrawables.getPaint().setShader(this.paint.getShader());
            } else {
                mDrawables.getPaint().setColor(this.paint.getColor());
            }
            mDrawables.setBounds(this.leftPadding, this.topPadding, this.getWidth() - this.rightPadding, this.getHeight() - this.bottomPadding);
            mDrawables.draw(canvas);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.ripple(outerR);
        }
    }

    @RequiresApi(api=21)
    private void ripple(float[] outRadius) {
        int[][] stateList = new int[][]{{16842919}, {16842908}, {16843518}, new int[0]};
        int normalColor = this.mBackGroundColor;
        int pressedColor = this.mBackGroundColor_true;
        int[] stateColorList = new int[]{pressedColor, pressedColor, pressedColor, normalColor};
        ColorStateList colorStateList = new ColorStateList((int[][])stateList, stateColorList);
        RoundRectShape roundRectShape = new RoundRectShape(outRadius, null, null);
        ShapeDrawable maskDrawable = new ShapeDrawable();
        maskDrawable.setShape((Shape)roundRectShape);
        maskDrawable.getPaint().setStyle(Paint.Style.FILL);
        if (this.startColor != -101) {
            this.gradient(maskDrawable.getPaint());
        } else {
            maskDrawable.getPaint().setColor(normalColor);
        }
        ShapeDrawable contentDrawable = new ShapeDrawable();
        contentDrawable.setShape((Shape)roundRectShape);
        contentDrawable.getPaint().setStyle(Paint.Style.FILL);
        if (this.startColor != -101) {
            this.gradient(contentDrawable.getPaint());
        } else {
            contentDrawable.getPaint().setColor(normalColor);
        }
        RippleDrawable rippleDrawable = new RippleDrawable(colorStateList, (Drawable)contentDrawable, (Drawable)maskDrawable);
        this.firstView.setBackground((Drawable)rippleDrawable);
    }

    public void isAddAlpha(int color2) {
        if (Color.alpha((int)color2) == 255) {
            String red = Integer.toHexString(Color.red((int)color2));
            String green = Integer.toHexString(Color.green((int)color2));
            String blue = Integer.toHexString(Color.blue((int)color2));
            if (red.length() == 1) {
                red = "0" + red;
            }
            if (green.length() == 1) {
                green = "0" + green;
            }
            if (blue.length() == 1) {
                blue = "0" + blue;
            }
            String endColor = "#2a" + red + green + blue;
            this.mShadowColor = ShadowLayout.convertToColorInt(endColor);
        }
    }

    public static int convertToColorInt(String argb) throws IllegalArgumentException {
        if (!argb.startsWith("#")) {
            argb = "#" + argb;
        }
        return Color.parseColor((String)argb);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.selectorType == 3) {
            if (this.isClickable) {
                switch (event.getAction()) {
                    case 0: {
                        if (this.selectorType != 3 || this.mTextView == null) break;
                        this.mTextView.setTextColor(this.textColor_true);
                        if (TextUtils.isEmpty((CharSequence)this.text_true)) break;
                        this.mTextView.setText((CharSequence)this.text_true);
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (this.selectorType != 3 || this.mTextView == null) break;
                        this.mTextView.setTextColor(this.textColor);
                        if (TextUtils.isEmpty((CharSequence)this.text)) break;
                        this.mTextView.setText((CharSequence)this.text);
                    }
                }
            }
            return super.onTouchEvent(event);
        }
        if ((this.mBackGroundColor_true != -101 || this.stroke_color_true != -101 || this.layoutBackground_true != null) && this.isClickable) {
            switch (event.getAction()) {
                case 0: {
                    if (this.selectorType != 1) break;
                    if (this.mBackGroundColor_true != -101) {
                        this.paint.setColor(this.mBackGroundColor_true);
                        this.paint.setShader(null);
                    }
                    if (this.stroke_color_true != -101) {
                        this.paint_stroke.setColor(this.stroke_color_true);
                    }
                    if (this.layoutBackground_true != null) {
                        this.setmBackGround(this.layoutBackground_true);
                    }
                    this.postInvalidate();
                    if (this.mTextView == null) break;
                    this.mTextView.setTextColor(this.textColor_true);
                    if (TextUtils.isEmpty((CharSequence)this.text_true)) break;
                    this.mTextView.setText((CharSequence)this.text_true);
                    break;
                }
                case 1: 
                case 3: {
                    if (this.selectorType != 1) break;
                    this.paint.setColor(this.mBackGroundColor);
                    if (this.startColor != -101) {
                        this.gradient(this.paint);
                    }
                    if (this.stroke_color != -101) {
                        this.paint_stroke.setColor(this.stroke_color);
                    }
                    if (this.layoutBackground != null) {
                        this.setmBackGround(this.layoutBackground);
                    }
                    this.postInvalidate();
                    if (this.mTextView == null) break;
                    this.mTextView.setTextColor(this.textColor);
                    if (TextUtils.isEmpty((CharSequence)this.text)) break;
                    this.mTextView.setText((CharSequence)this.text);
                }
            }
        }
        return super.onTouchEvent(event);
    }

    public void setmBackGround(Drawable drawable) {
        if (this.firstView != null && drawable != null) {
            if (this.mCornerRadius_leftTop == -1.0f && this.mCornerRadius_leftBottom == -1.0f && this.mCornerRadius_rightTop == -1.0f && this.mCornerRadius_rightBottom == -1.0f) {
                GlideRoundUtils.setRoundCorner(this.firstView, drawable, this.mCornerRadius);
            } else {
                int leftTop = this.mCornerRadius_leftTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftTop;
                int leftBottom = this.mCornerRadius_leftBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftBottom;
                int rightTop = this.mCornerRadius_rightTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightTop;
                int rightBottom = this.mCornerRadius_rightBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightBottom;
                GlideRoundUtils.setCorners(this.firstView, drawable, leftTop, leftBottom, rightTop, rightBottom);
            }
        }
    }
}

