/*
 * Decompiled with CFR 0.152.
 */
package com.lihang;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.lihang.GlideRoundUtils;
import com.lihang.R;

public class ShadowLayout
extends FrameLayout {
    private Drawable clickAbleFalseDrawable;
    private int clickAbleFalseColor = -1;
    private Drawable layoutBackground;
    private Drawable layoutBackground_true;
    private View firstView;
    private int mBackGroundColor;
    private int mBackGroundColor_true = -1;
    private int mShadowColor;
    private float mShadowLimit;
    private float mCornerRadius;
    private float mDx;
    private float mDy;
    private boolean leftShow;
    private boolean rightShow;
    private boolean topShow;
    private boolean bottomShow;
    private Paint shadowPaint;
    private Paint paint;
    private int leftPadding;
    private int topPadding;
    private int rightPadding;
    private int bottomPadding;
    private RectF rectf = new RectF();
    private int selectorType = 1;
    private boolean isShowShadow = true;
    private boolean isSym;
    private float mCornerRadius_leftTop;
    private float mCornerRadius_rightTop;
    private float mCornerRadius_leftBottom;
    private float mCornerRadius_rightBottom;
    private Paint paint_stroke;
    private float stroke_with;
    private int stroke_color;
    private int stroke_color_true;
    private boolean isClickable;

    public ShadowLayout(Context context) {
        this(context, null);
    }

    public ShadowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShadowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    public void setClickable(boolean clickable) {
        super.setClickable(clickable);
        this.isClickable = clickable;
        this.changeSwitchClickable();
    }

    public void changeSwitchClickable() {
        if (this.selectorType == 1 && this.firstView != null) {
            if (!this.isClickable) {
                if (this.clickAbleFalseColor != -1) {
                    if (this.layoutBackground != null) {
                        this.firstView.getBackground().setAlpha(0);
                    }
                    this.paint.setColor(this.clickAbleFalseColor);
                    this.postInvalidate();
                } else if (this.clickAbleFalseDrawable != null) {
                    this.setmBackGround(this.clickAbleFalseDrawable);
                    this.paint.setColor(Color.parseColor((String)"#00000000"));
                    this.postInvalidate();
                }
            } else {
                if (this.layoutBackground != null) {
                    this.setmBackGround(this.layoutBackground);
                } else if (this.firstView.getBackground() != null) {
                    this.firstView.getBackground().setAlpha(0);
                }
                this.paint.setColor(this.mBackGroundColor);
                this.postInvalidate();
            }
        }
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.selectorType == 2) {
            if (selected) {
                if (this.mBackGroundColor_true != -1) {
                    this.paint.setColor(this.mBackGroundColor_true);
                }
                if (this.stroke_color_true != -1) {
                    this.paint_stroke.setColor(this.stroke_color_true);
                }
                if (this.layoutBackground_true != null) {
                    this.setmBackGround(this.layoutBackground_true);
                }
            } else {
                this.paint.setColor(this.mBackGroundColor);
                if (this.stroke_color != -1) {
                    this.paint_stroke.setColor(this.stroke_color);
                }
                if (this.layoutBackground != null) {
                    this.setmBackGround(this.layoutBackground);
                }
            }
            this.postInvalidate();
        }
    }

    public void setMDx(float mDx) {
        this.mDx = Math.abs(mDx) > this.mShadowLimit ? (mDx > 0.0f ? this.mShadowLimit : -this.mShadowLimit) : mDx;
        this.setPading();
    }

    public void setMDy(float mDy) {
        this.mDy = Math.abs(mDy) > this.mShadowLimit ? (mDy > 0.0f ? this.mShadowLimit : -this.mShadowLimit) : mDy;
        this.setPading();
    }

    public float getmCornerRadius() {
        return this.mCornerRadius;
    }

    public void setmCornerRadius(int mCornerRadius) {
        this.mCornerRadius = mCornerRadius;
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setBackgroundCompat(this.getWidth(), this.getHeight());
        }
    }

    public float getmShadowLimit() {
        return this.mShadowLimit;
    }

    public void setmShadowLimit(int mShadowLimit) {
        this.mShadowLimit = mShadowLimit;
        this.setPading();
    }

    public void setmShadowColor(int mShadowColor) {
        this.mShadowColor = mShadowColor;
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setBackgroundCompat(this.getWidth(), this.getHeight());
        }
    }

    public void setLeftShow(boolean leftShow) {
        this.leftShow = leftShow;
        this.setPading();
    }

    public void setRightShow(boolean rightShow) {
        this.rightShow = rightShow;
        this.setPading();
    }

    public void setTopShow(boolean topShow) {
        this.topShow = topShow;
        this.setPading();
    }

    public void setBottomShow(boolean bottomShow) {
        this.bottomShow = bottomShow;
        this.setPading();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.setBackgroundCompat(w, h);
        }
    }

    private void initView(Context context, AttributeSet attrs) {
        this.initAttributes(attrs);
        this.shadowPaint = new Paint();
        this.shadowPaint.setAntiAlias(true);
        this.shadowPaint.setStyle(Paint.Style.FILL);
        this.paint_stroke = new Paint();
        this.paint_stroke.setAntiAlias(true);
        this.paint_stroke.setStyle(Paint.Style.STROKE);
        this.paint_stroke.setStrokeWidth(this.stroke_with);
        if (this.stroke_color != -1) {
            this.paint_stroke.setColor(this.stroke_color);
        }
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.mBackGroundColor);
        this.setPading();
    }

    public int dip2px(float dipValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public void setPading() {
        if (this.isShowShadow && this.mShadowLimit > 0.0f) {
            if (this.isSym) {
                int xPadding = (int)(this.mShadowLimit + Math.abs(this.mDx));
                int yPadding = (int)(this.mShadowLimit + Math.abs(this.mDy));
                this.leftPadding = this.leftShow ? xPadding : 0;
                this.topPadding = this.topShow ? yPadding : 0;
                this.rightPadding = this.rightShow ? xPadding : 0;
                this.bottomPadding = this.bottomShow ? yPadding : 0;
            } else {
                if (Math.abs(this.mDy) > this.mShadowLimit) {
                    this.mDy = this.mDy > 0.0f ? this.mShadowLimit : 0.0f - this.mShadowLimit;
                }
                if (Math.abs(this.mDx) > this.mShadowLimit) {
                    this.mDx = this.mDx > 0.0f ? this.mShadowLimit : 0.0f - this.mShadowLimit;
                }
                this.topPadding = this.topShow ? (int)(this.mShadowLimit - this.mDy) : 0;
                this.bottomPadding = this.bottomShow ? (int)(this.mShadowLimit + this.mDy) : 0;
                this.rightPadding = this.rightShow ? (int)(this.mShadowLimit - this.mDx) : 0;
                this.leftPadding = this.leftShow ? (int)(this.mShadowLimit + this.mDx) : 0;
            }
            this.setPadding(this.leftPadding, this.topPadding, this.rightPadding, this.bottomPadding);
        }
    }

    private void setBackgroundCompat(int w, int h) {
        if (this.isShowShadow) {
            this.isAddAlpha(this.mShadowColor);
            Bitmap bitmap = this.createShadowBitmap(w, h, this.mCornerRadius, this.mShadowLimit, this.mDx, this.mDy, this.mShadowColor, 0);
            BitmapDrawable drawable = new BitmapDrawable(bitmap);
            if (Build.VERSION.SDK_INT <= 16) {
                this.setBackgroundDrawable((Drawable)drawable);
            } else {
                this.setBackground((Drawable)drawable);
            }
        } else if (this.getChildAt(0) == null) {
            if (this.layoutBackground != null) {
                this.firstView = this;
                if (this.isClickable) {
                    this.setmBackGround(this.layoutBackground);
                } else {
                    this.changeSwitchClickable();
                }
            } else {
                this.setBackgroundColor(Color.parseColor((String)"#00000000"));
            }
        } else {
            this.setBackgroundColor(Color.parseColor((String)"#00000000"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(AttributeSet attrs) {
        TypedArray attr = this.getContext().obtainStyledAttributes(attrs, R.styleable.ShadowLayout);
        if (attr == null) {
            return;
        }
        try {
            Drawable clickAbleFalseBackground;
            Drawable trueBackground;
            this.isShowShadow = !attr.getBoolean(R.styleable.ShadowLayout_hl_shadowHidden, false);
            this.leftShow = !attr.getBoolean(R.styleable.ShadowLayout_hl_shadowHiddenLeft, false);
            this.rightShow = !attr.getBoolean(R.styleable.ShadowLayout_hl_shadowHiddenRight, false);
            this.bottomShow = !attr.getBoolean(R.styleable.ShadowLayout_hl_shadowHiddenBottom, false);
            this.topShow = !attr.getBoolean(R.styleable.ShadowLayout_hl_shadowHiddenTop, false);
            this.mCornerRadius = attr.getDimension(R.styleable.ShadowLayout_hl_cornerRadius, this.getResources().getDimension(R.dimen.dp_0));
            this.mCornerRadius_leftTop = attr.getDimension(R.styleable.ShadowLayout_hl_cornerRadius_leftTop, -1.0f);
            this.mCornerRadius_leftBottom = attr.getDimension(R.styleable.ShadowLayout_hl_cornerRadius_leftBottom, -1.0f);
            this.mCornerRadius_rightTop = attr.getDimension(R.styleable.ShadowLayout_hl_cornerRadius_rightTop, -1.0f);
            this.mCornerRadius_rightBottom = attr.getDimension(R.styleable.ShadowLayout_hl_cornerRadius_rightBottom, -1.0f);
            this.mShadowLimit = attr.getDimension(R.styleable.ShadowLayout_hl_shadowLimit, 0.0f);
            if (this.mShadowLimit == 0.0f) {
                this.isShowShadow = false;
            }
            this.mDx = attr.getDimension(R.styleable.ShadowLayout_hl_shadowOffsetX, 0.0f);
            this.mDy = attr.getDimension(R.styleable.ShadowLayout_hl_shadowOffsetY, 0.0f);
            this.mShadowColor = attr.getColor(R.styleable.ShadowLayout_hl_shadowColor, this.getResources().getColor(R.color.default_shadow_color));
            this.selectorType = attr.getInt(R.styleable.ShadowLayout_hl_shapeMode, 1);
            this.isSym = attr.getBoolean(R.styleable.ShadowLayout_hl_shadowSymmetry, true);
            this.mBackGroundColor = this.getResources().getColor(R.color.default_shadowback_color);
            Drawable background = attr.getDrawable(R.styleable.ShadowLayout_hl_layoutBackground);
            if (background != null) {
                if (background instanceof ColorDrawable) {
                    ColorDrawable colordDrawable = (ColorDrawable)background;
                    this.mBackGroundColor = colordDrawable.getColor();
                } else {
                    this.layoutBackground = background;
                }
            }
            if ((trueBackground = attr.getDrawable(R.styleable.ShadowLayout_hl_layoutBackground_true)) != null) {
                if (trueBackground instanceof ColorDrawable) {
                    ColorDrawable colordDrawableTrue = (ColorDrawable)trueBackground;
                    this.mBackGroundColor_true = colordDrawableTrue.getColor();
                } else {
                    this.layoutBackground_true = trueBackground;
                }
            }
            if (this.mBackGroundColor_true != -1 && this.layoutBackground != null) {
                throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground_true\u5c5e\u6027\uff0c\u5fc5\u987b\u5148\u8bbe\u7f6eShadowLayout_hl_layoutBackground\u5c5e\u6027\u3002\u4e14\u8bbe\u7f6e\u989c\u8272\u65f6\uff0c\u5fc5\u987b\u4fdd\u6301\u90fd\u4e3a\u989c\u8272");
            }
            if (this.layoutBackground == null && this.layoutBackground_true != null) {
                throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_layoutBackground_true\u5c5e\u6027\uff0c\u5fc5\u987b\u5148\u8bbe\u7f6eShadowLayout_hl_layoutBackground\u5c5e\u6027\u3002\u4e14\u8bbe\u7f6e\u56fe\u7247\u65f6\uff0c\u5fc5\u987b\u4fdd\u6301\u90fd\u4e3a\u56fe\u7247");
            }
            this.stroke_color = attr.getColor(R.styleable.ShadowLayout_hl_strokeColor, -1);
            this.stroke_color_true = attr.getColor(R.styleable.ShadowLayout_hl_strokeColor_true, -1);
            if (this.stroke_color == -1 && this.stroke_color_true != -1) {
                throw new UnsupportedOperationException("\u4f7f\u7528\u4e86ShadowLayout_hl_strokeColor_true\u5c5e\u6027\uff0c\u5fc5\u987b\u5148\u8bbe\u7f6eShadowLayout_hl_strokeColor\u5c5e\u6027");
            }
            this.stroke_with = attr.getDimension(R.styleable.ShadowLayout_hl_strokeWith, (float)this.dip2px(1.0f));
            if (this.stroke_with > (float)this.dip2px(7.0f)) {
                this.stroke_with = this.dip2px(5.0f);
            }
            if ((clickAbleFalseBackground = attr.getDrawable(R.styleable.ShadowLayout_hl_layoutBackgroundClickableFalse)) != null) {
                if (clickAbleFalseBackground instanceof ColorDrawable) {
                    ColorDrawable colordDrawableClickableFalse = (ColorDrawable)clickAbleFalseBackground;
                    this.clickAbleFalseColor = colordDrawableClickableFalse.getColor();
                } else {
                    this.clickAbleFalseDrawable = clickAbleFalseBackground;
                }
            }
            this.isClickable = true;
            this.setClickable(true);
        }
        finally {
            attr.recycle();
        }
    }

    @RequiresApi(api=16)
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.firstView = this.getChildAt(0);
        if (this.firstView != null && this.layoutBackground != null) {
            if (this.isClickable) {
                this.setmBackGround(this.layoutBackground);
            } else {
                this.changeSwitchClickable();
            }
        }
    }

    private Bitmap createShadowBitmap(int shadowWidth, int shadowHeight, float cornerRadius, float shadowRadius, float dx, float dy, int shadowColor, int fillColor) {
        dx /= 4.0f;
        dy /= 4.0f;
        cornerRadius /= 4.0f;
        Bitmap output = Bitmap.createBitmap((int)(shadowWidth /= 4), (int)(shadowHeight /= 4), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(output);
        RectF shadowRect = new RectF(shadowRadius /= 4.0f, shadowRadius, (float)shadowWidth - shadowRadius, (float)shadowHeight - shadowRadius);
        if (this.isSym) {
            if (dy > 0.0f) {
                shadowRect.top += dy;
                shadowRect.bottom -= dy;
            } else if (dy < 0.0f) {
                shadowRect.top += Math.abs(dy);
                shadowRect.bottom -= Math.abs(dy);
            }
            if (dx > 0.0f) {
                shadowRect.left += dx;
                shadowRect.right -= dx;
            } else if (dx < 0.0f) {
                shadowRect.left += Math.abs(dx);
                shadowRect.right -= Math.abs(dx);
            }
        } else {
            shadowRect.top -= dy;
            shadowRect.bottom -= dy;
            shadowRect.right -= dx;
            shadowRect.left -= dx;
        }
        this.shadowPaint.setColor(fillColor);
        if (!this.isInEditMode()) {
            this.shadowPaint.setShadowLayer(shadowRadius, dx, dy, shadowColor);
        }
        if (this.mCornerRadius_leftBottom == -1.0f && this.mCornerRadius_leftTop == -1.0f && this.mCornerRadius_rightTop == -1.0f && this.mCornerRadius_rightBottom == -1.0f) {
            canvas.drawRoundRect(shadowRect, cornerRadius, cornerRadius, this.shadowPaint);
        } else {
            this.rectf.left = this.leftPadding;
            this.rectf.top = this.topPadding;
            this.rectf.right = this.getWidth() - this.rightPadding;
            this.rectf.bottom = this.getHeight() - this.bottomPadding;
            this.shadowPaint.setAntiAlias(true);
            int leftTop = this.mCornerRadius_leftTop == -1.0f ? (int)this.mCornerRadius / 4 : (int)this.mCornerRadius_leftTop / 4;
            int leftBottom = this.mCornerRadius_leftBottom == -1.0f ? (int)this.mCornerRadius / 4 : (int)this.mCornerRadius_leftBottom / 4;
            int rightTop = this.mCornerRadius_rightTop == -1.0f ? (int)this.mCornerRadius / 4 : (int)this.mCornerRadius_rightTop / 4;
            int rightBottom = this.mCornerRadius_rightBottom == -1.0f ? (int)this.mCornerRadius / 4 : (int)this.mCornerRadius_rightBottom / 4;
            float[] outerR = new float[]{leftTop, leftTop, rightTop, rightTop, rightBottom, rightBottom, leftBottom, leftBottom};
            Path path = new Path();
            path.addRoundRect(shadowRect, outerR, Path.Direction.CW);
            canvas.drawPath(path, this.shadowPaint);
        }
        return output;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.rectf.left = this.leftPadding;
        this.rectf.top = this.topPadding;
        this.rectf.right = this.getWidth() - this.rightPadding;
        this.rectf.bottom = this.getHeight() - this.bottomPadding;
        int trueHeight = (int)(this.rectf.bottom - this.rectf.top);
        if (this.getChildAt(0) != null) {
            if (this.mCornerRadius_leftTop == -1.0f && this.mCornerRadius_leftBottom == -1.0f && this.mCornerRadius_rightTop == -1.0f && this.mCornerRadius_rightBottom == -1.0f) {
                if (this.mCornerRadius > (float)(trueHeight / 2)) {
                    canvas.drawRoundRect(this.rectf, (float)(trueHeight / 2), (float)(trueHeight / 2), this.paint);
                    if (this.stroke_color != -1) {
                        RectF rectFStroke = new RectF(this.rectf.left + this.stroke_with / 2.0f, this.rectf.top + this.stroke_with / 2.0f, this.rectf.right - this.stroke_with / 2.0f, this.rectf.bottom - this.stroke_with / 2.0f);
                        canvas.drawRoundRect(rectFStroke, (float)(trueHeight / 2), (float)(trueHeight / 2), this.paint_stroke);
                    }
                } else {
                    canvas.drawRoundRect(this.rectf, this.mCornerRadius, this.mCornerRadius, this.paint);
                    if (this.stroke_color != -1) {
                        RectF rectFStroke = new RectF(this.rectf.left + this.stroke_with / 2.0f, this.rectf.top + this.stroke_with / 2.0f, this.rectf.right - this.stroke_with / 2.0f, this.rectf.bottom - this.stroke_with / 2.0f);
                        canvas.drawRoundRect(rectFStroke, this.mCornerRadius, this.mCornerRadius, this.paint_stroke);
                    }
                }
            } else {
                this.setSpaceCorner(canvas, trueHeight);
            }
        }
    }

    private void setSpaceCorner(Canvas canvas, int trueHeight) {
        int leftBottom;
        int rightBottom;
        int rightTop;
        int leftTop = this.mCornerRadius_leftTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftTop;
        if (leftTop > trueHeight / 2) {
            leftTop = trueHeight / 2;
        }
        if ((rightTop = this.mCornerRadius_rightTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightTop) > trueHeight / 2) {
            rightTop = trueHeight / 2;
        }
        if ((rightBottom = this.mCornerRadius_rightBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightBottom) > trueHeight / 2) {
            rightBottom = trueHeight / 2;
        }
        if ((leftBottom = this.mCornerRadius_leftBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftBottom) > trueHeight / 2) {
            leftBottom = trueHeight / 2;
        }
        float[] outerR = new float[]{leftTop, leftTop, rightTop, rightTop, rightBottom, rightBottom, leftBottom, leftBottom};
        if (this.stroke_color != -1) {
            ShapeDrawable mDrawables = new ShapeDrawable((Shape)new RoundRectShape(outerR, null, null));
            mDrawables.getPaint().setColor(this.paint.getColor());
            mDrawables.setBounds(this.leftPadding, this.topPadding, this.getWidth() - this.rightPadding, this.getHeight() - this.bottomPadding);
            mDrawables.draw(canvas);
            ShapeDrawable mDrawablesStroke = new ShapeDrawable((Shape)new RoundRectShape(outerR, null, null));
            mDrawablesStroke.getPaint().setColor(this.paint_stroke.getColor());
            mDrawablesStroke.getPaint().setStyle(Paint.Style.STROKE);
            mDrawablesStroke.getPaint().setStrokeWidth(this.stroke_with);
            mDrawablesStroke.setBounds((int)((float)this.leftPadding + this.stroke_with / 2.0f), (int)((float)this.topPadding + this.stroke_with / 2.0f), (int)((float)(this.getWidth() - this.rightPadding) - this.stroke_with / 2.0f), (int)((float)(this.getHeight() - this.bottomPadding) - this.stroke_with / 2.0f));
            mDrawablesStroke.draw(canvas);
        } else {
            ShapeDrawable mDrawables = new ShapeDrawable((Shape)new RoundRectShape(outerR, null, null));
            mDrawables.getPaint().setColor(this.paint.getColor());
            mDrawables.setBounds(this.leftPadding, this.topPadding, this.getWidth() - this.rightPadding, this.getHeight() - this.bottomPadding);
            mDrawables.draw(canvas);
        }
    }

    public void isAddAlpha(int color2) {
        if (Color.alpha((int)color2) == 255) {
            String red = Integer.toHexString(Color.red((int)color2));
            String green = Integer.toHexString(Color.green((int)color2));
            String blue = Integer.toHexString(Color.blue((int)color2));
            if (red.length() == 1) {
                red = "0" + red;
            }
            if (green.length() == 1) {
                green = "0" + green;
            }
            if (blue.length() == 1) {
                blue = "0" + blue;
            }
            String endColor = "#2a" + red + green + blue;
            this.mShadowColor = ShadowLayout.convertToColorInt(endColor);
        }
    }

    public static int convertToColorInt(String argb) throws IllegalArgumentException {
        if (!argb.startsWith("#")) {
            argb = "#" + argb;
        }
        return Color.parseColor((String)argb);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if ((this.mBackGroundColor_true != -1 || this.stroke_color_true != -1 || this.layoutBackground_true != null) && this.isClickable) {
            switch (event.getAction()) {
                case 0: {
                    if (this.selectorType != 1) break;
                    if (this.mBackGroundColor_true != -1) {
                        this.paint.setColor(this.mBackGroundColor_true);
                    }
                    if (this.stroke_color_true != -1) {
                        this.paint_stroke.setColor(this.stroke_color_true);
                    }
                    if (this.layoutBackground_true != null) {
                        this.setmBackGround(this.layoutBackground_true);
                    }
                    this.postInvalidate();
                    break;
                }
                case 1: 
                case 3: {
                    if (this.selectorType == 1) {
                        this.paint.setColor(this.mBackGroundColor);
                        if (this.stroke_color != -1) {
                            this.paint_stroke.setColor(this.stroke_color);
                        }
                        if (this.layoutBackground != null) {
                            this.setmBackGround(this.layoutBackground);
                        }
                        this.postInvalidate();
                        break;
                    }
                    this.setSelected(!this.isSelected());
                }
            }
        }
        return super.onTouchEvent(event);
    }

    public void setmBackGround(Drawable drawable) {
        if (this.firstView != null && drawable != null) {
            if (this.mCornerRadius_leftTop == -1.0f && this.mCornerRadius_leftBottom == -1.0f && this.mCornerRadius_rightTop == -1.0f && this.mCornerRadius_rightBottom == -1.0f) {
                GlideRoundUtils.setRoundCorner(this.firstView, drawable, this.mCornerRadius);
            } else {
                int leftTop = this.mCornerRadius_leftTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftTop;
                int leftBottom = this.mCornerRadius_leftBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_leftBottom;
                int rightTop = this.mCornerRadius_rightTop == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightTop;
                int rightBottom = this.mCornerRadius_rightBottom == -1.0f ? (int)this.mCornerRadius : (int)this.mCornerRadius_rightBottom;
                GlideRoundUtils.setCorners(this.firstView, drawable, leftTop, leftBottom, rightTop, rightBottom);
            }
        }
    }
}

