/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.toolbox.swing;

import javax.swing.SwingUtilities;

public abstract class EventDispatchingThread {
    private Object value;
    private ThreadWrapper thread;

    public EventDispatchingThread() {
        Runnable doFinished = this::finished;
        Runnable doConstruct = () -> {
            try {
                this.value = this.construct();
            }
            finally {
                this.thread.clear();
            }
            SwingUtilities.invokeLater(doFinished);
        };
        Thread t = new Thread(doConstruct);
        this.thread = new ThreadWrapper(t);
    }

    public abstract Object construct();

    public void start() {
        Thread t = this.thread.get();
        if (t != null) {
            t.start();
        }
    }

    public void interrupt() {
        Thread t = this.thread.get();
        if (t != null) {
            t.interrupt();
        }
        this.thread.clear();
    }

    public void finished() {
    }

    public Object get() {
        Thread t;
        while ((t = this.thread.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.value;
    }

    private static class ThreadWrapper {
        private Thread thread;

        ThreadWrapper(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

