/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.toolbox.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;
import org.openpdf.text.Document;
import org.openpdf.text.DocumentException;
import org.openpdf.text.pdf.PdfContentByte;
import org.openpdf.text.pdf.PdfImportedPage;
import org.openpdf.text.pdf.PdfReader;
import org.openpdf.text.pdf.PdfTemplate;
import org.openpdf.text.pdf.PdfWriter;
import org.openpdf.toolbox.AbstractTool;
import org.openpdf.toolbox.arguments.AbstractArgument;
import org.openpdf.toolbox.arguments.FileArgument;
import org.openpdf.toolbox.arguments.IntegerArgument;
import org.openpdf.toolbox.arguments.filters.PdfFilter;
import org.openpdf.toolbox.swing.PdfInformationPanel;

public class Split
extends AbstractTool {
    public Split() {
        FileArgument f = new FileArgument(this, "srcfile", "The file you want to split", false, new PdfFilter());
        f.setLabel(new PdfInformationPanel());
        this.arguments.add(f);
        this.arguments.add(new FileArgument(this, "destfile1", "The file to which the first part of the original PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile2", "The file to which the second part of the original PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new IntegerArgument(this, "pagenumber", "The pagenumber where you want to split"));
    }

    public static void main(String[] args) {
        Split tool = new Split();
        if (args.length < 4) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Split", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Split OPENED ===");
    }

    @Override
    public void execute() {
        try {
            int rotation;
            PdfImportedPage page;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            if (this.getValue("destfile1") == null) {
                throw new InstantiationException("You need to choose a destination file for the first part of the PDF");
            }
            File file1 = (File)this.getValue("destfile1");
            if (this.getValue("destfile2") == null) {
                throw new InstantiationException("You need to choose a destination file for the second part of the PDF");
            }
            File file2 = (File)this.getValue("destfile2");
            int pagenumber = Integer.parseInt((String)this.getValue("pagenumber"));
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            int n = reader.getNumberOfPages();
            System.out.println("There are " + n + " pages in the original file.");
            if (pagenumber < 2 || pagenumber > n) {
                throw new DocumentException("You can't split this document at page " + pagenumber + "; there is no such page.");
            }
            Document document1 = new Document(reader.getPageSizeWithRotation(1));
            Document document2 = new Document(reader.getPageSizeWithRotation(pagenumber));
            PdfWriter writer1 = PdfWriter.getInstance((Document)document1, (OutputStream)new FileOutputStream(file1));
            PdfWriter writer2 = PdfWriter.getInstance((Document)document2, (OutputStream)new FileOutputStream(file2));
            document1.open();
            PdfContentByte cb1 = writer1.getDirectContent();
            document2.open();
            PdfContentByte cb2 = writer2.getDirectContent();
            int i = 0;
            while (i < pagenumber - 1) {
                document1.setPageSize(reader.getPageSizeWithRotation(++i));
                document1.newPage();
                page = writer1.getImportedPage(reader, i);
                rotation = reader.getPageRotation(i);
                if (rotation == 90 || rotation == 270) {
                    cb1.addTemplate((PdfTemplate)page, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, reader.getPageSizeWithRotation(i).getHeight());
                    continue;
                }
                cb1.addTemplate((PdfTemplate)page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            while (i < n) {
                document2.setPageSize(reader.getPageSizeWithRotation(++i));
                document2.newPage();
                page = writer2.getImportedPage(reader, i);
                rotation = reader.getPageRotation(i);
                if (rotation == 90 || rotation == 270) {
                    cb2.addTemplate((PdfTemplate)page, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, reader.getPageSizeWithRotation(i).getHeight());
                    continue;
                }
                cb2.addTemplate((PdfTemplate)page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            document1.close();
            document2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile1");
    }

    static {
        Split.addVersion("$Id: Split.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

