/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.toolbox.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JInternalFrame;
import org.openpdf.text.Document;
import org.openpdf.text.pdf.PdfCopy;
import org.openpdf.text.pdf.PdfImportedPage;
import org.openpdf.text.pdf.PdfReader;
import org.openpdf.text.pdf.SimpleBookmark;
import org.openpdf.toolbox.AbstractTool;
import org.openpdf.toolbox.arguments.AbstractArgument;
import org.openpdf.toolbox.arguments.FileArgument;
import org.openpdf.toolbox.arguments.filters.PdfFilter;

public class Concat
extends AbstractTool {
    public Concat() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile1", "The first PDF file", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "srcfile2", "The second PDF file", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the concatenated PDF has to be written", true, new PdfFilter()));
    }

    public static void main(String[] args) {
        Concat tool = new Concat();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Concatenate 2 PDF files", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Concat OPENED ===");
    }

    @Override
    public void execute() {
        try {
            String[] files = new String[2];
            if (this.getValue("srcfile1") == null) {
                throw new InstantiationException("You need to choose a first sourcefile");
            }
            files[0] = ((File)this.getValue("srcfile1")).getAbsolutePath();
            if (this.getValue("srcfile2") == null) {
                throw new InstantiationException("You need to choose a second sourcefile");
            }
            files[1] = ((File)this.getValue("srcfile2")).getAbsolutePath();
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File pdf_file = (File)this.getValue("destfile");
            int pageOffset = 0;
            ArrayList master = new ArrayList();
            Document document = null;
            PdfCopy writer = null;
            for (int i = 0; i < 2; ++i) {
                PdfReader reader = new PdfReader(files[i]);
                reader.consolidateNamedDestinations();
                int n = reader.getNumberOfPages();
                List bookmarks = SimpleBookmark.getBookmarkList((PdfReader)reader);
                if (bookmarks != null) {
                    if (pageOffset != 0) {
                        SimpleBookmark.shiftPageNumbersInRange((List)bookmarks, (int)pageOffset, null);
                    }
                    master.addAll(bookmarks);
                }
                pageOffset += n;
                System.out.println("There are " + n + " pages in " + files[i]);
                if (i == 0) {
                    document = new Document(reader.getPageSizeWithRotation(1));
                    writer = new PdfCopy(document, (OutputStream)new FileOutputStream(pdf_file));
                    document.open();
                }
                int p = 0;
                while (p < n) {
                    PdfImportedPage page = writer.getImportedPage(reader, ++p);
                    writer.addPage(page);
                    System.out.println("Processed page " + p);
                }
            }
            if (!master.isEmpty()) {
                writer.setOutlines(master);
            }
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        Concat.addVersion("$Id: Concat.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

