/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.tools;

import java.io.FileOutputStream;
import java.io.OutputStream;
import org.openpdf.text.Document;
import org.openpdf.text.DocumentException;
import org.openpdf.text.error_messages.MessageLocalization;
import org.openpdf.text.pdf.PdfContentByte;
import org.openpdf.text.pdf.PdfImportedPage;
import org.openpdf.text.pdf.PdfReader;
import org.openpdf.text.pdf.PdfTemplate;
import org.openpdf.text.pdf.PdfWriter;

public class SplitPdf {
    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("arguments: srcfile destfile1 destfile2 pagenumber");
        } else {
            try {
                int rotation;
                PdfImportedPage page;
                int pagenumber = Integer.parseInt(args[3]);
                PdfReader reader = new PdfReader(args[0]);
                int n = reader.getNumberOfPages();
                System.out.println("There are " + n + " pages in the original file.");
                if (pagenumber < 2 || pagenumber > n) {
                    throw new DocumentException(MessageLocalization.getComposedMessage((String)"you.can.t.split.this.document.at.page.1.there.is.no.such.page", (int)pagenumber));
                }
                Document document1 = new Document(reader.getPageSizeWithRotation(1));
                Document document2 = new Document(reader.getPageSizeWithRotation(pagenumber));
                PdfWriter writer1 = PdfWriter.getInstance((Document)document1, (OutputStream)new FileOutputStream(args[1]));
                PdfWriter writer2 = PdfWriter.getInstance((Document)document2, (OutputStream)new FileOutputStream(args[2]));
                document1.open();
                PdfContentByte cb1 = writer1.getDirectContent();
                document2.open();
                PdfContentByte cb2 = writer2.getDirectContent();
                int i = 0;
                while (i < pagenumber - 1) {
                    document1.setPageSize(reader.getPageSizeWithRotation(++i));
                    document1.newPage();
                    page = writer1.getImportedPage(reader, i);
                    rotation = reader.getPageRotation(i);
                    if (rotation == 90 || rotation == 270) {
                        cb1.addTemplate((PdfTemplate)page, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, reader.getPageSizeWithRotation(i).getHeight());
                        continue;
                    }
                    cb1.addTemplate((PdfTemplate)page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                }
                while (i < n) {
                    document2.setPageSize(reader.getPageSizeWithRotation(++i));
                    document2.newPage();
                    page = writer2.getImportedPage(reader, i);
                    rotation = reader.getPageRotation(i);
                    if (rotation == 90 || rotation == 270) {
                        cb2.addTemplate((PdfTemplate)page, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, reader.getPageSizeWithRotation(i).getHeight());
                    } else {
                        cb2.addTemplate((PdfTemplate)page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                    }
                    System.out.println("Processed page " + i);
                }
                document1.close();
                document2.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

