/*
 * Decompiled with CFR 0.152.
 */
package org.librepdf.openpdf.examples.fonts.languages;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.toolbox.plugins.watermarker.Watermarker;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Chinese {
    public static void main(String[] args) throws IOException {
        String fontFile = "SourceHanSerifSC-Regular.otf";
        BaseFont baseFont = BaseFont.createFont((String)"SourceHanSerifSC-Regular.otf", (String)"Identity-H", (boolean)false);
        Font chineseFont = new Font(baseFont, 12.0f, 0);
        Document document = new Document();
        ByteArrayOutputStream pdfOutput = new ByteArrayOutputStream();
        PdfWriter.getInstance((Document)document, (OutputStream)pdfOutput);
        document.open();
        document.add((Element)new Chunk("Chinese Poetry: \u4e2d\u6587", chineseFont));
        document.add((Element)new Paragraph("\u674e\u767d\u300a\u8d60\u6c6a\u4f26\u300b", chineseFont));
        document.add((Element)new Paragraph("\u674e\u767d\u4e58\u821f\u5c06\u6b32\u884c\uff0c", chineseFont));
        document.add((Element)new Paragraph("\u5ffd\u95fb\u5cb8\u4e0a\u8e0f\u6b4c\u58f0\u3002", chineseFont));
        document.add((Element)new Paragraph("\u6843\u82b1\u6f6d\u6c34\u6df1\u5343\u5c3a\uff0c", chineseFont));
        document.add((Element)new Paragraph("\u4e0d\u53ca\u6c6a\u4f26\u9001\u6211\u884c\u3002", chineseFont));
        document.close();
        String watermark = "\u6c34\u5370 (Watermark)";
        byte[] pdfBytesWithWaterMark = new Watermarker(pdfOutput.toByteArray(), watermark, 64, 0.3f).withColor(Color.RED).withFont(chineseFont.getBaseFont()).write();
        Path target = Paths.get(Chinese.class.getSimpleName() + ".pdf", new String[0]);
        Files.write(target, pdfBytesWithWaterMark, new OpenOption[0]);
    }
}

