/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;

public class RemoveLaunchApplication
extends AbstractTool {
    public RemoveLaunchApplication() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file from which you want to remove Launch Application actions", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the cleaned up version of the original PDF has to be written", true, new PdfFilter()));
    }

    public static void main(String[] args) {
        RemoveLaunchApplication tool = new RemoveLaunchApplication();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Remove Launch Applications", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Remove Launch Applications OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File dest = (File)this.getValue("destfile");
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            for (int i = 1; i < reader.getXrefSize(); ++i) {
                PdfDictionary l;
                PdfDictionary d;
                PdfObject o = reader.getPdfObject(i);
                if (!(o instanceof PdfDictionary) || (o = (d = (PdfDictionary)o).get(PdfName.A)) == null) continue;
                if (o instanceof PdfDictionary) {
                    l = (PdfDictionary)o;
                } else {
                    PRIndirectReference r = (PRIndirectReference)o;
                    l = (PdfDictionary)reader.getPdfObject(r.getNumber());
                }
                PdfName n = (PdfName)l.get(PdfName.S);
                if (!PdfName.LAUNCH.equals((Object)n)) continue;
                if (l.get(PdfName.F) != null) {
                    System.out.println("Removed: " + String.valueOf(l.get(PdfName.F)));
                    l.remove(PdfName.F);
                }
                if (l.get(PdfName.WIN) != null) {
                    System.out.println("Removed: " + String.valueOf(l.get(PdfName.WIN)));
                    l.remove(PdfName.WIN);
                }
                l.put(PdfName.S, (PdfObject)PdfName.JAVASCRIPT);
                l.put(PdfName.JS, (PdfObject)new PdfString("app.alert('Launch Application Action removed by iText');\r"));
            }
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(dest));
            stamper.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        RemoveLaunchApplication.addVersion("$Id: RemoveLaunchApplication.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

