/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments;

import com.lowagie.toolbox.AbstractTool;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractArgument
implements ActionListener,
PropertyChangeListener {
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected Object value = null;
    protected String name;
    protected AbstractTool tool;
    protected String description;

    public AbstractArgument() {
    }

    public AbstractArgument(AbstractTool tool, String name, String description, Object value) {
        this.tool = tool;
        this.name = name;
        this.description = description;
        this.value = value;
    }

    protected synchronized void firePropertyChange(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(evt);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        Object oldvalue = this.value;
        this.value = value;
        this.tool.valueHasChanged(this);
        this.firePropertyChange(new PropertyChangeEvent(this, this.name, oldvalue, this.value));
    }

    public void setValue(Object value, String propertyname) {
        Object oldvalue = this.value;
        this.value = value;
        this.tool.valueHasChanged(this);
        this.firePropertyChange(new PropertyChangeEvent(this, propertyname, oldvalue, this.value));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUsage() {
        StringBuilder buf = new StringBuilder("  ");
        buf.append(this.name);
        buf.append(" -  ");
        buf.append(this.description);
        buf.append('\n');
        return buf.toString();
    }

    public AbstractTool getTool() {
        return this.tool;
    }

    public void setTool(AbstractTool tool) {
        this.tool = tool;
    }

    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        System.out.println("AbstractArgument PropertyChange");
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    public String toString() {
        return this.getValue().toString();
    }
}

