/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.ColorArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.ImageArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DvdCover
extends AbstractTool {
    public DvdCover() {
        this.menuoptions = 7;
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new StringArgument(this, "title", "The title of the DVD"));
        this.arguments.add(new ColorArgument(this, "backgroundcolor", "The backgroundcolor of the DVD Cover (for instance 0xFFFFFF)"));
        this.arguments.add(new ImageArgument(this, "front", "The front image of the DVD Cover"));
        this.arguments.add(new ImageArgument(this, "back", "The back image of the DVD Cover"));
        this.arguments.add(new ImageArgument(this, "side", "The side image of the DVD Cover"));
    }

    public static void main(String[] args) {
        DvdCover tool = new DvdCover();
        if (args.length == 0) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Make your own DVD Cover", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== DvdCover OPENED ===");
    }

    @Override
    public void execute() {
        try {
            Rectangle pageSize = new Rectangle(780.0f, 525.0f);
            if (this.getValue("backgroundcolor") != null) {
                pageSize.setBackgroundColor((Color)this.getValue("backgroundcolor"));
            }
            Document document = new Document(pageSize);
            if (this.getValue("destfile") == null) {
                throw new DocumentException("You must provide a destination file!");
            }
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream((File)this.getValue("destfile")));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            if (this.getValue("title") != null) {
                cb.setFontAndSize(BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false), 24.0f);
                cb.beginText();
                if (this.getValue("front") == null) {
                    cb.showTextAligned(1, (String)this.getValue("title"), 595.0f, 262.0f, 0.0f);
                }
                if (this.getValue("side") == null) {
                    cb.showTextAligned(1, (String)this.getValue("title"), 385.0f, 262.0f, 270.0f);
                }
                cb.endText();
            }
            cb.moveTo(370.0f, 0.0f);
            cb.lineTo(370.0f, 525.0f);
            cb.moveTo(410.0f, 525.0f);
            cb.lineTo(410.0f, 0.0f);
            cb.stroke();
            if (this.getValue("front") != null) {
                Image front = (Image)this.getValue("front");
                front.scaleToFit(370.0f, 525.0f);
                front.setAbsolutePosition(410.0f + (370.0f - front.getScaledWidth()) / 2.0f, (525.0f - front.getScaledHeight()) / 2.0f);
                document.add((Element)front);
            }
            if (this.getValue("back") != null) {
                Image back = (Image)this.getValue("back");
                back.scaleToFit(370.0f, 525.0f);
                back.setAbsolutePosition((370.0f - back.getScaledWidth()) / 2.0f, (525.0f - back.getScaledHeight()) / 2.0f);
                document.add((Element)back);
            }
            if (this.getValue("side") != null) {
                Image side = (Image)this.getValue("side");
                side.scaleToFit(40.0f, 525.0f);
                side.setAbsolutePosition(370.0f + (40.0f - side.getScaledWidth()) / 2.0f, (525.0f - side.getScaledHeight()) / 2.0f);
                document.add((Element)side);
            }
            document.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        DvdCover.addVersion("$Id: DvdCover.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

