/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.pdf.PdfEncryptor;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.BitsetArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.OptionArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Encrypt
extends AbstractTool {
    private static final int[] PERMISSIONS = new int[]{2052, 8, 16, 32, 256, 512, 1024, 4};
    private static final String[] PERMISSION_OPTIONS = new String[]{"AllowPrinting", "AllowModifyContents", "AllowCopy", "AllowModifyAnnotations", "AllowFillIn (128 bit only)", "AllowScreenReaders (128 bit only)", "AllowAssembly (128 bit only)", "AllowDegradedPrinting (128 bit only)"};

    public Encrypt() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to encrypt", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the encrypted PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new StringArgument(this, "ownerpassword", "The ownerpassword you want to add to the PDF file"));
        this.arguments.add(new StringArgument(this, "userpassword", "The userpassword you want to add to the PDF file"));
        this.arguments.add(new BitsetArgument((AbstractTool)this, "permissions", "Permissions on the file", PERMISSION_OPTIONS));
        OptionArgument oa = new OptionArgument(this, "strength", "Strength of the encryption");
        oa.addOption("40 bit encryption", "40");
        oa.addOption("128 bit encryption", "128");
        this.arguments.add(oa);
    }

    public static void main(String[] args) {
        Encrypt tool = new Encrypt();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Encrypt", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Encrypt OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            int permissions = 0;
            String p = (String)this.getValue("permissions");
            if (p != null) {
                for (int k = 0; k < p.length(); ++k) {
                    permissions |= p.charAt(k) == '0' ? 0 : PERMISSIONS[k];
                }
            }
            byte[] userpassword = null;
            if (this.getValue("userpassword") != null) {
                userpassword = ((String)this.getValue("userpassword")).getBytes();
            }
            byte[] ownerpassword = null;
            if (this.getValue("ownerpassword") != null) {
                ownerpassword = ((String)this.getValue("ownerpassword")).getBytes();
            }
            PdfReader reader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath());
            PdfEncryptor.encrypt((PdfReader)reader, (OutputStream)new FileOutputStream((File)this.getValue("destfile")), (byte[])userpassword, (byte[])ownerpassword, (int)permissions, (boolean)"128".equals(this.getValue("strength")));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        Encrypt.addVersion("$Id: Encrypt.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

